/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.psi.MarkdownElementVisitor;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeader;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeader$special$;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeaderContent;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeaderImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownImage;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownInlineLink;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownLinkText;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.intellij.plugins.markdown.lang.stubs.impl.MarkdownHeaderStubElement;
import org.intellij.plugins.markdown.lang.stubs.impl.MarkdownHeaderStubElementType;
import org.intellij.plugins.markdown.structureView.MarkdownStructureColors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 22\u00020\u0001:\u00012B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\u001b\u001a\u00020\u001cH\u0002J\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\u001e\u001a\u00020\u001cH\u0007J\n\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J\n\u0010!\u001a\u0004\u0018\u00010\u000bH\u0002J\n\u0010\"\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010#\u001a\u00020$H\u0016J\u0015\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010'0&H\u0016\u00a2\u0006\u0002\u0010(J*\u0010)\u001a\u00020\u00172\n\u0010*\u001a\u00060+j\u0002`,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020 0.2\u0006\u0010\u001e\u001a\u00020\u001cH\u0002J\u0018\u0010/\u001a\u00020\u0017*\u00060+j\u0002`,2\u0006\u00100\u001a\u000201H\u0002R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00063"}, d2={"Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownHeader;", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownHeaderImpl;", "node", "Lcom/intellij/lang/ASTNode;", "(Lcom/intellij/lang/ASTNode;)V", "stub", "Lorg/intellij/plugins/markdown/lang/stubs/impl/MarkdownHeaderStubElement;", "type", "Lorg/intellij/plugins/markdown/lang/stubs/impl/MarkdownHeaderStubElementType;", "(Lorg/intellij/plugins/markdown/lang/stubs/impl/MarkdownHeaderStubElement;Lorg/intellij/plugins/markdown/lang/stubs/impl/MarkdownHeaderStubElementType;)V", "anchorText", "", "getAnchorText", "()Ljava/lang/String;", "contentElement", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownHeaderContent;", "getContentElement", "()Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownHeaderContent;", "level", "", "getLevel", "()I", "accept", "", "visitor", "Lcom/intellij/psi/PsiElementVisitor;", "buildRawAnchorText", "includeStartingHash", "", "buildVisibleText", "hideImages", "findContentHolder", "Lcom/intellij/psi/PsiElement;", "getHeaderText", "getName", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getReferences", "", "Lcom/intellij/psi/PsiReference;", "()[Lcom/intellij/psi/PsiReference;", "traverseNameText", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "elements", "Lkotlin/sequences/Sequence;", "processInlineLink", "element", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownInlineLink;", "Companion", "intellij.markdown.core"})
public final class MarkdownHeader
extends MarkdownHeaderImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex garbageRegex = new Regex("[^\\p{IsAlphabetic}\\d\\- ]");
    @NotNull
    private static final Regex additionalSymbolsRegex = new Regex("[^\\-_ \\p{IsAlphabetic}\\d]");

    public MarkdownHeader(@NotNull ASTNode node) {
        super(node);
    }

    public MarkdownHeader(@NotNull MarkdownHeaderStubElement stub, @NotNull MarkdownHeaderStubElementType type) {
        super(stub, type);
    }

    public final int getLevel() {
        return this.calculateHeaderLevel();
    }

    @Nullable
    public final String getAnchorText() {
        return Companion.obtainAnchorText(this);
    }

    @Nullable
    public final MarkdownHeaderContent getContentElement() {
        Sequence<PsiElement> $this$filterIsInstance$iv = PsiUtilsKt.childrenOfType((PsiElement)this, MarkdownTokenTypeSets.HEADER_CONTENT);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter($this$filterIsInstance$iv, (Function1)special$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        return (MarkdownHeaderContent)SequencesKt.firstOrNull((Sequence)sequence);
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof MarkdownElementVisitor) {
            ((MarkdownElementVisitor)visitor2).visitHeader(this);
        } else {
            super.accept(visitor2);
        }
    }

    @NotNull
    public PsiReference[] getReferences() {
        return ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)((PsiElement)this));
    }

    @NotNull
    public ItemPresentation getPresentation() {
        String headerText = this.getHeaderText();
        Object object = headerText;
        if (object == null) {
            object = "Invalid header: " + this.getText();
        }
        String text = object;
        return (ItemPresentation)new ColoredItemPresentation(this, text){
            final /* synthetic */ MarkdownHeader this$0;
            final /* synthetic */ String $text;
            {
                this.this$0 = $receiver;
                this.$text = $text;
            }

            @NotNull
            public String getPresentableText() {
                PsiElement prevSibling = this.this$0.getPrevSibling();
                if (Registry.is((String)"markdown.structure.view.list.visibility") && MarkdownTokenTypeSets.LIST_MARKERS.contains(PsiTreeUtilKt.getElementType((PsiElement)prevSibling))) {
                    return prevSibling.getText() + this.$text;
                }
                return this.$text;
            }

            @Nullable
            public Icon getIcon(boolean open) {
                return null;
            }

            @Nullable
            public TextAttributesKey getTextAttributesKey() {
                return this.this$0.getLevel() == 1 ? MarkdownStructureColors.MARKDOWN_HEADER_BOLD : MarkdownStructureColors.MARKDOWN_HEADER;
            }
        };
    }

    @Nullable
    public String getName() {
        return this.getHeaderText();
    }

    private final PsiElement findContentHolder() {
        return this.findChildByType(MarkdownTokenTypeSets.INLINE_HOLDING_ELEMENT_TYPES);
    }

    private final String getHeaderText() {
        if (!this.isValid()) {
            return null;
        }
        PsiElement psiElement = this.findContentHolder();
        if (psiElement == null) {
            return null;
        }
        PsiElement contentHolder = psiElement;
        return StringUtil.trim((String)contentHolder.getText());
    }

    @ApiStatus.Experimental
    @Nullable
    public final String buildVisibleText(boolean hideImages) {
        PsiElement psiElement = this.findContentHolder();
        if (psiElement == null) {
            return null;
        }
        PsiElement contentHolder = psiElement;
        StringBuilder builder = new StringBuilder();
        Sequence children2 = SequencesKt.dropWhile(PsiUtilsKt.children(contentHolder), (Function1)buildVisibleText.children.1.INSTANCE);
        this.traverseNameText(builder, (Sequence<? extends PsiElement>)children2, hideImages);
        char[] cArray = new char[]{' '};
        return StringsKt.trim((String)builder.toString(), (char[])cArray);
    }

    public static /* synthetic */ String buildVisibleText$default(MarkdownHeader markdownHeader, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return markdownHeader.buildVisibleText(bl);
    }

    private final void traverseNameText(StringBuilder builder, Sequence<? extends PsiElement> elements2, boolean hideImages) {
        for (PsiElement child2 : elements2) {
            PsiElement psiElement = child2;
            if (psiElement instanceof LeafPsiElement) {
                builder.append(((LeafPsiElement)child2).getText());
                continue;
            }
            if (psiElement instanceof MarkdownInlineLink) {
                MarkdownLinkText markdownLinkText = ((MarkdownInlineLink)child2).getLinkText();
                Object object = markdownLinkText != null ? markdownLinkText.getContentElements() : null;
                if (object == null) {
                    object = SequencesKt.emptySequence();
                }
                this.traverseNameText(builder, (Sequence<? extends PsiElement>)object, hideImages);
                continue;
            }
            if (psiElement instanceof MarkdownImage) {
                if (hideImages) continue;
                builder.append(((MarkdownImage)child2).getText());
                continue;
            }
            this.traverseNameText(builder, PsiUtilsKt.children(child2), hideImages);
        }
    }

    private final String buildRawAnchorText(boolean includeStartingHash) {
        StringBuilder stringBuilder;
        PsiElement psiElement = this.findContentHolder();
        if (psiElement == null) {
            return null;
        }
        PsiElement contentHolder = psiElement;
        Sequence children2 = SequencesKt.filter(PsiUtilsKt.children(contentHolder), (Function1)buildRawAnchorText.children.1.INSTANCE);
        StringBuilder $this$buildRawAnchorText_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (includeStartingHash) {
            $this$buildRawAnchorText_u24lambda_u240.append("#");
        }
        int count = 0;
        for (PsiElement child2 : children2) {
            PsiElement psiElement2;
            if (count >= 1) {
                $this$buildRawAnchorText_u24lambda_u240.append(" ");
            }
            if ((psiElement2 = child2) instanceof MarkdownImage) {
                $this$buildRawAnchorText_u24lambda_u240.append("");
            } else if (psiElement2 instanceof MarkdownInlineLink) {
                this.processInlineLink($this$buildRawAnchorText_u24lambda_u240, (MarkdownInlineLink)child2);
            } else {
                $this$buildRawAnchorText_u24lambda_u240.append(child2.getText());
            }
            ++count;
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String text = string;
        String string2 = text.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        CharSequence charSequence = string2;
        Regex regex = garbageRegex;
        String string3 = "";
        charSequence = regex.replace(charSequence, string3);
        regex = additionalSymbolsRegex;
        string3 = "";
        String replaced = regex.replace(charSequence, string3);
        return StringsKt.replace$default((String)replaced, (String)" ", (String)"-", (boolean)false, (int)4, null);
    }

    static /* synthetic */ String buildRawAnchorText$default(MarkdownHeader markdownHeader, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return markdownHeader.buildRawAnchorText(bl);
    }

    private final void processInlineLink(StringBuilder $this$processInlineLink, MarkdownInlineLink element2) {
        MarkdownLinkText markdownLinkText = element2.getLinkText();
        Object object = markdownLinkText != null ? markdownLinkText.getContentElements() : null;
        if (object == null) {
            object = SequencesKt.emptySequence();
        }
        Sequence contentElements2 = object;
        Sequence withoutWhitespaces2 = SequencesKt.filterNot((Sequence)contentElements2, (Function1)processInlineLink.withoutWhitespaces.1.INSTANCE);
        SequencesKt.joinTo$default((Sequence)withoutWhitespaces2, (Appendable)$this$processInlineLink, (CharSequence)" ", null, null, (int)0, null, (Function1)processInlineLink.1.INSTANCE, (int)60, null);
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final String createUniqueAnchorText(@NotNull String rawAnchorText, int occurenceNumber) {
        return Companion.createUniqueAnchorText(rawAnchorText, occurenceNumber);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u0018\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u000eH\u0007J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownHeader$Companion;", "", "()V", "additionalSymbolsRegex", "Lkotlin/text/Regex;", "getAdditionalSymbolsRegex$intellij_markdown_core", "()Lkotlin/text/Regex;", "garbageRegex", "getGarbageRegex$intellij_markdown_core", "buildUniqueAnchorText", "", "header", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownHeader;", "calculateUniqueNumber", "", "rawAnchorText", "createUniqueAnchorText", "occurenceNumber", "obtainAnchorText", "obtainRawAnchorText", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getGarbageRegex$intellij_markdown_core() {
            return garbageRegex;
        }

        @NotNull
        public final Regex getAdditionalSymbolsRegex$intellij_markdown_core() {
            return additionalSymbolsRegex;
        }

        private final String buildUniqueAnchorText(MarkdownHeader header) {
            String string = this.obtainRawAnchorText(header);
            if (string == null) {
                return null;
            }
            String anchorText = string;
            int number = this.calculateUniqueNumber(header, anchorText);
            return this.createUniqueAnchorText(anchorText, number);
        }

        /*
         * WARNING - void declaration
         */
        private final int calculateUniqueNumber(MarkdownHeader header, String rawAnchorText) {
            void $this$filterTo$iv$iv;
            PsiFile file = header.getContainingFile();
            List headers = (List)CachedValuesManager.getCachedValue((PsiElement)((PsiElement)file), () -> Companion.calculateUniqueNumber$lambda$0(file));
            Iterable $this$filter$iv = headers;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                MarkdownHeader it = (MarkdownHeader)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)Companion.obtainRawAnchorText(it), (Object)rawAnchorText)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List sameHeaders = (List)destination$iv$iv;
            Iterable $this$takeWhile$iv = sameHeaders;
            boolean $i$f$takeWhile = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$takeWhile$iv) {
                MarkdownHeader it = (MarkdownHeader)item$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)header))) break;
                list$iv.add(item$iv);
            }
            return ((Collection)list$iv).size();
        }

        @JvmStatic
        @ApiStatus.Internal
        @NotNull
        public final String createUniqueAnchorText(@NotNull String rawAnchorText, int occurenceNumber) {
            return occurenceNumber == 0 ? rawAnchorText : rawAnchorText + "-" + occurenceNumber;
        }

        @Nullable
        public final String obtainAnchorText(@NotNull MarkdownHeader header) {
            return (String)CachedValuesManager.getCachedValue((PsiElement)((PsiElement)header), () -> Companion.obtainAnchorText$lambda$3(header));
        }

        private final String obtainRawAnchorText(MarkdownHeader header) {
            return (String)CachedValuesManager.getCachedValue((PsiElement)((PsiElement)header), () -> Companion.obtainRawAnchorText$lambda$4(header));
        }

        /*
         * WARNING - void declaration
         */
        private static final CachedValueProvider.Result calculateUniqueNumber$lambda$0(PsiFile $file) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = (Iterable)SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)$file));
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof MarkdownHeader)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
            return CachedValueProvider.Result.create((Object)((List)destination$iv$iv), (Object[])objectArray);
        }

        private static final CachedValueProvider.Result obtainAnchorText$lambda$3(MarkdownHeader $header) {
            Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
            return CachedValueProvider.Result.create((Object)Companion.buildUniqueAnchorText($header), (Object[])objectArray);
        }

        private static final CachedValueProvider.Result obtainRawAnchorText$lambda$4(MarkdownHeader $header) {
            Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
            return CachedValueProvider.Result.create((Object)$header.buildRawAnchorText(false), (Object[])objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

