/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.psi.impl;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.parser.frontmatter.FrontMatterContentLanguage;
import org.intellij.plugins.markdown.lang.parser.frontmatter.FrontMatterHeaderMarkerProvider;
import org.intellij.plugins.markdown.lang.parser.frontmatter.FrontMatterLanguages;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElement;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElementFactory;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFrontMatterHeader$Manipulator$handleContentChange$;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFrontMatterHeaderContent;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.intellij.plugins.markdown.util.MarkdownPsiUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u0013B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\fH\u0016J\b\u0010\r\u001a\u00020\bH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownFrontMatterHeader;", "Lcom/intellij/psi/impl/source/tree/CompositePsiElement;", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "Lorg/intellij/plugins/markdown/lang/psi/MarkdownPsiElement;", "type", "Lcom/intellij/psi/tree/IElementType;", "(Lcom/intellij/psi/tree/IElementType;)V", "contentLanguage", "Lorg/intellij/plugins/markdown/lang/parser/frontmatter/FrontMatterContentLanguage;", "getContentLanguage", "()Lorg/intellij/plugins/markdown/lang/parser/frontmatter/FrontMatterContentLanguage;", "createLiteralTextEscaper", "Lcom/intellij/psi/LiteralTextEscaper;", "determineContentLanguage", "isValidHost", "", "updateText", "text", "", "Manipulator", "intellij.markdown.core"})
@ApiStatus.Experimental
public final class MarkdownFrontMatterHeader
extends CompositePsiElement
implements PsiLanguageInjectionHost,
MarkdownPsiElement {
    public MarkdownFrontMatterHeader(@NotNull IElementType type) {
        super(type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValidHost() {
        Object e;
        PsiElement it;
        Sequence children2;
        Sequence $this$count$iv = children2 = PsiTreeUtilKt.siblings((PsiElement)this.getFirstChild(), (boolean)true, (boolean)true);
        boolean $i$f$count = false;
        int count$iv = 0;
        for (Object element$iv : $this$count$iv) {
            PsiElement it2 = (PsiElement)element$iv;
            boolean bl = false;
            if (!MarkdownPsiUtil.WhiteSpaces.isNewLine(it2) || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        int newlines = count$iv;
        if (newlines < 2) return false;
        Sequence sequence = children2;
        Iterator iterator = sequence.iterator();
        do {
            if (!iterator.hasNext()) return false;
            e = iterator.next();
            it = (PsiElement)e;
            boolean bl = false;
        } while (!PsiUtilsKt.hasType(it, MarkdownElementTypes.FRONT_MATTER_HEADER_CONTENT));
        Object v0 = e;
        if (v0 == null) return false;
        return true;
    }

    @NotNull
    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        return (PsiLanguageInjectionHost)ElementManipulators.handleContentChange((PsiElement)((PsiElement)this), (String)text);
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        return LiteralTextEscaper.createSimple((PsiLanguageInjectionHost)this);
    }

    @NotNull
    public final FrontMatterContentLanguage getContentLanguage() {
        return this.determineContentLanguage();
    }

    private final FrontMatterContentLanguage determineContentLanguage() {
        List delimiters = SequencesKt.toList(PsiUtilsKt.childrenOfType((PsiElement)this, MarkdownElementTypes.FRONT_MATTER_HEADER_DELIMITER));
        if (!(delimiters.size() == 2)) {
            boolean $i$a$-check-MarkdownFrontMatterHeader$determineContentLanguage$22 = false;
            String $i$a$-check-MarkdownFrontMatterHeader$determineContentLanguage$22 = "Unexpected number of delimiters: " + delimiters.size();
            throw new IllegalStateException($i$a$-check-MarkdownFrontMatterHeader$determineContentLanguage$22.toString());
        }
        String opening = ((PsiElement)delimiters.get(0)).getText();
        String closing = ((PsiElement)delimiters.get(1)).getText();
        if (FrontMatterHeaderMarkerProvider.Companion.isYamlDelimiterLine(opening) && FrontMatterHeaderMarkerProvider.Companion.isYamlDelimiterLine(closing)) {
            return FrontMatterLanguages.INSTANCE.getYAML();
        }
        if (FrontMatterHeaderMarkerProvider.Companion.isTomlDelimiterLine(opening) && FrontMatterHeaderMarkerProvider.Companion.isTomlDelimiterLine(closing)) {
            return FrontMatterLanguages.INSTANCE.getTOML();
        }
        throw new IllegalStateException(("Failed to match opening (" + opening + ") and closing (" + closing + ") delimiters to determine content language").toString());
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownFrontMatterHeader$Manipulator;", "Lcom/intellij/psi/AbstractElementManipulator;", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownFrontMatterHeader;", "()V", "handleContentChange", "element", "range", "Lcom/intellij/openapi/util/TextRange;", "content", "", "intellij.markdown.core"})
    public static final class Manipulator
    extends AbstractElementManipulator<MarkdownFrontMatterHeader> {
        @Nullable
        public MarkdownFrontMatterHeader handleContentChange(@NotNull MarkdownFrontMatterHeader element2, @NotNull TextRange range, @NotNull String content2) {
            Sequence children2;
            if (StringsKt.contains$default((CharSequence)content2, (CharSequence)"---", (boolean)false, (int)2, null)) {
                MarkdownFrontMatterHeader markdownFrontMatterHeader;
                MarkdownPsiElement textElement = MarkdownPsiElementFactory.createTextElement(element2.getProject(), content2);
                if (textElement instanceof MarkdownFrontMatterHeader) {
                    PsiElement psiElement = element2.replace((PsiElement)textElement);
                    Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.intellij.plugins.markdown.lang.psi.impl.MarkdownFrontMatterHeader");
                    markdownFrontMatterHeader = (MarkdownFrontMatterHeader)psiElement;
                } else {
                    markdownFrontMatterHeader = null;
                }
                return markdownFrontMatterHeader;
            }
            Sequence $this$filterIsInstance$iv = children2 = PsiTreeUtilKt.siblings((PsiElement)element2.getFirstChild(), (boolean)true, (boolean)true);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)Manipulator$handleContentChange$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            MarkdownFrontMatterHeaderContent markdownFrontMatterHeaderContent = (MarkdownFrontMatterHeaderContent)SequencesKt.firstOrNull((Sequence)sequence);
            if (markdownFrontMatterHeaderContent == null) {
                return null;
            }
            MarkdownFrontMatterHeaderContent contentElement = markdownFrontMatterHeaderContent;
            TextRange shiftedRange = range.shiftLeft(contentElement.getStartOffsetInParent());
            String updatedText = shiftedRange.replace(contentElement.getText(), content2);
            contentElement.replaceWithText(updatedText);
            return element2;
        }
    }
}

