/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.psi.impl;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import java.util.Arrays;
import java.util.List;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElement;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCompositePsiElement;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownParagraph;
import org.intellij.plugins.markdown.structureView.MarkdownBasePresentation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MarkdownCompositePsiElementBase
extends ASTWrapperPsiElement
implements MarkdownCompositePsiElement {
    public static final int PRESENTABLE_TEXT_LENGTH = 50;

    public MarkdownCompositePsiElementBase(@NotNull ASTNode node) {
        super(node);
    }

    @NotNull
    protected CharSequence getChars() {
        return this.getTextRange().subSequence(this.getContainingFile().getViewProvider().getContents());
    }

    @NotNull
    protected String shrinkTextTo(int length) {
        CharSequence chars = this.getChars();
        return chars.subSequence(0, Math.min(length, chars.length())).toString();
    }

    @Override
    @NotNull
    public List<MarkdownPsiElement> getCompositeChildren() {
        return Arrays.asList((MarkdownPsiElement[])this.findChildrenByClass(MarkdownPsiElement.class));
    }

    public boolean hasTrivialChildren() {
        List<MarkdownPsiElement> children2 = this.getCompositeChildren();
        if (children2.size() != 1) {
            return false;
        }
        return children2.iterator().next() instanceof MarkdownParagraph;
    }

    public ItemPresentation getPresentation() {
        return new MarkdownBasePresentation(){

            @Nullable
            public String getPresentableText() {
                if (!MarkdownCompositePsiElementBase.this.isValid()) {
                    return null;
                }
                return MarkdownCompositePsiElementBase.this.getPresentableTagName();
            }

            @Nullable
            public String getLocationString() {
                if (!MarkdownCompositePsiElementBase.this.isValid()) {
                    return null;
                }
                if (MarkdownCompositePsiElementBase.this.getCompositeChildren().size() == 0) {
                    return MarkdownCompositePsiElementBase.this.shrinkTextTo(50);
                }
                return null;
            }
        };
    }
}

