/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.parser.frontmatter;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockImpl;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.plugins.markdown.lang.parser.frontmatter.FrontMatterHeaderMarkerProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B)\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0010\u001a\u00020\u000fH\u0016J\u0014\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u00060\u0003R\u00020\u0004H\u0014J\u001c\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u00060\u0003R\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0006H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\nH\u0002J\u0014\u0010\u001e\u001a\u00020\u000f2\n\u0010\u0013\u001a\u00060\u0003R\u00020\u0004H\u0016R\u0012\u0010\f\u001a\u00060\u0003R\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0018\u00010\u0003R\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u00060\u0003R\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/intellij/plugins/markdown/lang/parser/frontmatter/FrontMatterHeaderBlock;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockImpl;", "startPosition", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "openingDelimiterText", "", "(Lorg/intellij/markdown/parser/LookaheadText$Position;Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;Lorg/intellij/markdown/parser/ProductionHolder;Ljava/lang/String;)V", "closingDelimiterPosition", "lastContentPosition", "shouldClose", "", "allowsSubBlocks", "calcNextInterestingOffset", "", "pos", "doProcessToken", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ProcessingResult;", "position", "currentConstraints", "getDefaultAction", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ClosingAction;", "getDefaultNodeType", "Lorg/intellij/markdown/IElementType;", "isDelimiterLine", "line", "isInterestingOffset", "intellij.markdown.core"})
public final class FrontMatterHeaderBlock
extends MarkerBlockImpl {
    @NotNull
    private final LookaheadText.Position startPosition;
    @NotNull
    private final ProductionHolder productionHolder;
    @NotNull
    private final String openingDelimiterText;
    @Nullable
    private LookaheadText.Position lastContentPosition;
    private LookaheadText.Position closingDelimiterPosition;
    private boolean shouldClose;

    public FrontMatterHeaderBlock(@NotNull LookaheadText.Position startPosition, @NotNull MarkdownConstraints constraints, @NotNull ProductionHolder productionHolder, @NotNull String openingDelimiterText) {
        super(constraints, productionHolder.mark());
        this.startPosition = startPosition;
        this.productionHolder = productionHolder;
        this.openingDelimiterText = openingDelimiterText;
        IntRange range = new IntRange(this.startPosition.getOffset(), this.startPosition.getNextLineOrEofOffset());
        SequentialParser.Node delimiterNode = new SequentialParser.Node(range, (IElementType)FrontMatterHeaderMarkerProvider.FRONT_MATTER_HEADER_DELIMITER);
        this.productionHolder.addProduction((Collection)CollectionsKt.listOf((Object)delimiterNode));
    }

    public boolean allowsSubBlocks() {
        return false;
    }

    protected int calcNextInterestingOffset(@NotNull LookaheadText.Position pos) {
        return pos.getNextLineOrEofOffset();
    }

    @NotNull
    protected MarkerBlock.ProcessingResult doProcessToken(@NotNull LookaheadText.Position position, @NotNull MarkdownConstraints currentConstraints) {
        if (this.shouldClose) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        if (!this.isDelimiterLine(position.getCurrentLine())) {
            this.lastContentPosition = position;
            return MarkerBlock.ProcessingResult.Companion.getCANCEL();
        }
        LookaheadText.Position position2 = this.startPosition.nextLinePosition();
        if (position2 == null) {
            return MarkerBlock.ProcessingResult.Companion.getPASS();
        }
        LookaheadText.Position secondLinePosition = position2;
        Integer n = secondLinePosition.charsToNonWhitespace();
        int contentStartOffset = secondLinePosition.getOffset() + (n != null ? n : 0);
        if (this.lastContentPosition == null) {
            return MarkerBlock.ProcessingResult.Companion.getPASS();
        }
        this.closingDelimiterPosition = position;
        LookaheadText.Position position3 = this.lastContentPosition;
        Intrinsics.checkNotNull((Object)position3);
        IntRange contentRange = new IntRange(contentStartOffset, position3.getNextLineOrEofOffset());
        SequentialParser.Node contentNode = new SequentialParser.Node(contentRange, (IElementType)FrontMatterHeaderMarkerProvider.FRONT_MATTER_HEADER_CONTENT);
        Integer n2 = position.charsToNonWhitespace();
        int delimiterStartOffset = position.getOffset() + (n2 != null ? n2 : 0);
        IntRange closingDelimiterRange = new IntRange(delimiterStartOffset, position.getNextLineOrEofOffset());
        SequentialParser.Node delimiterNode = new SequentialParser.Node(closingDelimiterRange, (IElementType)FrontMatterHeaderMarkerProvider.FRONT_MATTER_HEADER_DELIMITER);
        Object[] objectArray = new SequentialParser.Node[]{contentNode, delimiterNode};
        this.productionHolder.addProduction((Collection)CollectionsKt.listOf((Object[])objectArray));
        this.shouldClose = true;
        return MarkerBlock.ProcessingResult.Companion.getCANCEL();
    }

    private final boolean isDelimiterLine(String line) {
        return FrontMatterHeaderMarkerProvider.Companion.isDelimiterLine(line) && Intrinsics.areEqual((Object)line, (Object)this.openingDelimiterText);
    }

    @NotNull
    protected MarkerBlock.ClosingAction getDefaultAction() {
        return MarkerBlock.ClosingAction.DONE;
    }

    @NotNull
    public IElementType getDefaultNodeType() {
        return (IElementType)FrontMatterHeaderMarkerProvider.FRONT_MATTER_HEADER;
    }

    public boolean isInterestingOffset(@NotNull LookaheadText.Position pos) {
        return pos.getOffsetInCurrentLine() == -1;
    }
}

