/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.parser;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.Key;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.parser.MarkdownParser;
import org.intellij.plugins.markdown.lang.parser.GFMCommentAwareFlavourDescriptor;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0002\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0007R\u0016\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/intellij/plugins/markdown/lang/parser/MarkdownParserManager;", "Lcom/intellij/openapi/Disposable;", "()V", "lastParsingResult", "Ljava/util/concurrent/atomic/AtomicReference;", "Lorg/intellij/plugins/markdown/lang/parser/MarkdownParserManager$ParsingResult;", "dispose", "", "parse", "Lorg/intellij/markdown/ast/ASTNode;", "buffer", "", "flavour", "Lorg/intellij/markdown/flavours/MarkdownFlavourDescriptor;", "Companion", "ParsingResult", "intellij.markdown.core"})
public final class MarkdownParserManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicReference<ParsingResult> lastParsingResult = new AtomicReference();
    @JvmField
    @NotNull
    public static final Key<MarkdownFlavourDescriptor> FLAVOUR_DESCRIPTION = Key.create((String)"Markdown.Flavour");
    @JvmField
    @NotNull
    public static final GFMCommentAwareFlavourDescriptor FLAVOUR = new GFMCommentAwareFlavourDescriptor(null, 1, null);

    @JvmOverloads
    @NotNull
    public final ASTNode parse(@NotNull CharSequence buffer, @NotNull MarkdownFlavourDescriptor flavour) {
        ParsingResult info = this.lastParsingResult.get();
        if (info != null && info.getBufferHash() == buffer.hashCode() && Intrinsics.areEqual((Object)info.getBuffer(), (Object)buffer)) {
            return info.getTree();
        }
        ASTNode parseResult = new MarkdownParser(flavour).parse(MarkdownElementTypes.MARKDOWN_FILE, ((Object)buffer).toString(), false);
        this.lastParsingResult.set(new ParsingResult(buffer, parseResult, 0, 4, null));
        return parseResult;
    }

    public static /* synthetic */ ASTNode parse$default(MarkdownParserManager markdownParserManager, CharSequence charSequence, MarkdownFlavourDescriptor markdownFlavourDescriptor, int n, Object object) {
        if ((n & 2) != 0) {
            markdownFlavourDescriptor = (MarkdownFlavourDescriptor)FLAVOUR;
        }
        return markdownParserManager.parse(charSequence, markdownFlavourDescriptor);
    }

    public void dispose() {
        this.lastParsingResult.set(null);
    }

    @JvmOverloads
    @NotNull
    public final ASTNode parse(@NotNull CharSequence buffer) {
        return MarkdownParserManager.parse$default(this, buffer, null, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final MarkdownParserManager getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ASTNode parseContent(@NotNull CharSequence buffer, @NotNull MarkdownFlavourDescriptor flavour) {
        return Companion.parseContent(buffer, flavour);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ASTNode parseContent(@NotNull CharSequence buffer) {
        return Companion.parseContent(buffer);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/intellij/plugins/markdown/lang/parser/MarkdownParserManager$ParsingResult;", "", "buffer", "", "tree", "Lorg/intellij/markdown/ast/ASTNode;", "bufferHash", "", "(Ljava/lang/CharSequence;Lorg/intellij/markdown/ast/ASTNode;I)V", "getBuffer", "()Ljava/lang/CharSequence;", "getBufferHash", "()I", "getTree", "()Lorg/intellij/markdown/ast/ASTNode;", "intellij.markdown.core"})
    private static final class ParsingResult {
        @NotNull
        private final CharSequence buffer;
        @NotNull
        private final ASTNode tree;
        private final int bufferHash;

        public ParsingResult(@NotNull CharSequence buffer, @NotNull ASTNode tree, int bufferHash) {
            this.buffer = buffer;
            this.tree = tree;
            this.bufferHash = bufferHash;
        }

        public /* synthetic */ ParsingResult(CharSequence charSequence, ASTNode aSTNode, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                n = charSequence.hashCode();
            }
            this(charSequence, aSTNode, n);
        }

        @NotNull
        public final CharSequence getBuffer() {
            return this.buffer;
        }

        @NotNull
        public final ASTNode getTree() {
            return this.tree;
        }

        public final int getBufferHash() {
            return this.bufferHash;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0007J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0007H\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0005\u001a\u0015\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006\u00a2\u0006\u0002\b\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/intellij/plugins/markdown/lang/parser/MarkdownParserManager$Companion;", "", "()V", "FLAVOUR", "Lorg/intellij/plugins/markdown/lang/parser/GFMCommentAwareFlavourDescriptor;", "FLAVOUR_DESCRIPTION", "Lcom/intellij/openapi/util/Key;", "Lorg/intellij/markdown/flavours/MarkdownFlavourDescriptor;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lorg/intellij/plugins/markdown/lang/parser/MarkdownParserManager;", "parseContent", "Lorg/intellij/markdown/ast/ASTNode;", "buffer", "", "flavour", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final MarkdownParserManager getInstance() {
            boolean $i$f$service = false;
            Class<MarkdownParserManager> serviceClass$iv = MarkdownParserManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (MarkdownParserManager)object;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final ASTNode parseContent(@NotNull CharSequence buffer, @NotNull MarkdownFlavourDescriptor flavour) {
            return this.getInstance().parse(buffer, flavour);
        }

        public static /* synthetic */ ASTNode parseContent$default(Companion companion, CharSequence charSequence, MarkdownFlavourDescriptor markdownFlavourDescriptor, int n, Object object) {
            if ((n & 2) != 0) {
                markdownFlavourDescriptor = (MarkdownFlavourDescriptor)FLAVOUR;
            }
            return companion.parseContent(charSequence, markdownFlavourDescriptor);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final ASTNode parseContent(@NotNull CharSequence buffer) {
            return org.intellij.plugins.markdown.lang.parser.MarkdownParserManager$Companion.parseContent$default(this, buffer, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

