/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.lexer;

import com.intellij.lexer.LexerBase;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTNodeKt;
import org.intellij.markdown.ast.visitors.RecursiveVisitor;
import org.intellij.markdown.ast.visitors.Visitor;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.plugins.markdown.lang.MarkdownElementType;
import org.intellij.plugins.markdown.lang.parser.MarkdownParserManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownToplevelLexer
extends LexerBase {
    private CharSequence myBuffer;
    private int myBufferStart;
    private int myBufferEnd;
    private int lastBufferHash = 0;
    private final List<IElementType> myLexemes = new ArrayList<IElementType>();
    private final List<Integer> myStartOffsets = new ArrayList<Integer>();
    private final List<Integer> myEndOffsets = new ArrayList<Integer>();
    private int myLexemeIndex;
    @NotNull
    private final MarkdownFlavourDescriptor flavour;

    public MarkdownToplevelLexer() {
        this((MarkdownFlavourDescriptor)MarkdownParserManager.FLAVOUR);
    }

    public MarkdownToplevelLexer(@NotNull MarkdownFlavourDescriptor flavour) {
        this.flavour = flavour;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        int bufferHash = buffer.hashCode();
        this.myBufferStart = startOffset;
        this.myBufferEnd = endOffset;
        if (bufferHash == this.lastBufferHash && buffer.equals(this.myBuffer)) {
            this.myLexemeIndex = initialState;
            return;
        }
        this.lastBufferHash = bufferHash;
        this.myBuffer = buffer;
        ASTNode parsedTree = MarkdownParserManager.parseContent(buffer.subSequence(startOffset, endOffset), this.flavour);
        this.myLexemes.clear();
        this.myStartOffsets.clear();
        this.myEndOffsets.clear();
        ASTNodeKt.accept((ASTNode)parsedTree, (Visitor)new LexerBuildingVisitor());
        this.myLexemeIndex = 0;
    }

    public int getState() {
        return this.myLexemeIndex;
    }

    @Nullable
    public IElementType getTokenType() {
        if (this.myLexemeIndex >= this.myLexemes.size()) {
            return null;
        }
        return this.myLexemes.get(this.myLexemeIndex);
    }

    public int getTokenStart() {
        if (this.myLexemeIndex >= this.myLexemes.size()) {
            return this.myBufferEnd;
        }
        return this.myBufferStart + this.myStartOffsets.get(this.myLexemeIndex);
    }

    public int getTokenEnd() {
        if (this.myLexemeIndex >= this.myLexemes.size()) {
            return this.myBufferEnd;
        }
        return this.myBufferStart + this.myEndOffsets.get(this.myLexemeIndex);
    }

    public void advance() {
        ++this.myLexemeIndex;
    }

    @NotNull
    public CharSequence getBufferSequence() {
        return this.myBuffer;
    }

    public int getBufferEnd() {
        return this.myBufferEnd;
    }

    private class LexerBuildingVisitor
    extends RecursiveVisitor {
        private LexerBuildingVisitor() {
        }

        public void visitNode(@NotNull ASTNode node) {
            ProgressManager.checkCanceled();
            if (node.getStartOffset() == node.getEndOffset()) {
                return;
            }
            List children2 = node.getChildren();
            if (children2.isEmpty()) {
                MarkdownToplevelLexer.this.myLexemes.add(MarkdownElementType.platformType(node.getType()));
                MarkdownToplevelLexer.this.myStartOffsets.add(node.getStartOffset());
                MarkdownToplevelLexer.this.myEndOffsets.add(node.getEndOffset());
            } else {
                super.visitNode(node);
            }
        }
    }
}

