/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.formatter.blocks;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.common.SettingsAwareBlock;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.injection.MarkdownCodeFenceUtils;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.formatter.blocks.MarkdownBlocks;
import org.intellij.plugins.markdown.lang.formatter.blocks.MarkdownEditingAligner;
import org.intellij.plugins.markdown.lang.formatter.settings.MarkdownCustomCodeStyleSettings;
import org.intellij.plugins.markdown.lang.psi.util.AstUtilsKt;
import org.intellij.plugins.markdown.util.MarkdownPsiStructureUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u0000 #2\u00020\u00012\u00020\u0002:\u0001#B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0006H\u0016J\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001c\u001a\u00020\u0012H\u0016J\u0010\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0004J\f\u0010\"\u001a\u00020\u001f*\u00020\u0004H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006$"}, d2={"Lorg/intellij/plugins/markdown/lang/formatter/blocks/MarkdownFormattingBlock;", "Lcom/intellij/psi/formatter/common/AbstractBlock;", "Lcom/intellij/psi/formatter/common/SettingsAwareBlock;", "node", "Lcom/intellij/lang/ASTNode;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "spacing", "Lcom/intellij/formatting/SpacingBuilder;", "alignment", "Lcom/intellij/formatting/Alignment;", "wrap", "Lcom/intellij/formatting/Wrap;", "(Lcom/intellij/lang/ASTNode;Lcom/intellij/psi/codeStyle/CodeStyleSettings;Lcom/intellij/formatting/SpacingBuilder;Lcom/intellij/formatting/Alignment;Lcom/intellij/formatting/Wrap;)V", "getSpacing", "()Lcom/intellij/formatting/SpacingBuilder;", "buildChildren", "", "Lcom/intellij/formatting/Block;", "getChildAttributes", "Lcom/intellij/formatting/ChildAttributes;", "newChildIndex", "", "getIndent", "Lcom/intellij/formatting/Indent;", "getSettings", "Lcom/intellij/formatting/Spacing;", "child1", "child2", "getSubBlocks", "isLeaf", "", "obtainCustomSettings", "Lorg/intellij/plugins/markdown/lang/formatter/settings/MarkdownCustomCodeStyleSettings;", "canBeFormatted", "Companion", "intellij.markdown.core"})
public class MarkdownFormattingBlock
extends AbstractBlock
implements SettingsAwareBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CodeStyleSettings settings;
    @NotNull
    private final SpacingBuilder spacing;
    @NotNull
    private static final TokenSet NON_ALIGNABLE_LIST_ELEMENTS;

    public MarkdownFormattingBlock(@NotNull ASTNode node, @NotNull CodeStyleSettings settings, @NotNull SpacingBuilder spacing, @Nullable Alignment alignment, @Nullable Wrap wrap) {
        super(node, wrap, alignment);
        this.settings = settings;
        this.spacing = spacing;
    }

    public /* synthetic */ MarkdownFormattingBlock(ASTNode aSTNode, CodeStyleSettings codeStyleSettings, SpacingBuilder spacingBuilder, Alignment alignment, Wrap wrap, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            alignment = null;
        }
        if ((n & 0x10) != 0) {
            wrap = null;
        }
        this(aSTNode, codeStyleSettings, spacingBuilder, alignment, wrap);
    }

    @NotNull
    protected final SpacingBuilder getSpacing() {
        return this.spacing;
    }

    @NotNull
    public CodeStyleSettings getSettings() {
        return this.settings;
    }

    @NotNull
    protected final MarkdownCustomCodeStyleSettings obtainCustomSettings() {
        return (MarkdownCustomCodeStyleSettings)this.settings.getCustomSettings(MarkdownCustomCodeStyleSettings.class);
    }

    public boolean isLeaf() {
        return this.getSubBlocks().isEmpty();
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        return this.spacing.getSpacing((Block)this, child1, child2);
    }

    @Nullable
    public Indent getIndent() {
        if (MarkdownTokenTypeSets.LISTS.contains(this.getNode().getElementType())) {
            boolean bl;
            block3: {
                Sequence<ASTNode> $this$any$iv = AstUtilsKt.parents(this.getNode(), false);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    ASTNode it = (ASTNode)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)MarkdownElementTypes.LIST_ITEM)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            if (bl) {
                return Indent.getNormalIndent();
            }
        }
        return Indent.getNoneIndent();
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        return MarkdownEditingAligner.INSTANCE.calculateChildAttributes((Block)CollectionsKt.getOrNull(this.getSubBlocks(), (int)(newChildIndex - 1)));
    }

    @NotNull
    public List<Block> getSubBlocks() {
        if (MarkdownCodeFenceUtils.INSTANCE.isCodeFence(this.getNode()) && !MarkdownPsiStructureUtil.INSTANCE.isTopLevel$intellij_markdown_core(this.getNode())) {
            return AbstractBlock.EMPTY;
        }
        return super.getSubBlocks();
    }

    @NotNull
    protected List<Block> buildChildren() {
        if (!this.canBeFormatted(this.getNode())) {
            return CollectionsKt.emptyList();
        }
        Alignment newAlignment = Alignment.createAlignment();
        IElementType iElementType = this.getNode().getElementType();
        return Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.CODE_FENCE) ? CollectionsKt.emptyList() : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.FRONT_MATTER_HEADER) ? CollectionsKt.emptyList() : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.LIST_ITEM) ? SequencesKt.toList(MarkdownBlocks.INSTANCE.create(AstUtilsKt.children(this.getNode()), this.settings, this.spacing, (Function1<? super ASTNode, ? extends Alignment>)((Function1)new Function1<ASTNode, Alignment>(this, newAlignment){
            final /* synthetic */ MarkdownFormattingBlock this$0;
            final /* synthetic */ Alignment $newAlignment;
            {
                this.this$0 = $receiver;
                this.$newAlignment = $newAlignment;
                super(1);
            }

            @Nullable
            public final Alignment invoke(@NotNull ASTNode it) {
                return MarkdownFormattingBlock.access$getNON_ALIGNABLE_LIST_ELEMENTS$cp().contains(it.getElementType()) ? this.this$0.getAlignment() : this.$newAlignment;
            }
        }))) : (((Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.PARAGRAPH) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.CODE_BLOCK)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.BLOCK_QUOTE)) ? SequencesKt.toList(MarkdownBlocks.INSTANCE.create(AstUtilsKt.children(this.getNode()), this.settings, this.spacing, (Function1<? super ASTNode, ? extends Alignment>)((Function1)new Function1<ASTNode, Alignment>(this, newAlignment){
            final /* synthetic */ MarkdownFormattingBlock this$0;
            final /* synthetic */ Alignment $newAlignment;
            {
                this.this$0 = $receiver;
                this.$newAlignment = $newAlignment;
                super(1);
            }

            @Nullable
            public final Alignment invoke(@NotNull ASTNode it) {
                Alignment alignment = this.this$0.getAlignment();
                if (alignment == null) {
                    alignment = this.$newAlignment;
                }
                return alignment;
            }
        }))) : SequencesKt.toList(MarkdownBlocks.INSTANCE.create(AstUtilsKt.children(this.getNode()), this.settings, this.spacing, (Function1<? super ASTNode, ? extends Alignment>)((Function1)new Function1<ASTNode, Alignment>(this){
            final /* synthetic */ MarkdownFormattingBlock this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Alignment invoke(@NotNull ASTNode it) {
                return this.this$0.getAlignment();
            }
        }))))));
    }

    private final boolean canBeFormatted(ASTNode $this$canBeFormatted) {
        boolean bl;
        block1: {
            Sequence<ASTNode> $this$none$iv = AstUtilsKt.parents($this$canBeFormatted, true);
            boolean $i$f$none = false;
            for (Object element$iv : $this$none$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl2 = false;
                if (!AstUtilsKt.hasType(it, MarkdownElementTypes.TABLE_CELL)) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    public static final /* synthetic */ TokenSet access$getNON_ALIGNABLE_LIST_ELEMENTS$cp() {
        return NON_ALIGNABLE_LIST_ELEMENTS;
    }

    static {
        TokenSet[] tokenSetArray = new TokenSet[]{MarkdownTokenTypeSets.LIST_MARKERS, MarkdownTokenTypeSets.LISTS};
        NON_ALIGNABLE_LIST_ELEMENTS = TokenSet.orSet((TokenSet[])tokenSetArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/intellij/plugins/markdown/lang/formatter/blocks/MarkdownFormattingBlock$Companion;", "", "()V", "NON_ALIGNABLE_LIST_ELEMENTS", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

