/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.injection.aliases;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lexer.EmbeddedTokenTypesProvider;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.injection.CodeFenceLanguageProvider;
import org.intellij.plugins.markdown.injection.aliases.CodeFenceLanguageAliases;
import org.intellij.plugins.markdown.injection.aliases.CodeFenceLanguageGuesser;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J.\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0003J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/intellij/plugins/markdown/injection/aliases/CodeFenceLanguageGuesser;", "", "()V", "customProviders", "", "Lorg/intellij/plugins/markdown/injection/CodeFenceLanguageProvider;", "getCustomProviders", "()Ljava/util/List;", "findLanguage", "Lcom/intellij/lang/Language;", "value", "", "registeredLanguages", "", "embeddedTokenTypesProviders", "Lkotlin/sequences/Sequence;", "Lcom/intellij/lexer/EmbeddedTokenTypesProvider;", "guessLanguage", "guessLanguageForInjection", "intellij.markdown.core"})
@ApiStatus.Internal
public final class CodeFenceLanguageGuesser {
    @NotNull
    public static final CodeFenceLanguageGuesser INSTANCE = new CodeFenceLanguageGuesser();

    private CodeFenceLanguageGuesser() {
    }

    @NotNull
    public final List<CodeFenceLanguageProvider> getCustomProviders() {
        return CodeFenceLanguageProvider.EP_NAME.getExtensionList();
    }

    @JvmStatic
    @Nullable
    public static final Language guessLanguageForInjection(@NotNull String value) {
        Object object;
        Language language = CodeFenceLanguageGuesser.guessLanguage(value);
        if (language != null) {
            Language language2;
            Language it = language2 = language;
            boolean bl = false;
            object = LanguageUtil.isInjectableLanguage((Language)it) ? language2 : null;
        } else {
            object = null;
        }
        return object;
    }

    private final Language findLanguage(String value, Collection<? extends Language> registeredLanguages, Sequence<? extends EmbeddedTokenTypesProvider> embeddedTokenTypesProviders) {
        Object v1;
        String entry;
        block3: {
            String string = CodeFenceLanguageAliases.INSTANCE.findRegisteredEntry(value);
            if (string == null) {
                string = value;
            }
            entry = string;
            Iterable iterable = registeredLanguages;
            for (Object t : iterable) {
                Language it = (Language)t;
                boolean bl = false;
                if (!StringsKt.equals((String)it.getID(), (String)entry, (boolean)true)) continue;
                v1 = t;
                break block3;
            }
            v1 = null;
        }
        Language registered = v1;
        if (registered != null) {
            return registered;
        }
        Sequence providers2 = SequencesKt.filter(embeddedTokenTypesProviders, (Function1)((Function1)new Function1<EmbeddedTokenTypesProvider, Boolean>(entry){
            final /* synthetic */ String $entry;
            {
                this.$entry = $entry;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull EmbeddedTokenTypesProvider it) {
                return StringsKt.equals((String)it.getName(), (String)this.$entry, (boolean)true);
            }
        }));
        return (Language)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)providers2, (Function1)findLanguage.1.INSTANCE));
    }

    private final Language findLanguage(String value) {
        Sequence embeddedTokenTypesProviders;
        Collection registeredLanguages = Language.getRegisteredLanguages();
        Language exactMatch = this.findLanguage(value, registeredLanguages, (Sequence<? extends EmbeddedTokenTypesProvider>)(embeddedTokenTypesProviders = CollectionsKt.asSequence((Iterable)EmbeddedTokenTypesProvider.getProviders())));
        if (exactMatch != null) {
            return exactMatch;
        }
        int index = StringsKt.lastIndexOf$default((CharSequence)value, (char)' ', (int)0, (boolean)false, (int)6, null);
        while (index != -1) {
            String nameWithoutCustomizations;
            Intrinsics.checkNotNullExpressionValue((Object)value.substring(0, index), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            Language language = this.findLanguage(nameWithoutCustomizations, registeredLanguages, (Sequence<? extends EmbeddedTokenTypesProvider>)embeddedTokenTypesProviders);
            if (language != null) {
                return language;
            }
            index = StringsKt.lastIndexOf$default((CharSequence)value, (char)' ', (int)RangesKt.coerceAtLeast((int)(index - 1), (int)0), (boolean)false, (int)4, null);
        }
        return null;
    }

    @JvmStatic
    private static final Language guessLanguage(String value) {
        for (CodeFenceLanguageProvider provider : INSTANCE.getCustomProviders()) {
            Language lang = provider.getLanguageByInfoString(value);
            if (lang == null) continue;
            return lang;
        }
        String string = value.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String name = string;
        return INSTANCE.findLanguage(name);
    }
}

