/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.highlighting;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.HashMap;
import java.util.Map;
import org.intellij.plugins.markdown.highlighting.MarkdownHighlighterColors;
import org.intellij.plugins.markdown.highlighting.MarkdownHighlightingLexer;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.jetbrains.annotations.NotNull;

public class MarkdownSyntaxHighlighter
extends SyntaxHighlighterBase {
    protected final Lexer lexer = new MarkdownHighlightingLexer();
    protected static final Map<IElementType, TextAttributesKey> ATTRIBUTES = new HashMap<IElementType, TextAttributesKey>();

    @NotNull
    public Lexer getHighlightingLexer() {
        return this.lexer;
    }

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        return MarkdownSyntaxHighlighter.pack((TextAttributesKey)ATTRIBUTES.get(tokenType));
    }

    static {
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownTokenTypes.TEXT, (TextAttributesKey)MarkdownHighlighterColors.TEXT);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.STRONG, (TextAttributesKey)MarkdownHighlighterColors.BOLD);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.EMPH, (TextAttributesKey)MarkdownHighlighterColors.ITALIC);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.STRIKETHROUGH, (TextAttributesKey)MarkdownHighlighterColors.STRIKE_THROUGH);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownTokenTypes.HORIZONTAL_RULE, (TextAttributesKey)MarkdownHighlighterColors.HRULE);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownTokenTypes.TABLE_SEPARATOR, (TextAttributesKey)MarkdownHighlighterColors.TABLE_SEPARATOR);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownTokenTypes.BLOCK_QUOTE, (TextAttributesKey)MarkdownHighlighterColors.BLOCK_QUOTE_MARKER);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (TokenSet)MarkdownTokenTypeSets.LIST_MARKERS, (TextAttributesKey)MarkdownHighlighterColors.LIST_MARKER);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (TokenSet)MarkdownTokenTypeSets.HEADER_MARKERS, (TextAttributesKey)MarkdownHighlighterColors.HEADER_MARKER);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (TokenSet)MarkdownTokenTypeSets.HEADER_LEVEL_1_SET, (TextAttributesKey)MarkdownHighlighterColors.HEADER_LEVEL_1);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (TokenSet)MarkdownTokenTypeSets.HEADER_LEVEL_2_SET, (TextAttributesKey)MarkdownHighlighterColors.HEADER_LEVEL_2);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (TokenSet)MarkdownTokenTypeSets.HEADER_LEVEL_3_SET, (TextAttributesKey)MarkdownHighlighterColors.HEADER_LEVEL_3);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (TokenSet)MarkdownTokenTypeSets.HEADER_LEVEL_4_SET, (TextAttributesKey)MarkdownHighlighterColors.HEADER_LEVEL_4);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (TokenSet)MarkdownTokenTypeSets.HEADER_LEVEL_5_SET, (TextAttributesKey)MarkdownHighlighterColors.HEADER_LEVEL_5);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (TokenSet)MarkdownTokenTypeSets.HEADER_LEVEL_6_SET, (TextAttributesKey)MarkdownHighlighterColors.HEADER_LEVEL_6);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.INLINE_LINK, (TextAttributesKey)MarkdownHighlighterColors.EXPLICIT_LINK);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (TokenSet)MarkdownTokenTypeSets.REFERENCE_LINK_SET, (TextAttributesKey)MarkdownHighlighterColors.REFERENCE_LINK);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.IMAGE, (TextAttributesKey)MarkdownHighlighterColors.IMAGE);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownTokenTypes.AUTOLINK, (TextAttributesKey)MarkdownHighlighterColors.AUTO_LINK);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownTokenTypes.GFM_AUTOLINK, (TextAttributesKey)MarkdownHighlighterColors.AUTO_LINK);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownTokenTypes.EMAIL_AUTOLINK, (TextAttributesKey)MarkdownHighlighterColors.AUTO_LINK);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.LINK_DEFINITION, (TextAttributesKey)MarkdownHighlighterColors.LINK_DEFINITION);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.LINK_TEXT, (TextAttributesKey)MarkdownHighlighterColors.LINK_TEXT);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.LINK_LABEL, (TextAttributesKey)MarkdownHighlighterColors.LINK_LABEL);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.LINK_DESTINATION, (TextAttributesKey)MarkdownHighlighterColors.LINK_DESTINATION);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.LINK_TITLE, (TextAttributesKey)MarkdownHighlighterColors.LINK_TITLE);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.LINK_COMMENT, (TextAttributesKey)MarkdownHighlighterColors.COMMENT);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.BLOCK_QUOTE, (TextAttributesKey)MarkdownHighlighterColors.BLOCK_QUOTE);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.UNORDERED_LIST, (TextAttributesKey)MarkdownHighlighterColors.UNORDERED_LIST);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.ORDERED_LIST, (TextAttributesKey)MarkdownHighlighterColors.ORDERED_LIST);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.LIST_ITEM, (TextAttributesKey)MarkdownHighlighterColors.LIST_ITEM);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownTokenTypes.BACKTICK, (TextAttributesKey)MarkdownHighlighterColors.TEXT);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.CODE_SPAN, (TextAttributesKey)MarkdownHighlighterColors.CODE_SPAN);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownTokenTypes.CODE_LINE, (TextAttributesKey)MarkdownHighlighterColors.CODE_BLOCK);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownTokenTypes.CODE_FENCE_CONTENT, (TextAttributesKey)MarkdownHighlighterColors.CODE_FENCE);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownTokenTypes.CODE_FENCE_START, (TextAttributesKey)MarkdownHighlighterColors.CODE_FENCE_MARKER);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownTokenTypes.CODE_FENCE_END, (TextAttributesKey)MarkdownHighlighterColors.CODE_FENCE_MARKER);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownTokenTypes.FENCE_LANG, (TextAttributesKey)MarkdownHighlighterColors.CODE_FENCE_LANGUAGE);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.HTML_BLOCK, (TextAttributesKey)MarkdownHighlighterColors.HTML_BLOCK);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownTokenTypes.HTML_TAG, (TextAttributesKey)MarkdownHighlighterColors.INLINE_HTML);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.DEFINITION_LIST, (TextAttributesKey)MarkdownHighlighterColors.DEFINITION_LIST);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.DEFINITION_MARKER, (TextAttributesKey)MarkdownHighlighterColors.DEFINITION_LIST_MARKER);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.DEFINITION, (TextAttributesKey)MarkdownHighlighterColors.DEFINITION);
        MarkdownSyntaxHighlighter.safeMap(ATTRIBUTES, (IElementType)MarkdownElementTypes.DEFINITION_TERM, (TextAttributesKey)MarkdownHighlighterColors.TERM);
    }
}

