/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.highlighting;

import com.intellij.lexer.LayeredLexer;
import com.intellij.lexer.Lexer;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.search.IndexPatternBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownIndexPatternBuilder
implements IndexPatternBuilder {
    public static final TokenSet COMMENT_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{MarkdownElementTypes.LINK_COMMENT});

    @Nullable
    public Lexer getIndexingLexer(@NotNull PsiFile file) {
        if (!(file instanceof MarkdownFile)) {
            return null;
        }
        try {
            LayeredLexer.ourDisableLayersFlag.set(Boolean.TRUE);
            Lexer lexer = ((MarkdownFile)file).getParserDefinition().createLexer(file.getProject());
            return lexer;
        }
        finally {
            LayeredLexer.ourDisableLayersFlag.set(null);
        }
    }

    @Nullable
    public TokenSet getCommentTokenSet(@NotNull PsiFile file) {
        return file instanceof MarkdownFile ? COMMENT_TOKEN_SET : null;
    }

    public int getCommentStartDelta(IElementType tokenType) {
        return 1;
    }

    public int getCommentEndDelta(IElementType tokenType) {
        return 1;
    }
}

