/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.google.authorization;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.collaboration.async.CompletableFutureUtil;
import com.intellij.collaboration.auth.services.OAuthCredentialsAcquirerHttp;
import com.intellij.collaboration.auth.services.OAuthServiceBase;
import com.intellij.collaboration.auth.services.OAuthServiceWithRefresh;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import java.net.http.HttpResponse;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang.time.DateUtils;
import org.intellij.plugins.markdown.google.authorization.GoogleCredentials;
import org.intellij.plugins.markdown.google.utils.GoogleAccountsUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0002\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lorg/intellij/plugins/markdown/google/authorization/GoogleOAuthService;", "Lcom/intellij/collaboration/auth/services/OAuthServiceBase;", "Lorg/intellij/plugins/markdown/google/authorization/GoogleCredentials;", "Lcom/intellij/collaboration/auth/services/OAuthServiceWithRefresh;", "()V", "name", "", "getName", "()Ljava/lang/String;", "revokeToken", "", "token", "updateAccessToken", "Ljava/util/concurrent/CompletableFuture;", "refreshTokenRequest", "Lcom/intellij/collaboration/auth/services/OAuthServiceWithRefresh$RefreshTokenRequest;", "Companion", "RefreshResponseData", "intellij.markdown.core"})
public final class GoogleOAuthService
extends OAuthServiceBase<GoogleCredentials>
implements OAuthServiceWithRefresh<GoogleCredentials> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getName() {
        return "google/oauth";
    }

    @NotNull
    public CompletableFuture<GoogleCredentials> updateAccessToken(@NotNull OAuthServiceWithRefresh.RefreshTokenRequest refreshTokenRequest) {
        return CompletableFutureUtil.INSTANCE.submitIOTask(ProgressManager.getInstance(), (ProgressIndicator)new EmptyProgressIndicator(), (Function1)new Function1<ProgressIndicator, GoogleCredentials>(refreshTokenRequest){
            final /* synthetic */ OAuthServiceWithRefresh.RefreshTokenRequest $refreshTokenRequest;
            {
                this.$refreshTokenRequest = $refreshTokenRequest;
                super(1);
            }

            @NotNull
            public final GoogleCredentials invoke(@NotNull ProgressIndicator it) {
                HttpResponse response = OAuthCredentialsAcquirerHttp.INSTANCE.requestToken(this.$refreshTokenRequest.getRefreshTokenUrlWithParameters());
                Date responseDateTime = GoogleOAuthService.Companion.getLocalDateTime(response.headers().firstValue("date").get());
                if (response.statusCode() != 200) {
                    CharSequence charSequence;
                    CharSequence charSequence2 = (CharSequence)response.body();
                    if (charSequence2.length() == 0) {
                        boolean bl = false;
                        charSequence = "No token provided";
                    } else {
                        charSequence = charSequence2;
                    }
                    String string = (String)charSequence;
                    throw new RuntimeException(string);
                }
                ObjectMapper $this$invoke_u24lambda_u240 = GoogleAccountsUtils.INSTANCE.getJacksonMapper();
                boolean bl = false;
                $this$invoke_u24lambda_u240.setPropertyNamingStrategy((PropertyNamingStrategy)new PropertyNamingStrategies.SnakeCaseStrategy());
                RefreshResponseData responseData = (RefreshResponseData)$this$invoke_u24lambda_u240.readValue((String)response.body(), RefreshResponseData.class);
                return new GoogleCredentials(responseData.getAccessToken(), this.$refreshTokenRequest.getRefreshToken(), responseData.getExpiresIn(), responseData.getTokenType(), responseData.getScope(), DateUtils.addSeconds((Date)responseDateTime, (int)((int)responseData.getExpiresIn())));
            }
        });
    }

    public void revokeToken(@NotNull String token) {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/intellij/plugins/markdown/google/authorization/GoogleOAuthService$Companion;", "", "()V", "jacksonMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getJacksonMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "getLocalDateTime", "Ljava/util/Date;", "responseDate", "", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ObjectMapper getJacksonMapper() {
            return ExtensionsKt.jacksonObjectMapper();
        }

        @NotNull
        public final Date getLocalDateTime(@NotNull String responseDate) {
            SimpleDateFormat simpleDateFormat;
            SimpleDateFormat $this$getLocalDateTime_u24lambda_u240 = simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
            boolean bl = false;
            $this$getLocalDateTime_u24lambda_u240.setTimeZone(TimeZone.getTimeZone("GMT"));
            return simpleDateFormat.parse(responseDate);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J;\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lorg/intellij/plugins/markdown/google/authorization/GoogleOAuthService$RefreshResponseData;", "", "accessToken", "", "expiresIn", "", "scope", "tokenType", "idToken", "(Ljava/lang/String;JLjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAccessToken", "()Ljava/lang/String;", "getExpiresIn", "()J", "getIdToken", "getScope", "getTokenType", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.markdown.core"})
    private static final class RefreshResponseData {
        @NotNull
        private final String accessToken;
        private final long expiresIn;
        @NotNull
        private final String scope;
        @NotNull
        private final String tokenType;
        @NotNull
        private final String idToken;

        public RefreshResponseData(@NotNull String accessToken, long expiresIn, @NotNull String scope, @NotNull String tokenType, @NotNull String idToken) {
            this.accessToken = accessToken;
            this.expiresIn = expiresIn;
            this.scope = scope;
            this.tokenType = tokenType;
            this.idToken = idToken;
        }

        @NotNull
        public final String getAccessToken() {
            return this.accessToken;
        }

        public final long getExpiresIn() {
            return this.expiresIn;
        }

        @NotNull
        public final String getScope() {
            return this.scope;
        }

        @NotNull
        public final String getTokenType() {
            return this.tokenType;
        }

        @NotNull
        public final String getIdToken() {
            return this.idToken;
        }

        @NotNull
        public final String component1() {
            return this.accessToken;
        }

        public final long component2() {
            return this.expiresIn;
        }

        @NotNull
        public final String component3() {
            return this.scope;
        }

        @NotNull
        public final String component4() {
            return this.tokenType;
        }

        @NotNull
        public final String component5() {
            return this.idToken;
        }

        @NotNull
        public final RefreshResponseData copy(@NotNull String accessToken, long expiresIn, @NotNull String scope, @NotNull String tokenType, @NotNull String idToken) {
            return new RefreshResponseData(accessToken, expiresIn, scope, tokenType, idToken);
        }

        public static /* synthetic */ RefreshResponseData copy$default(RefreshResponseData refreshResponseData, String string, long l, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = refreshResponseData.accessToken;
            }
            if ((n & 2) != 0) {
                l = refreshResponseData.expiresIn;
            }
            if ((n & 4) != 0) {
                string2 = refreshResponseData.scope;
            }
            if ((n & 8) != 0) {
                string3 = refreshResponseData.tokenType;
            }
            if ((n & 0x10) != 0) {
                string4 = refreshResponseData.idToken;
            }
            return refreshResponseData.copy(string, l, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "RefreshResponseData(accessToken=" + this.accessToken + ", expiresIn=" + this.expiresIn + ", scope=" + this.scope + ", tokenType=" + this.tokenType + ", idToken=" + this.idToken + ")";
        }

        public int hashCode() {
            int result2 = this.accessToken.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.expiresIn);
            result2 = result2 * 31 + this.scope.hashCode();
            result2 = result2 * 31 + this.tokenType.hashCode();
            result2 = result2 * 31 + this.idToken.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RefreshResponseData)) {
                return false;
            }
            RefreshResponseData refreshResponseData = (RefreshResponseData)other;
            if (!Intrinsics.areEqual((Object)this.accessToken, (Object)refreshResponseData.accessToken)) {
                return false;
            }
            if (this.expiresIn != refreshResponseData.expiresIn) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.scope, (Object)refreshResponseData.scope)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.tokenType, (Object)refreshResponseData.tokenType)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.idToken, (Object)refreshResponseData.idToken);
        }
    }
}

