/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.google.authorization;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.AppUIUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0015\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\r\u0010\n\u001a\u00070\b\u00a2\u0006\u0002\b\tH\u0002J\b\u0010\u000b\u001a\u00020\bH\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0003\u00a8\u0006\u000f"}, d2={"Lorg/intellij/plugins/markdown/google/authorization/AuthResultPage;", "", "()V", "createAuthPage", "", "isSuccess", "", "createPanelContent", "Lcom/intellij/openapi/util/text/HtmlChunk$Element;", "Lorg/jetbrains/annotations/NotNull;", "createPanelHeader", "getApplicationIcon", "getMessageElement", "loadFileFromResource", "path", "intellij.markdown.core"})
public final class AuthResultPage {
    @NotNull
    public static final AuthResultPage INSTANCE = new AuthResultPage();

    private AuthResultPage() {
    }

    @NotNull
    public final String createAuthPage(boolean isSuccess) {
        HtmlChunk.Element element2 = HtmlChunk.html();
        HtmlChunk[] htmlChunkArray = new HtmlChunk[2];
        HtmlChunk.Element element3 = HtmlChunk.head();
        String string = this.loadFileFromResource("googleAuth/googleAuthPage.css");
        if (string == null) {
            string = "";
        }
        htmlChunkArray[0] = (HtmlChunk)element3.child((HtmlChunk)HtmlChunk.styleTag((String)string));
        HtmlChunk[] htmlChunkArray2 = new HtmlChunk[]{(HtmlChunk)this.createPanelHeader(), (HtmlChunk)this.createPanelContent(isSuccess)};
        htmlChunkArray[1] = (HtmlChunk)HtmlChunk.body().child((HtmlChunk)HtmlChunk.div().attr("class", "central-div-panel").children(htmlChunkArray2));
        return element2.children(htmlChunkArray).toString();
    }

    private final HtmlChunk.Element createPanelHeader() {
        return HtmlChunk.div().attr("class", "central-div-header").child((HtmlChunk)HtmlChunk.div().attr("class", "central-div-header-text").addText("JetBrains"));
    }

    private final HtmlChunk.Element createPanelContent(boolean isSuccess) {
        HtmlChunk[] htmlChunkArray = new HtmlChunk[]{(HtmlChunk)this.getApplicationIcon(), (HtmlChunk)this.getMessageElement(isSuccess)};
        return HtmlChunk.div().attr("class", "central-div-content").children(htmlChunkArray);
    }

    private final HtmlChunk.Element getApplicationIcon() {
        String string;
        String string2;
        String string3;
        String it = string3 = AppUIUtil.findIcon();
        boolean bl = false;
        String string4 = it;
        String string5 = string2 = (string4 != null ? StringsKt.endsWith$default((String)string4, (String)".svg", (boolean)false, (int)2, null) : false) ? string3 : null;
        if (string2 != null) {
            it = string2;
            boolean bl2 = false;
            File iconFile = new File(it);
            string = iconFile.exists() && iconFile.isFile() ? FilesKt.readText((File)iconFile, (Charset)Charsets.UTF_8) : null;
        } else {
            string = null;
        }
        String icon = string;
        HtmlChunk.Element element2 = HtmlChunk.div().attr("class", "central-div-app-icon");
        String string6 = icon;
        if (string6 == null) {
            string6 = "";
        }
        return element2.addRaw(string6);
    }

    private final HtmlChunk.Element getMessageElement(boolean isSuccess) {
        String text = isSuccess ? MarkdownBundle.message("markdown.google.auth.result.success", new Object[0]) : MarkdownBundle.message("markdown.google.auth.result.failed", new Object[0]);
        String icon = isSuccess ? this.loadFileFromResource("googleAuth/success.svg") : this.loadFileFromResource("googleAuth/error.svg");
        HtmlChunk.Element element2 = HtmlChunk.div().attr("class", "central-div-content");
        HtmlChunk[] htmlChunkArray = new HtmlChunk[2];
        HtmlChunk.Element element3 = HtmlChunk.div().attr("class", "central-div-content-icon");
        String string = icon;
        if (string == null) {
            string = "";
        }
        htmlChunkArray[0] = (HtmlChunk)element3.addRaw(string);
        htmlChunkArray[1] = (HtmlChunk)HtmlChunk.div().attr("class", "central-div-content-text").addText(text);
        return element2.children(htmlChunkArray);
    }

    @NlsSafe
    private final String loadFileFromResource(String path) {
        String string;
        InputStream inputStream;
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)"org.intellij.plugins.markdown"));
        if (ideaPluginDescriptor == null) {
            throw new IllegalStateException("Couldn't find markdown plugin descriptor");
        }
        IdeaPluginDescriptor plugin = ideaPluginDescriptor;
        ClassLoader loader = plugin.getPluginClassLoader();
        if (loader != null && (inputStream = loader.getResourceAsStream(path)) != null) {
            Reader reader = new InputStreamReader(inputStream, Charsets.UTF_8);
            int n = 8192;
            string = TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
        } else {
            string = null;
        }
        return string;
    }
}

