/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.google.accounts;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.intellij.openapi.components.Service;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExecutorsKt;
import kotlinx.coroutines.future.FutureKt;
import org.intellij.plugins.markdown.google.GoogleAuthorizedUserException;
import org.intellij.plugins.markdown.google.accounts.GoogleUserInfoService;
import org.intellij.plugins.markdown.google.accounts.data.GoogleUserInfo;
import org.intellij.plugins.markdown.google.utils.GoogleAccountsUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\b\u001a\n \t*\u0004\u0018\u00010\u00040\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0003J\u0015\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001c\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000b0\u00102\u0006\u0010\u0005\u001a\u00020\u0006H\u0003\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0012"}, d2={"Lorg/intellij/plugins/markdown/google/accounts/GoogleUserInfoService;", "", "()V", "acquireUserInfo", "Lorg/intellij/plugins/markdown/google/accounts/data/GoogleUserInfo;", "accessToken", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deserializeResponse", "kotlin.jvm.PlatformType", "response", "Ljava/net/http/HttpResponse;", "getUserInfoUrl", "Lcom/intellij/util/Url;", "Lorg/jetbrains/annotations/NotNull;", "requestUserInfo", "Ljava/util/concurrent/CompletableFuture;", "Companion", "intellij.markdown.core"})
public final class GoogleUserInfoService {
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object acquireUserInfo(@NotNull String var1_1, @NotNull Continuation<? super GoogleUserInfo> var2_2) {
        if (!(var2_2 instanceof acquireUserInfo.1)) ** GOTO lbl-1000
        var6_3 = var2_2;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ GoogleUserInfoService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.acquireUserInfo(null, (Continuation<? super GoogleUserInfo>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = FutureKt.asDeferred((CompletionStage)this.requestUserInfo((String)accessToken)).await((Continuation)$continuation);
                if (v0 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (GoogleUserInfoService)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                if ((response = (HttpResponse)v0).statusCode() == 200) {
                    return this.deserializeResponse(response);
                }
                $continuation.L$0 = null;
                $continuation.label = 2;
                v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super JsonNode>, Object>((HttpResponse<String>)response, null){
                    int label;
                    final /* synthetic */ HttpResponse<String> $response;
                    {
                        this.$response = $response;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                return GoogleAccountsUtils.INSTANCE.getJacksonMapper().readTree(this.$response.body());
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super JsonNode> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v1 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl33
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl33:
                // 2 sources

                if ((responseTree = (JsonNode)v1).isEmpty()) {
                    throw new RuntimeException("Couldn't get user data");
                }
                if (responseTree.get("error").get("code").asInt() == 401) {
                    throw new GoogleAuthorizedUserException();
                }
                throw new RuntimeException(responseTree.get("error").get("status").asText());
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @RequiresBackgroundThread
    private final CompletableFuture<HttpResponse<String>> requestUserInfo(String accessToken) {
        String userInfoUrl = this.getUserInfoUrl(accessToken).toExternalForm();
        HttpClient client = HttpClient.newBuilder().executor(ExecutorsKt.asExecutor((CoroutineDispatcher)Dispatchers.getIO())).version(HttpClient.Version.HTTP_1_1).build();
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(userInfoUrl)).header("Content-Type", "application/json").GET().build();
        return client.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofString());
    }

    @RequiresBackgroundThread
    private final GoogleUserInfo deserializeResponse(HttpResponse<String> response) {
        ObjectMapper $this$deserializeResponse_u24lambda_u240 = GoogleAccountsUtils.INSTANCE.getJacksonMapper();
        boolean bl = false;
        $this$deserializeResponse_u24lambda_u240.setPropertyNamingStrategy((PropertyNamingStrategy)new PropertyNamingStrategies.SnakeCaseStrategy());
        return (GoogleUserInfo)$this$deserializeResponse_u24lambda_u240.readValue(response.body(), GoogleUserInfo.class);
    }

    private final Url getUserInfoUrl(String accessToken) {
        return GoogleUserInfoService.Companion.getUSER_INFO_URL().addParameters(MapsKt.mapOf((Pair)TuplesKt.to((Object)"access_token", (Object)accessToken)));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/intellij/plugins/markdown/google/accounts/GoogleUserInfoService$Companion;", "", "()V", "USER_INFO_URL", "Lcom/intellij/util/Url;", "getUSER_INFO_URL", "()Lcom/intellij/util/Url;", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        private final Url getUSER_INFO_URL() {
            return Urls.newFromEncoded((String)"https://www.googleapis.com/oauth2/v2/userinfo");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

