/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.google.accounts;

import com.intellij.codeWithMe.ClientId;
import com.intellij.collaboration.auth.ui.AccountsPanelActionsController;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.google.GoogleAppCredentialsException;
import org.intellij.plugins.markdown.google.accounts.GoogleAccountManager;
import org.intellij.plugins.markdown.google.accounts.GoogleAccountsListModel;
import org.intellij.plugins.markdown.google.accounts.GoogleUserInfoService;
import org.intellij.plugins.markdown.google.accounts.data.GoogleAccount;
import org.intellij.plugins.markdown.google.accounts.data.GoogleUserInfo;
import org.intellij.plugins.markdown.google.authorization.GoogleCredentials;
import org.intellij.plugins.markdown.google.authorization.GoogleOAuthRequest;
import org.intellij.plugins.markdown.google.authorization.GoogleOAuthRequestKt;
import org.intellij.plugins.markdown.google.authorization.GoogleOAuthService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0019\u001aB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Lorg/intellij/plugins/markdown/google/accounts/GoogleAccountsPanelActionsController;", "Lcom/intellij/collaboration/auth/ui/AccountsPanelActionsController;", "Lorg/intellij/plugins/markdown/google/accounts/data/GoogleAccount;", "model", "Lorg/intellij/plugins/markdown/google/accounts/GoogleAccountsListModel;", "(Lorg/intellij/plugins/markdown/google/accounts/GoogleAccountsListModel;)V", "isAddActionWithPopup", "", "()Z", "userInfoService", "Lorg/intellij/plugins/markdown/google/accounts/GoogleUserInfoService;", "getUserInfoService", "()Lorg/intellij/plugins/markdown/google/accounts/GoogleUserInfoService;", "addAccount", "", "parentComponent", "Ljavax/swing/JComponent;", "point", "Lcom/intellij/ui/awt/RelativePoint;", "editAccount", "account", "isAccountUnique", "accountId", "", "showNetworkErrorMessage", "AcquireUserInfoTask", "Companion", "intellij.markdown.core"})
public final class GoogleAccountsPanelActionsController
implements AccountsPanelActionsController<GoogleAccount> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GoogleAccountsListModel model;
    private final boolean isAddActionWithPopup;
    @NotNull
    private static final Logger LOG;

    public GoogleAccountsPanelActionsController(@NotNull GoogleAccountsListModel model) {
        this.model = model;
    }

    private final GoogleUserInfoService getUserInfoService() {
        boolean $i$f$service = false;
        Class<GoogleUserInfoService> serviceClass$iv = GoogleUserInfoService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        return (GoogleUserInfoService)object;
    }

    public boolean isAddActionWithPopup() {
        return this.isAddActionWithPopup;
    }

    public void addAccount(@NotNull JComponent parentComponent, @Nullable RelativePoint point) {
        new AcquireUserInfoTask(parentComponent, (Function2<? super GoogleCredentials, ? super GoogleUserInfo, Unit>)((Function2)new Function2<GoogleCredentials, GoogleUserInfo, Unit>(this){
            final /* synthetic */ GoogleAccountsPanelActionsController this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull GoogleCredentials userCred, @NotNull GoogleUserInfo userInfo) {
                if (GoogleAccountsPanelActionsController.access$isAccountUnique(this.this$0, userInfo.getId())) {
                    GoogleAccount account = GoogleAccountManager.Companion.createAccount(userInfo);
                    GoogleAccountsPanelActionsController.access$getModel$p(this.this$0).add(account, userCred);
                }
            }
        })).queue();
    }

    public void editAccount(@NotNull JComponent parentComponent, @NotNull GoogleAccount account) {
        new AcquireUserInfoTask(parentComponent, (Function2<? super GoogleCredentials, ? super GoogleUserInfo, Unit>)((Function2)new Function2<GoogleCredentials, GoogleUserInfo, Unit>(account, this){
            final /* synthetic */ GoogleAccount $account;
            final /* synthetic */ GoogleAccountsPanelActionsController this$0;
            {
                this.$account = $account;
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull GoogleCredentials userCred, @NotNull GoogleUserInfo userInfo) {
                this.$account.setName(userInfo.getEmail());
                GoogleAccountsPanelActionsController.access$getModel$p(this.this$0).update(this.$account, userCred);
            }
        })).queue();
    }

    private final boolean isAccountUnique(String accountId) {
        boolean bl;
        block3: {
            Iterable $this$none$iv = this.model.getAccounts();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    GoogleAccount it = (GoogleAccount)((Object)element$iv);
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)accountId)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final void showNetworkErrorMessage(JComponent parentComponent) {
        String[] stringArray = new String[]{Messages.getOkButton()};
        ((MessageDialogBuilder.Message)new MessageDialogBuilder.Message(MarkdownBundle.message("markdown.google.network.problems.title", new Object[0]), MarkdownBundle.message("markdown.google.login.network.problems.msg", new Object[0])).buttons(stringArray).icon(UIUtil.getErrorIcon())).show(null, (Component)parentComponent);
    }

    public static final /* synthetic */ boolean access$isAccountUnique(GoogleAccountsPanelActionsController $this, String accountId) {
        return $this.isAccountUnique(accountId);
    }

    public static final /* synthetic */ GoogleAccountsListModel access$getModel$p(GoogleAccountsPanelActionsController $this) {
        return $this.model;
    }

    public static final /* synthetic */ GoogleUserInfoService access$getUserInfoService(GoogleAccountsPanelActionsController $this) {
        return $this.getUserInfoService();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GoogleAccountsPanelActionsController.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/intellij/plugins/markdown/google/accounts/GoogleAccountsPanelActionsController$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00126\u0010\u0004\u001a2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0005\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0011\u001a\u00020\fH\u0016J\b\u0010\u0012\u001a\u00020\fH\u0016J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R>\u0010\u0004\u001a2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/intellij/plugins/markdown/google/accounts/GoogleAccountsPanelActionsController$AcquireUserInfoTask;", "Lcom/intellij/openapi/progress/Task$Modal;", "parentComponent", "Ljavax/swing/JComponent;", "process", "Lkotlin/Function2;", "Lorg/intellij/plugins/markdown/google/authorization/GoogleCredentials;", "Lkotlin/ParameterName;", "name", "userCred", "Lorg/intellij/plugins/markdown/google/accounts/data/GoogleUserInfo;", "userInfo", "", "(Lorg/intellij/plugins/markdown/google/accounts/GoogleAccountsPanelActionsController;Ljavax/swing/JComponent;Lkotlin/jvm/functions/Function2;)V", "credentials", "credentialsFuture", "Ljava/util/concurrent/CompletableFuture;", "onCancel", "onSuccess", "onThrowable", "error", "", "run", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.markdown.core"})
    private final class AcquireUserInfoTask
    extends Task.Modal {
        @NotNull
        private final Function2<GoogleCredentials, GoogleUserInfo, Unit> process;
        private CompletableFuture<GoogleCredentials> credentialsFuture;
        private GoogleCredentials credentials;
        private GoogleUserInfo userInfo;

        public AcquireUserInfoTask(@NotNull JComponent parentComponent, Function2<? super GoogleCredentials, ? super GoogleUserInfo, Unit> process) {
            super(null, parentComponent, MarkdownBundle.message("markdown.google.account.login.progress.title", new Object[0]), true);
            this.process = process;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            GoogleOAuthRequest request = GoogleOAuthRequestKt.getGoogleAuthRequest();
            boolean $i$f$service = false;
            Class<GoogleOAuthService> serviceClass$iv = GoogleOAuthService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            this.credentialsFuture = ((GoogleOAuthService)((Object)object)).authorize(request);
            CompletableFuture<GoogleCredentials> completableFuture = this.credentialsFuture;
            if (completableFuture == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"credentialsFuture");
                completableFuture = null;
            }
            this.credentials = (GoogleCredentials)ProgressIndicatorUtils.awaitWithCheckCanceled((Future)completableFuture, (ProgressIndicator)indicator);
            this.userInfo = (GoogleUserInfo)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super GoogleUserInfo>, Object>(GoogleAccountsPanelActionsController.this, this, null){
                int label;
                final /* synthetic */ GoogleAccountsPanelActionsController this$0;
                final /* synthetic */ AcquireUserInfoTask this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            GoogleUserInfoService googleUserInfoService = GoogleAccountsPanelActionsController.access$getUserInfoService(this.this$0);
                            GoogleCredentials googleCredentials = AcquireUserInfoTask.access$getCredentials$p(this.this$1);
                            if (googleCredentials == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"credentials");
                                googleCredentials = null;
                            }
                            this.label = 1;
                            Object object3 = googleUserInfoService.acquireUserInfo(googleCredentials.getAccessToken(), (Continuation<? super GoogleUserInfo>)((Continuation)this));
                            if (object3 != object2) return object3;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return object3;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super GoogleUserInfo> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        public void onSuccess() {
            GoogleUserInfo googleUserInfo;
            GoogleCredentials googleCredentials = this.credentials;
            if (googleCredentials == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"credentials");
                googleCredentials = null;
            }
            if ((googleUserInfo = this.userInfo) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"userInfo");
                googleUserInfo = null;
            }
            this.process.invoke((Object)googleCredentials, (Object)googleUserInfo);
        }

        public void onThrowable(@NotNull Throwable error) {
            if (error instanceof GoogleAppCredentialsException) {
                JComponent jComponent = this.getParentComponent();
                if (jComponent != null) {
                    JComponent jComponent2 = jComponent;
                    GoogleAccountsPanelActionsController googleAccountsPanelActionsController = GoogleAccountsPanelActionsController.this;
                    JComponent it = jComponent2;
                    boolean bl = false;
                    googleAccountsPanelActionsController.showNetworkErrorMessage(it);
                }
            } else {
                LOG.info(error.getLocalizedMessage());
            }
        }

        public void onCancel() {
            CompletableFuture<GoogleCredentials> completableFuture = this.credentialsFuture;
            if (completableFuture == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"credentialsFuture");
                completableFuture = null;
            }
            completableFuture.cancel(true);
        }

        public static final /* synthetic */ GoogleCredentials access$getCredentials$p(AcquireUserInfoTask $this) {
            return $this.credentials;
        }
    }
}

