/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.google.accounts;

import com.intellij.collaboration.auth.AccountDetails;
import com.intellij.collaboration.auth.ui.LazyLoadingAccountsDetailsProvider;
import com.intellij.collaboration.auth.ui.LazyLoadingAccountsDetailsProviderKt;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ListModel;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.google.GoogleAuthorizedUserException;
import org.intellij.plugins.markdown.google.accounts.GoogleAccountManager;
import org.intellij.plugins.markdown.google.accounts.GoogleAccountsDetailsProvider;
import org.intellij.plugins.markdown.google.accounts.GoogleAccountsListModel;
import org.intellij.plugins.markdown.google.accounts.GoogleUserInfoService;
import org.intellij.plugins.markdown.google.accounts.data.GoogleAccount;
import org.intellij.plugins.markdown.google.accounts.data.GoogleUserDetailed;
import org.intellij.plugins.markdown.google.accounts.data.GoogleUserInfo;
import org.intellij.plugins.markdown.google.authorization.GoogleCredentials;
import org.intellij.plugins.markdown.google.authorization.GoogleOAuthService;
import org.intellij.plugins.markdown.google.utils.GoogleAccountsUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B-\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0003J#\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J\u001f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u001a2\u0006\u0010\u0013\u001a\u00020\u0002H\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H\u0002J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001e"}, d2={"Lorg/intellij/plugins/markdown/google/accounts/GoogleAccountsDetailsProvider;", "Lcom/intellij/collaboration/auth/ui/LazyLoadingAccountsDetailsProvider;", "Lorg/intellij/plugins/markdown/google/accounts/data/GoogleAccount;", "Lorg/intellij/plugins/markdown/google/accounts/data/GoogleUserDetailed;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "accountManager", "Lorg/intellij/plugins/markdown/google/accounts/GoogleAccountManager;", "accountsListModel", "Lorg/intellij/plugins/markdown/google/accounts/GoogleAccountsListModel;", "oAuthService", "Lorg/intellij/plugins/markdown/google/authorization/GoogleOAuthService;", "userInfoService", "Lorg/intellij/plugins/markdown/google/accounts/GoogleUserInfoService;", "(Lkotlinx/coroutines/CoroutineScope;Lorg/intellij/plugins/markdown/google/accounts/GoogleAccountManager;Lorg/intellij/plugins/markdown/google/accounts/GoogleAccountsListModel;Lorg/intellij/plugins/markdown/google/authorization/GoogleOAuthService;Lorg/intellij/plugins/markdown/google/accounts/GoogleUserInfoService;)V", "failedToLoadInfo", "Lcom/intellij/collaboration/auth/ui/LazyLoadingAccountsDetailsProvider$Result$Error;", "getUserCredentials", "Lorg/intellij/plugins/markdown/google/authorization/GoogleCredentials;", "account", "loadAvatar", "Ljava/awt/Image;", "url", "", "(Lorg/intellij/plugins/markdown/google/accounts/data/GoogleAccount;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadDetails", "Lcom/intellij/collaboration/auth/ui/LazyLoadingAccountsDetailsProvider$Result;", "(Lorg/intellij/plugins/markdown/google/accounts/data/GoogleAccount;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "noCredentials", "unauthenticatedUser", "intellij.markdown.core"})
public final class GoogleAccountsDetailsProvider
extends LazyLoadingAccountsDetailsProvider<GoogleAccount, GoogleUserDetailed> {
    @NotNull
    private final GoogleAccountManager accountManager;
    @NotNull
    private final GoogleAccountsListModel accountsListModel;
    @NotNull
    private final GoogleOAuthService oAuthService;
    @NotNull
    private final GoogleUserInfoService userInfoService;

    public GoogleAccountsDetailsProvider(@NotNull CoroutineScope scope, @NotNull GoogleAccountManager accountManager, @NotNull GoogleAccountsListModel accountsListModel, @NotNull GoogleOAuthService oAuthService, @NotNull GoogleUserInfoService userInfoService) {
        super(scope, EmptyIcon.ICON_16);
        this.accountManager = accountManager;
        this.accountsListModel = accountsListModel;
        this.oAuthService = oAuthService;
        this.userInfoService = userInfoService;
        LazyLoadingAccountsDetailsProviderKt.cancelOnRemoval((LazyLoadingAccountsDetailsProvider)this, (ListModel)((ListModel)this.accountsListModel.getAccountsListModel()));
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    protected Object loadDetails(@NotNull GoogleAccount var1_1, @NotNull Continuation<? super LazyLoadingAccountsDetailsProvider.Result<GoogleUserDetailed>> var2_2) {
        if (!(var2_2 instanceof loadDetails.1)) ** GOTO lbl-1000
        var7_3 = var2_2;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ GoogleAccountsDetailsProvider this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.loadDetails((GoogleAccount)null, (Continuation<? super LazyLoadingAccountsDetailsProvider.Result<GoogleUserDetailed>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.getUserCredentials((GoogleAccount)account);
                if (v0 == null) {
                    return this.noCredentials();
                }
                credentials = v0;
                $continuation.L$0 = this;
                $continuation.label = 1;
                v1 = this.userInfoService.acquireUserInfo(credentials.getAccessToken(), (Continuation<? super GoogleUserInfo>)$continuation);
                ** if (v1 != var8_5) goto lbl23
lbl22:
                // 1 sources

                return var8_5;
lbl23:
                // 1 sources

                ** GOTO lbl30
            }
            case 1: {
                this = (GoogleAccountsDetailsProvider)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl30:
                    // 2 sources

                    userInfo = (GoogleUserInfo)v1;
                    details = new GoogleUserDetailed(userInfo.getName(), userInfo.getId(), userInfo.getGivenName(), userInfo.getFamilyName(), userInfo.getLocale(), userInfo.getPicture());
                    return new LazyLoadingAccountsDetailsProvider.Result.Success((AccountDetails)details);
                }
                catch (Exception e) {
                    return (LazyLoadingAccountsDetailsProvider.Result)(e instanceof GoogleAuthorizedUserException != false ? this.unauthenticatedUser() : this.failedToLoadInfo());
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    protected Object loadAvatar(@NotNull GoogleAccount account, @NotNull String url, @NotNull Continuation<? super Image> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super BufferedImage>, Object>(url, null){
            int label;
            final /* synthetic */ String $url;
            {
                this.$url = $url;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        return ImageIO.read(new URL(this.$url));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super BufferedImage> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @RequiresEdt
    private final GoogleCredentials getUserCredentials(GoogleAccount account) {
        Object object = this.accountsListModel.getNewCredentials().get((Object)account);
        if (object == null) {
            boolean bl = false;
            object = GoogleAccountsUtils.INSTANCE.getOrUpdateUserCredentials(this.oAuthService, this.accountManager, account);
        }
        return (GoogleCredentials)object;
    }

    private final LazyLoadingAccountsDetailsProvider.Result.Error<GoogleUserDetailed> noCredentials() {
        return new LazyLoadingAccountsDetailsProvider.Result.Error(MarkdownBundle.message("markdown.google.accounts.token.missing", new Object[0]), true);
    }

    private final LazyLoadingAccountsDetailsProvider.Result.Error<GoogleUserDetailed> failedToLoadInfo() {
        return new LazyLoadingAccountsDetailsProvider.Result.Error(MarkdownBundle.message("markdown.google.accounts.failed.load.user", new Object[0]), true);
    }

    private final LazyLoadingAccountsDetailsProvider.Result.Error<GoogleUserDetailed> unauthenticatedUser() {
        return new LazyLoadingAccountsDetailsProvider.Result.Error(MarkdownBundle.message("markdown.google.accounts.user.unauthenticated.error", new Object[0]), true);
    }
}

