/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.fileActions.utils;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileImpl;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.intellij.util.ModalityUiUtil;
import java.io.File;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.fileActions.export.MarkdownDocxExportProvider;
import org.intellij.plugins.markdown.lang.MarkdownFileType;
import org.intellij.plugins.markdown.settings.pandoc.PandocSettings;
import org.intellij.plugins.markdown.ui.MarkdownNotifications;
import org.intellij.plugins.markdown.ui.actions.MarkdownActionUtil;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanelProvider;
import org.intellij.plugins.markdown.ui.preview.MarkdownPreviewFileEditor;
import org.intellij.plugins.markdown.ui.preview.jcef.JCEFHtmlPanelProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\b\b\u0001\u0010\f\u001a\u00020\u0004J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0004J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0013J\u0016\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u0004J\u001e\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020!J\u0014\u0010\"\u001a\u0004\u0018\u00010#*\u00020$2\u0006\u0010%\u001a\u00020&R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/intellij/plugins/markdown/fileActions/utils/MarkdownImportExportUtils;", "", "()V", "TARGET_FORMAT_NAME", "", "copyAndConvertToMd", "", "project", "Lcom/intellij/openapi/project/Project;", "vFileToImport", "Lcom/intellij/openapi/vfs/VirtualFile;", "selectedFileUrl", "taskTitle", "getConvertDocxToMdCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "file", "mediaSrc", "targetFile", "getPreviewEditor", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownPreviewFileEditor;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "fileType", "isJCEFPanelOpen", "", "editor", "notifyAndRefreshIfExportSuccess", "Ljava/io/File;", "refreshProjectDirectory", "refreshPath", "suggestFileNameToCreate", "fileToImport", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "validateTargetDir", "Lcom/intellij/openapi/ui/ValidationInfo;", "Lcom/intellij/ui/layout/ValidationInfoBuilder;", "field", "Lcom/intellij/ui/TextFieldWithHistoryWithBrowseButton;", "intellij.markdown.core"})
public final class MarkdownImportExportUtils {
    @NotNull
    public static final MarkdownImportExportUtils INSTANCE = new MarkdownImportExportUtils();
    @NotNull
    private static final String TARGET_FORMAT_NAME = "markdown";

    private MarkdownImportExportUtils() {
    }

    @Nullable
    public final MarkdownPreviewFileEditor getPreviewEditor(@NotNull AnActionEvent event, @NotNull String fileType2) {
        Project project = event.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        MarkdownPreviewFileEditor previewEditor = MarkdownActionUtil.findMarkdownPreviewEditor(event);
        if (previewEditor == null) {
            Object[] objectArray = new Object[]{fileType2};
            MarkdownNotifications.showError$default(MarkdownNotifications.INSTANCE, project2, "markdown.export.failed", null, MarkdownBundle.message("markdown.export.validation.failure.msg", objectArray), 4, null);
            return null;
        }
        return previewEditor;
    }

    public final void refreshProjectDirectory(@NotNull Project project, @NotNull String refreshPath) {
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> MarkdownImportExportUtils.refreshProjectDirectory$lambda$0(refreshPath));
    }

    @NotNull
    public final String suggestFileNameToCreate(@NotNull Project project, @NotNull VirtualFile fileToImport, @NotNull DataContext dataContext) {
        File file;
        String defaultFileName = fileToImport.getNameWithoutExtension();
        VirtualFile selectedVirtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (selectedVirtualFile == null) {
            String string = project.getBasePath();
            Intrinsics.checkNotNull((Object)string);
            file = new File(string);
        } else {
            file = selectedVirtualFile instanceof VirtualFileImpl ? new File(((VirtualFileImpl)selectedVirtualFile).getParent().getPath()) : new File(selectedVirtualFile.getPath());
        }
        File dirToImport = file;
        String suggestMdFile = FileUtil.createSequentFileName((File)dirToImport, (String)defaultFileName, (String)MarkdownFileType.INSTANCE.getDefaultExtension());
        String suggestFileName = FilesKt.getNameWithoutExtension((File)new File(suggestMdFile));
        String suggestDocxFile = FileUtil.createSequentFileName((File)dirToImport, (String)suggestFileName, (String)MarkdownDocxExportProvider.Companion.getFormat().getExtension());
        String[] stringArray = new String[]{dirToImport.getPath(), suggestDocxFile};
        return FileUtil.join((String[])stringArray);
    }

    public final void copyAndConvertToMd(@NotNull Project project, @NotNull VirtualFile vFileToImport, @NotNull String selectedFileUrl, @NlsContexts.DialogTitle @NotNull String taskTitle) {
        new Task.Modal(selectedFileUrl, project, taskTitle, vFileToImport){
            private String createdFilePath;
            private ProcessOutput output;
            private final String dirToImport;
            @NotNull
            private final String newFileName;
            @NotNull
            private final String resourcesDir;
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $vFileToImport;
            {
                this.$project = $project;
                this.$vFileToImport = $vFileToImport;
                super($project, $taskTitle, true);
                this.dirToImport = new File($selectedFileUrl).getParent();
                this.newFileName = FilesKt.getNameWithoutExtension((File)new File($selectedFileUrl));
                String string = PandocSettings.Companion.getInstance($project).getPathToImages();
                if (string == null) {
                    String string2 = $project.getBasePath();
                    string = string2;
                    Intrinsics.checkNotNull((Object)string2);
                }
                this.resourcesDir = string;
            }

            public void run(@NotNull ProgressIndicator indicator) {
                String[] stringArray = new String[]{this.dirToImport, this.newFileName + "." + MarkdownFileType.INSTANCE.getDefaultExtension()};
                String filePath = FileUtil.join((String[])stringArray);
                GeneralCommandLine cmd = MarkdownImportExportUtils.access$getConvertDocxToMdCommandLine(MarkdownImportExportUtils.INSTANCE, this.$vFileToImport, this.resourcesDir, filePath);
                this.output = ExecUtil.execAndGetOutput((GeneralCommandLine)cmd);
                this.createdFilePath = filePath;
            }

            public void onCancel() {
                File mdFile;
                String string = this.createdFilePath;
                if (string == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"createdFilePath");
                    string = null;
                }
                if ((mdFile = new File(string)).exists()) {
                    FileUtil.delete((File)mdFile);
                }
            }

            public void onThrowable(@NotNull Throwable error) {
                MarkdownNotifications.showError$default(MarkdownNotifications.INSTANCE, this.$project, "markdown.export.failed", null, "[" + this.$vFileToImport.getName() + "] " + error.getLocalizedMessage(), 4, null);
            }

            public void onSuccess() {
                ProcessOutput processOutput = this.output;
                if (processOutput == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"output");
                    processOutput = null;
                }
                if (processOutput.getStderrLines().isEmpty()) {
                    String string = this.createdFilePath;
                    if (string == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"createdFilePath");
                        string = null;
                    }
                    OpenFileAction.Companion.openFile(string, this.$project);
                } else {
                    String string = this.$vFileToImport.getName();
                    ProcessOutput processOutput2 = this.output;
                    if (processOutput2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"output");
                        processOutput2 = null;
                    }
                    MarkdownNotifications.showError$default(MarkdownNotifications.INSTANCE, this.$project, "markdown.export.failed", null, "[" + string + "] " + CollectionsKt.joinToString$default((Iterable)processOutput2.getStderrLines(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), 4, null);
                }
            }
        }.queue();
    }

    private final GeneralCommandLine getConvertDocxToMdCommandLine(VirtualFile file, String mediaSrc, String targetFile) {
        String[] stringArray = new String[]{"pandoc", "--extract-media=" + mediaSrc, file.getPath(), "-f", MarkdownDocxExportProvider.Companion.getFormat().getExtension(), "-t", TARGET_FORMAT_NAME, "-s", "-o", targetFile};
        return new GeneralCommandLine(stringArray);
    }

    public final boolean isJCEFPanelOpen(@NotNull MarkdownPreviewFileEditor editor2) {
        MarkdownHtmlPanelProvider.ProviderInfo providerInfo = editor2.getLastPanelProviderInfo();
        return Intrinsics.areEqual((Object)(providerInfo != null ? providerInfo.getClassName() : null), (Object)JCEFHtmlPanelProvider.class.getName());
    }

    @Nullable
    public final ValidationInfo validateTargetDir(@NotNull ValidationInfoBuilder $this$validateTargetDir, @NotNull TextFieldWithHistoryWithBrowseButton field) {
        CharSequence charSequence = ((TextFieldWithHistory)field.getChildComponent()).getText();
        return charSequence == null || charSequence.length() == 0 ? $this$validateTargetDir.error(RefactoringBundle.message((String)"no.target.directory.specified")) : null;
    }

    public final void notifyAndRefreshIfExportSuccess(@NotNull File file, @NotNull Project project) {
        Object[] objectArray = new Object[]{file.getName()};
        MarkdownNotifications.showInfo$default(MarkdownNotifications.INSTANCE, project, "markdown.export.success", null, MarkdownBundle.message("markdown.export.success.msg", objectArray), 4, null);
        String dirToExport = file.getParent();
        this.refreshProjectDirectory(project, dirToExport);
    }

    private static final void refreshProjectDirectory$lambda$0(String $refreshPath) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File($refreshPath));
        if (virtualFile != null) {
            virtualFile.refresh(true, true);
        }
    }

    public static final /* synthetic */ GeneralCommandLine access$getConvertDocxToMdCommandLine(MarkdownImportExportUtils $this, VirtualFile file, String mediaSrc, String targetFile) {
        return $this.getConvertDocxToMdCommandLine(file, mediaSrc, targetFile);
    }
}

