/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.fileActions.importFrom.googleDocs;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.drive.Drive;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.io.PathKt;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.fileActions.importFrom.googleDocs.GoogleDocsFileLoader;
import org.intellij.plugins.markdown.fileActions.utils.GoogleCommonUtils;
import org.intellij.plugins.markdown.ui.MarkdownNotifications;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006R\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0003J\u0014\u0010\n\u001a\u00060\u0006R\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0003J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\tH\u0002\u00a8\u0006\u0019"}, d2={"Lorg/intellij/plugins/markdown/fileActions/importFrom/googleDocs/GoogleDocsFileLoader;", "", "()V", "downloadFileFromDrive", "Lcom/intellij/openapi/vfs/VirtualFile;", "driveFiles", "Lcom/google/api/services/drive/Drive$Files;", "Lcom/google/api/services/drive/Drive;", "docsId", "", "getAllFilesFromDrive", "credential", "Lcom/google/api/client/auth/oauth2/Credential;", "handleResponseExceptions", "", "e", "Lcom/google/api/client/googleapis/json/GoogleJsonResponseException;", "project", "Lcom/intellij/openapi/project/Project;", "loadFileFromGoogleDisk", "moveContentFromTempFile", "Ljava/io/File;", "tempFile", "fileName", "Companion", "intellij.markdown.core"})
public final class GoogleDocsFileLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String mimeType = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
    @NotNull
    private static final Logger LOG;

    @Nullable
    public final VirtualFile loadFileFromGoogleDisk(@NotNull Project project, @NotNull Credential credential, @NotNull String docsId) {
        VirtualFile virtualFile;
        try {
            virtualFile = (VirtualFile)GoogleCommonUtils.INSTANCE.runProcessWithGoogleCredentials(project, credential, (Function1)new Function1<Credential, VirtualFile>(project, this, credential, docsId){
                final /* synthetic */ Project $project;
                final /* synthetic */ GoogleDocsFileLoader this$0;
                final /* synthetic */ Credential $credential;
                final /* synthetic */ String $docsId;
                {
                    this.$project = $project;
                    this.this$0 = $receiver;
                    this.$credential = $credential;
                    this.$docsId = $docsId;
                    super(1);
                }

                public final VirtualFile invoke(@NotNull Credential it) {
                    return (VirtualFile)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> loadFileFromGoogleDisk.1.invoke$lambda$0(this.this$0, this.$credential, this.$docsId), MarkdownBundle.message("markdown.google.load.file.progress.title", new Object[0]), true, this.$project);
                }

                private static final VirtualFile invoke$lambda$0(GoogleDocsFileLoader this$0, Credential $credential, String $docsId) {
                    Drive.Files driveFiles = GoogleDocsFileLoader.access$getAllFilesFromDrive(this$0, $credential);
                    return GoogleDocsFileLoader.access$downloadFileFromDrive(this$0, driveFiles, $docsId);
                }
            });
        }
        catch (GoogleJsonResponseException e) {
            this.handleResponseExceptions(e, project);
            virtualFile = null;
        }
        return virtualFile;
    }

    @RequiresBackgroundThread
    private final Drive.Files getAllFilesFromDrive(Credential credential) {
        NetHttpTransport httpTransport = GoogleNetHttpTransport.newTrustedTransport();
        return new Drive.Builder(httpTransport, GoogleDocsFileLoader.Companion.getJsonFactory(), credential).build().files();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresBackgroundThread
    private final VirtualFile downloadFileFromDrive(Drive.Files driveFiles, String docsId) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Drive.Files $this$downloadFileFromDrive_u24lambda_u240 = driveFiles;
        boolean bl = false;
        $this$downloadFileFromDrive_u24lambda_u240.export(docsId, mimeType).executeAndDownloadTo(outputStream);
        String fileName = ((com.google.api.services.drive.model.File)$this$downloadFileFromDrive_u24lambda_u240.get(docsId).setFields("id, name").execute()).getName();
        File $this$downloadFileFromDrive_u24lambda_u242 = bl = File.createTempFile(fileName, ".docx");
        boolean bl2 = false;
        Closeable closeable = new FileOutputStream($this$downloadFileFromDrive_u24lambda_u242);
        Throwable throwable = null;
        try {
            FileOutputStream it = (FileOutputStream)closeable;
            boolean bl3 = false;
            outputStream.writeTo(it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        File tempFile = bl;
        File renamedFile = this.moveContentFromTempFile(tempFile, fileName);
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)renamedFile, (boolean)true);
        Intrinsics.checkNotNull((Object)virtualFile);
        return virtualFile;
    }

    private final File moveContentFromTempFile(File tempFile, String fileName) {
        try {
            Path targetFilePath = new File(tempFile.getParent(), fileName + ".docx").toPath();
            Object object = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE};
            Object $this$moveContentFromTempFile_u24lambda_u243 = object = Files.move(tempFile.toPath(), targetFilePath, (CopyOption[])object);
            boolean bl = false;
            if (!PathKt.exists((Path)$this$moveContentFromTempFile_u24lambda_u243)) {
                PathKt.createFile((Path)$this$moveContentFromTempFile_u24lambda_u243);
            }
            return object.toFile();
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
            return tempFile;
        }
    }

    private final void handleResponseExceptions(GoogleJsonResponseException e, Project project) {
        if (e.getStatusCode() == 404) {
            Object[] objectArray = MarkdownNotifications.INSTANCE;
            String string = MarkdownBundle.message("markdown.google.file.download.error.msg", new Object[0]);
            String string2 = MarkdownBundle.message("markdown.google.file.download.error.title", new Object[0]);
            objectArray.showError(project, "markdown.export.failed", string2, string);
            objectArray = new Object[]{MarkdownBundle.message("markdown.google.file.download.error.msg", new Object[0])};
            LOG.debug(MarkdownBundle.message("markdown.google.file.download.error.title", new Object[0]), objectArray);
        } else {
            LOG.info(e.getLocalizedMessage());
        }
    }

    public static final /* synthetic */ Drive.Files access$getAllFilesFromDrive(GoogleDocsFileLoader $this, Credential credential) {
        return $this.getAllFilesFromDrive(credential);
    }

    public static final /* synthetic */ VirtualFile access$downloadFileFromDrive(GoogleDocsFileLoader $this, Drive.Files driveFiles, String docsId) {
        return $this.downloadFileFromDrive(driveFiles, docsId);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GoogleDocsFileLoader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/intellij/plugins/markdown/fileActions/importFrom/googleDocs/GoogleDocsFileLoader$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "jsonFactory", "Lcom/google/api/client/json/JsonFactory;", "getJsonFactory", "()Lcom/google/api/client/json/JsonFactory;", "mimeType", "", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        private final JsonFactory getJsonFactory() {
            return GsonFactory.getDefaultInstance();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

