/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.fileActions.export;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.TextComponentAccessors;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.CellBuilder;
import com.intellij.ui.layout.ComponentPredicateKt;
import com.intellij.ui.layout.InnerCell;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.LayoutKt;
import com.intellij.ui.layout.Row;
import com.intellij.ui.layout.RowBuilder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.List;
import java.util.function.BiConsumer;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.fileActions.MarkdownFileActionFormat;
import org.intellij.plugins.markdown.fileActions.export.MarkdownExportProvider;
import org.intellij.plugins.markdown.fileActions.export.MarkdownHtmlExportProvider;
import org.intellij.plugins.markdown.fileActions.export.MarkdownHtmlExportSettings;
import org.intellij.plugins.markdown.fileActions.utils.MarkdownFileEditorUtils;
import org.intellij.plugins.markdown.fileActions.utils.MarkdownImportExportUtils;
import org.intellij.plugins.markdown.ui.MarkdownNotifications;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.MarkdownPreviewFileEditor;
import org.intellij.plugins.markdown.ui.preview.jcef.HtmlExporter;
import org.intellij.plugins.markdown.ui.preview.jcef.HtmlResourceSavingSettings;
import org.intellij.plugins.markdown.ui.preview.jcef.MarkdownJCEFHtmlPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 &2\u00020\u0001:\u0002&'B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00172\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0015H\u0016J\u001c\u0010\u001b\u001a\u00020\f*\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010\u001d\u001a\u00020\f*\u00020\u001cH\u0002J8\u0010\u001e\u001a\u00020\f*\u00020\u001f2\u0006\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020%0$H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/intellij/plugins/markdown/fileActions/export/MarkdownHtmlExportProvider;", "Lorg/intellij/plugins/markdown/fileActions/export/MarkdownExportProvider;", "()V", "formatDescription", "Lorg/intellij/plugins/markdown/fileActions/MarkdownFileActionFormat;", "getFormatDescription", "()Lorg/intellij/plugins/markdown/fileActions/MarkdownFileActionFormat;", "resourceDirField", "Lcom/intellij/ui/TextFieldWithHistoryWithBrowseButton;", "saveImagesCheckbox", "Ljavax/swing/JCheckBox;", "addSettingsListeners", "", "project", "Lcom/intellij/openapi/project/Project;", "createSettingsComponent", "Ljavax/swing/JComponent;", "suggestedTargetFile", "Ljava/io/File;", "exportFile", "mdFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "outputFile", "", "saveSettings", "validate", "file", "createResourceDirField", "Lcom/intellij/ui/layout/Cell;", "createSaveImageCheckbox", "saveHtml", "Lorg/intellij/plugins/markdown/ui/preview/jcef/MarkdownJCEFHtmlPanel;", "path", "resDirPath", "Lorg/intellij/plugins/markdown/ui/preview/jcef/HtmlResourceSavingSettings;", "resultCallback", "Ljava/util/function/BiConsumer;", "", "Companion", "SaveSettingsListener", "intellij.markdown.core"})
public final class MarkdownHtmlExportProvider
implements MarkdownExportProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private JCheckBox saveImagesCheckbox;
    @NotNull
    private final TextFieldWithHistoryWithBrowseButton resourceDirField = new TextFieldWithHistoryWithBrowseButton();
    @NotNull
    private static final String IMAGE_DIR_RESENT_KEYS = "ImportExportFile.ImageDir.RECENT_KEYS";
    @NotNull
    private static final MarkdownFileActionFormat format = new MarkdownFileActionFormat("HTML", "html");

    @Override
    @NotNull
    public MarkdownFileActionFormat getFormatDescription() {
        return format;
    }

    @Override
    public void exportFile(@NotNull Project project, @NotNull VirtualFile mdFile, @NotNull String outputFile) {
        this.saveSettings(project);
        MarkdownPreviewFileEditor markdownPreviewFileEditor = MarkdownFileEditorUtils.findMarkdownPreviewEditor(project, mdFile, true);
        if (markdownPreviewFileEditor == null) {
            return;
        }
        MarkdownPreviewFileEditor preview = markdownPreviewFileEditor;
        MarkdownHtmlPanel markdownHtmlPanel = (MarkdownHtmlPanel)preview.getUserData(MarkdownPreviewFileEditor.PREVIEW_BROWSER);
        if (markdownHtmlPanel == null) {
            return;
        }
        MarkdownHtmlPanel htmlPanel = markdownHtmlPanel;
        if (htmlPanel instanceof MarkdownJCEFHtmlPanel) {
            boolean $i$f$service = false;
            Class<MarkdownHtmlExportSettings> serviceClass$iv = MarkdownHtmlExportSettings.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            this.saveHtml((MarkdownJCEFHtmlPanel)htmlPanel, outputFile, ((MarkdownHtmlExportSettings)object).getResourceSavingSettings(), project, (arg_0, arg_1) -> MarkdownHtmlExportProvider.exportFile$lambda$0(project, arg_0, arg_1));
        }
    }

    @Override
    @Nullable
    public String validate(@NotNull Project project, @NotNull VirtualFile file) {
        MarkdownPreviewFileEditor preview = MarkdownFileEditorUtils.findMarkdownPreviewEditor(project, file, true);
        if (preview == null || !MarkdownImportExportUtils.INSTANCE.isJCEFPanelOpen(preview)) {
            Object[] objectArray = new Object[]{this.getFormatDescription().getFormatName()};
            return MarkdownBundle.message("markdown.export.validation.failure.msg", objectArray);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JComponent createSettingsComponent(@NotNull Project project, @NotNull File suggestedTargetFile) {
        void constraints$iv;
        Color bgcolor$iv;
        LayoutBuilder builder$iv;
        LCFlags[] lCFlagsArray = new LCFlags[]{LCFlags.fillX};
        String title$iv = null;
        boolean $i$f$panel = false;
        LayoutBuilder $this$createSettingsComponent_u24lambda_u241 = builder$iv = LayoutImplKt.createLayoutBuilder();
        boolean bl = false;
        RowBuilder.row$default((RowBuilder)((RowBuilder)$this$createSettingsComponent_u24lambda_u241), null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this, project, suggestedTargetFile){
            final /* synthetic */ MarkdownHtmlExportProvider this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ File $suggestedTargetFile;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$suggestedTargetFile = $suggestedTargetFile;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                MarkdownHtmlExportProvider markdownHtmlExportProvider = this.this$0;
                Project project = this.$project;
                File file = this.$suggestedTargetFile;
                boolean isVerticalFlow$iv = false;
                boolean isFullWidth$iv = false;
                boolean $i$f$cell = false;
                $this$row.setCellMode(true, isVerticalFlow$iv, isFullWidth$iv);
                InnerCell $this$invoke_u24lambda_u240 = new InnerCell((Cell)$this$row);
                boolean bl = false;
                MarkdownHtmlExportProvider.access$createSaveImageCheckbox(markdownHtmlExportProvider, (Cell)$this$invoke_u24lambda_u240);
                MarkdownHtmlExportProvider.access$createResourceDirField(markdownHtmlExportProvider, (Cell)$this$invoke_u24lambda_u240, project, file);
                MarkdownHtmlExportProvider.access$addSettingsListeners(markdownHtmlExportProvider, project);
                $this$row.setCellMode(false, isVerticalFlow$iv, isFullWidth$iv);
            }
        }), (int)3, null);
        DialogPanel panel$iv = ComponentsKt.DialogPanel(title$iv, null);
        Color color = bgcolor$iv = Registry.getColor((String)"ui.kotlin.ui.dsl.deprecated.panel.color", null);
        if (color != null) {
            Color it$iv = color;
            boolean bl2 = false;
            panel$iv.setBackground(it$iv);
        }
        builder$iv.getBuilder().build((Container)panel$iv, (LCFlags[])constraints$iv);
        LayoutKt.initPanel((LayoutBuilder)builder$iv, (DialogPanel)panel$iv);
        return (JComponent)panel$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final void createSaveImageCheckbox(Cell $this$createSaveImageCheckbox) {
        void $this$createSaveImageCheckbox_u24lambda_u242;
        JComponent jComponent = Cell.checkBox$default((Cell)$this$createSaveImageCheckbox, (String)MarkdownBundle.message("markdown.export.to.html.save.images.checkbox", new Object[0]), (boolean)false, null, (int)6, null).getComponent();
        JBCheckBox jBCheckBox = (JBCheckBox)jComponent;
        MarkdownHtmlExportProvider markdownHtmlExportProvider = this;
        boolean bl = false;
        $this$createSaveImageCheckbox_u24lambda_u242.setToolTipText(MarkdownBundle.message("markdown.export.dialog.checkbox.tooltip", new Object[0]));
        boolean $i$f$service = false;
        Class<MarkdownHtmlExportSettings> serviceClass$iv = MarkdownHtmlExportSettings.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        $this$createSaveImageCheckbox_u24lambda_u242.setSelected(((MarkdownHtmlExportSettings)object).getResourceSavingSettings().isSaved());
        markdownHtmlExportProvider.saveImagesCheckbox = (JCheckBox)jComponent;
    }

    private final void createResourceDirField(Cell $this$createResourceDirField, Project project, File suggestedTargetFile) {
        CellBuilder cellBuilder;
        CellBuilder $this$createResourceDirField_u24lambda_u243 = cellBuilder = this.resourceDirField;
        boolean bl = false;
        $this$createResourceDirField_u24lambda_u243.setTextFieldPreferredWidth(70);
        List resDirRecent = RecentsManager.getInstance((Project)project).getRecentEntries(IMAGE_DIR_RESENT_KEYS);
        if (resDirRecent != null) {
            ((TextFieldWithHistory)$this$createResourceDirField_u24lambda_u243.getChildComponent()).setHistory(resDirRecent);
        }
        String[] stringArray = new String[]{suggestedTargetFile.getParent(), FilesKt.getNameWithoutExtension((File)suggestedTargetFile)};
        ((TextFieldWithHistory)$this$createResourceDirField_u24lambda_u243.getChildComponent()).setText(FileUtil.join((String[])stringArray));
        $this$createResourceDirField_u24lambda_u243.addBrowseFolderListener(MarkdownBundle.message("markdown.import.export.dialog.target.directory", new Object[0]), MarkdownBundle.message("markdown.import.export.dialog.target.directory.description", new Object[0]), project, FileChooserDescriptorFactory.createSingleFolderDescriptor(), TextComponentAccessors.TEXT_FIELD_WITH_HISTORY_WHOLE_TEXT);
        cellBuilder = new CellBuilder[]{$this$createResourceDirField.getGrowX()};
        CellBuilder $this$createResourceDirField_u24lambda_u244 = cellBuilder = Cell.invoke$default((Cell)$this$createResourceDirField, (JComponent)((JComponent)this.resourceDirField), (CCFlags[])cellBuilder, null, null, (int)6, null);
        boolean bl2 = false;
        $this$createResourceDirField_u24lambda_u244.withValidationOnApply((Function2)createResourceDirField.2.1.INSTANCE);
        $this$createResourceDirField_u24lambda_u244.focused();
        JCheckBox jCheckBox = this.saveImagesCheckbox;
        if (jCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveImagesCheckbox");
            jCheckBox = null;
        }
        $this$createResourceDirField_u24lambda_u244.enableIf(ComponentPredicateKt.getSelected((AbstractButton)jCheckBox));
    }

    private final void addSettingsListeners(Project project) {
        JCheckBox jCheckBox = this.saveImagesCheckbox;
        if (jCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveImagesCheckbox");
            jCheckBox = null;
        }
        jCheckBox.addChangeListener(arg_0 -> MarkdownHtmlExportProvider.addSettingsListeners$lambda$5(this, project, arg_0));
        ((TextFieldWithHistory)this.resourceDirField.getChildComponent()).getTextEditor().addFocusListener(new SaveSettingsListener(project));
    }

    private final void saveSettings(Project project) {
        String imageDir = ((TextFieldWithHistory)this.resourceDirField.getChildComponent()).getText();
        boolean $i$f$service = false;
        Class<MarkdownHtmlExportSettings> serviceClass$iv = MarkdownHtmlExportSettings.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        MarkdownHtmlExportSettings exportSettings = (MarkdownHtmlExportSettings)object;
        JCheckBox jCheckBox = this.saveImagesCheckbox;
        if (jCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveImagesCheckbox");
            jCheckBox = null;
        }
        exportSettings.setSaveResources(jCheckBox.isSelected());
        exportSettings.setResourceDirectory(imageDir);
        RecentsManager.getInstance((Project)project).registerRecentEntry(IMAGE_DIR_RESENT_KEYS, imageDir);
    }

    private final void saveHtml(MarkdownJCEFHtmlPanel $this$saveHtml, String path, HtmlResourceSavingSettings resDirPath, Project project, BiConsumer<String, Boolean> resultCallback) {
        $this$saveHtml.getCefBrowser().getSource(arg_0 -> MarkdownHtmlExportProvider.saveHtml$lambda$6(path, resDirPath, project, resultCallback, arg_0));
    }

    private static final void exportFile$lambda$0(Project $project, String path, Boolean ok) {
        if (ok.booleanValue()) {
            MarkdownImportExportUtils.INSTANCE.notifyAndRefreshIfExportSuccess(new File(path), $project);
        } else {
            Object[] objectArray = new Object[]{new File(path).getName()};
            MarkdownNotifications.showError$default(MarkdownNotifications.INSTANCE, $project, "markdown.export.failed", null, MarkdownBundle.message("markdown.export.failure.msg", objectArray), 4, null);
        }
    }

    private static final void addSettingsListeners$lambda$5(MarkdownHtmlExportProvider this$0, Project $project, ChangeEvent it) {
        this$0.saveSettings($project);
    }

    private static final void saveHtml$lambda$6(String $path, HtmlResourceSavingSettings $resDirPath, Project $project, BiConsumer $resultCallback, String source) {
        try {
            File file = new File($path);
            new HtmlExporter(source, $resDirPath, $project, file).export();
            $resultCallback.accept($path, true);
        }
        catch (Exception e) {
            $resultCallback.accept($path, false);
        }
    }

    @NotNull
    public static final MarkdownFileActionFormat getFormat() {
        return Companion.getFormat();
    }

    public static final /* synthetic */ void access$createSaveImageCheckbox(MarkdownHtmlExportProvider $this, Cell $receiver) {
        $this.createSaveImageCheckbox($receiver);
    }

    public static final /* synthetic */ void access$createResourceDirField(MarkdownHtmlExportProvider $this, Cell $receiver, Project project, File suggestedTargetFile) {
        $this.createResourceDirField($receiver, project, suggestedTargetFile);
    }

    public static final /* synthetic */ void access$addSettingsListeners(MarkdownHtmlExportProvider $this, Project project) {
        $this.addSettingsListeners(project);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\t\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/intellij/plugins/markdown/fileActions/export/MarkdownHtmlExportProvider$SaveSettingsListener;", "Ljava/awt/event/FocusListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lorg/intellij/plugins/markdown/fileActions/export/MarkdownHtmlExportProvider;Lcom/intellij/openapi/project/Project;)V", "focusGained", "", "e", "Ljava/awt/event/FocusEvent;", "focusLost", "intellij.markdown.core"})
    private final class SaveSettingsListener
    implements FocusListener {
        @NotNull
        private final Project project;

        public SaveSettingsListener(Project project) {
            this.project = project;
        }

        @Override
        public void focusGained(@Nullable FocusEvent e) {
        }

        @Override
        public void focusLost(@Nullable FocusEvent e) {
            FocusEvent focusEvent = e;
            Component component = focusEvent != null ? focusEvent.getComponent() : null;
            Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type javax.swing.JTextField");
            JTextField textEditor = (JTextField)component;
            JCheckBox jCheckBox = MarkdownHtmlExportProvider.this.saveImagesCheckbox;
            if (jCheckBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"saveImagesCheckbox");
                jCheckBox = null;
            }
            if (jCheckBox.isSelected() && ((CharSequence)textEditor.getText()).length() > 0) {
                MarkdownHtmlExportProvider.this.saveSettings(this.project);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/intellij/plugins/markdown/fileActions/export/MarkdownHtmlExportProvider$Companion;", "", "()V", "IMAGE_DIR_RESENT_KEYS", "", "Lorg/jetbrains/annotations/NonNls;", "format", "Lorg/intellij/plugins/markdown/fileActions/MarkdownFileActionFormat;", "getFormat$annotations", "getFormat", "()Lorg/intellij/plugins/markdown/fileActions/MarkdownFileActionFormat;", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MarkdownFileActionFormat getFormat() {
            return format;
        }

        @JvmStatic
        public static /* synthetic */ void getFormat$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

