/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.extensions.jcef.mermaid;

import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ColorUtil;
import com.intellij.util.Base64;
import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.plugins.markdown.extensions.MarkdownBrowserPreviewExtension;
import org.intellij.plugins.markdown.extensions.MarkdownCodeFenceCacheableProvider;
import org.intellij.plugins.markdown.extensions.jcef.mermaid.MermaidBrowserExtension;
import org.intellij.plugins.markdown.ui.preview.html.MarkdownCodeFencePluginCacheCollector;
import org.intellij.plugins.markdown.ui.preview.html.MarkdownUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002J \u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0014\u00a8\u0006\u0016"}, d2={"Lorg/intellij/plugins/markdown/extensions/jcef/mermaid/MermaidCodeGeneratingProviderExtension;", "Lorg/intellij/plugins/markdown/extensions/MarkdownCodeFenceCacheableProvider;", "collector", "Lorg/intellij/plugins/markdown/ui/preview/html/MarkdownCodeFencePluginCacheCollector;", "(Lorg/intellij/plugins/markdown/ui/preview/html/MarkdownCodeFencePluginCacheCollector;)V", "createRawContentElement", "", "hash", "content", "escapeContent", "generateHtml", "language", "raw", "node", "Lorg/intellij/markdown/ast/ASTNode;", "isApplicable", "", "store", "", "key", "", "Companion", "intellij.markdown.core"})
public final class MermaidCodeGeneratingProviderExtension
extends MarkdownCodeFenceCacheableProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public MermaidCodeGeneratingProviderExtension(@Nullable MarkdownCodeFencePluginCacheCollector collector) {
        super(collector);
    }

    public /* synthetic */ MermaidCodeGeneratingProviderExtension(MarkdownCodeFencePluginCacheCollector markdownCodeFencePluginCacheCollector, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            markdownCodeFencePluginCacheCollector = null;
        }
        this(markdownCodeFencePluginCacheCollector);
    }

    @Override
    public boolean isApplicable(@NotNull String language) {
        boolean bl;
        MermaidBrowserExtension.Provider provider = MermaidCodeGeneratingProviderExtension.Companion.getBrowserExtensionProvider();
        if (provider != null) {
            MermaidBrowserExtension.Provider it = provider;
            boolean bl2 = false;
            bl = it.isEnabled() && it.isAvailable();
        } else {
            bl = false;
        }
        return bl && Intrinsics.areEqual((Object)language, (Object)"mermaid");
    }

    @Override
    @NotNull
    public String generateHtml(@NotNull String language, @NotNull String raw, @NotNull ASTNode node) {
        String hash = MarkdownUtil.INSTANCE.md5(raw, "") + Companion.determineTheme();
        File key = this.getUniqueFile("mermaid", hash, "svg").toFile();
        return key.exists() ? "<img src=\"" + key.toURI() + "\"/>" : this.createRawContentElement(hash, raw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void store(@NotNull String key, @NotNull byte[] content2) {
        block6: {
            File actualKey = this.getUniqueFile("mermaid", key, "svg").toFile();
            FileUtil.createParentDirs((File)actualKey);
            Closeable closeable = new FileOutputStream(actualKey);
            int n = 8192;
            closeable = closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n);
            Throwable throwable = null;
            try {
                BufferedOutputStream it = (BufferedOutputStream)closeable;
                boolean bl = false;
                it.write(content2);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            MarkdownCodeFencePluginCacheCollector markdownCodeFencePluginCacheCollector = this.getCollector();
            if (markdownCodeFencePluginCacheCollector == null) break block6;
            MarkdownCodeFencePluginCacheCollector.addAliveCachedFile$default(markdownCodeFencePluginCacheCollector, this, actualKey, 0L, 4, null);
        }
    }

    private final String escapeContent(String content2) {
        String string = content2;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return Base64.encode((byte[])byArray);
    }

    private final String createRawContentElement(String hash, String content2) {
        return "<div class=\"mermaid\" data-cache-id=\"" + hash + "\" id=\"" + hash + "\" data-actual-fence-content=\"" + this.escapeContent(content2) + "\"></div>";
    }

    public MermaidCodeGeneratingProviderExtension() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bR\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/intellij/plugins/markdown/extensions/jcef/mermaid/MermaidCodeGeneratingProviderExtension$Companion;", "", "()V", "browserExtensionProvider", "Lorg/intellij/plugins/markdown/extensions/jcef/mermaid/MermaidBrowserExtension$Provider;", "getBrowserExtensionProvider", "()Lorg/intellij/plugins/markdown/extensions/jcef/mermaid/MermaidBrowserExtension$Provider;", "determineTheme", "", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        private final MermaidBrowserExtension.Provider getBrowserExtensionProvider() {
            Object v0;
            block1: {
                Iterable iterable = MarkdownBrowserPreviewExtension.Provider.Companion.getAll();
                for (Object t : iterable) {
                    MarkdownBrowserPreviewExtension.Provider it = (MarkdownBrowserPreviewExtension.Provider)t;
                    boolean bl = false;
                    if (!(it instanceof MermaidBrowserExtension.Provider)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            Object var1_6 = v0;
            return var1_6 instanceof MermaidBrowserExtension.Provider ? (MermaidBrowserExtension.Provider)var1_6 : null;
        }

        @NotNull
        public final String determineTheme() {
            String registryValue = Registry.stringValue((String)"markdown.mermaid.theme");
            if (Intrinsics.areEqual((Object)registryValue, (Object)"follow-ide")) {
                EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
                return ColorUtil.isDark((Color)scheme.getDefaultBackground()) ? "dark" : "default";
            }
            return registryValue;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

