/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.extensions.jcef.commandRunner;

import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.MarkdownUsageCollector;
import org.intellij.plugins.markdown.extensions.jcef.commandRunner.CommandRunnerExtension;
import org.intellij.plugins.markdown.extensions.jcef.commandRunner.MarkdownRunLineMarkersProvider;
import org.intellij.plugins.markdown.extensions.jcef.commandRunner.MarkdownRunner;
import org.intellij.plugins.markdown.extensions.jcef.commandRunner.RunnerPlace;
import org.intellij.plugins.markdown.extensions.jcef.commandRunner.RunnerType;
import org.intellij.plugins.markdown.extensions.jcef.commandRunner.TrustedProjectUtil;
import org.intellij.plugins.markdown.injection.aliases.CodeFenceLanguageGuesser;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFence;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\tH\u0016J\u0015\u0010\n\u001a\u00070\u0004\u00a2\u0006\u0002\b\u000b2\u0006\u0010\u0005\u001a\u00020\tH\u0002J\u001a\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\tH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/MarkdownRunLineMarkersProvider;", "Lcom/intellij/execution/lineMarker/RunLineMarkerContributor;", "()V", "collectFenceText", "", "element", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFence;", "getInfo", "Lcom/intellij/execution/lineMarker/RunLineMarkerContributor$Info;", "Lcom/intellij/psi/PsiElement;", "getText", "Lcom/intellij/openapi/util/NlsSafe;", "processBlock", "lang", "intellij.markdown.core"})
public final class MarkdownRunLineMarkersProvider
extends RunLineMarkerContributor {
    @Nullable
    public RunLineMarkerContributor.Info getInfo(@NotNull PsiElement element2) {
        boolean inCodeSpan;
        if (!CommandRunnerExtension.Companion.isExtensionEnabled() || !element2.isValid()) {
            return null;
        }
        if (PsiUtilsKt.hasType(element2, MarkdownTokenTypes.FENCE_LANG)) {
            String string = element2.getText();
            String lang = string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null;
            CharSequence charSequence = lang;
            if (!(charSequence == null || charSequence.length() == 0)) {
                return this.processBlock(lang, element2);
            }
        }
        boolean bl = inCodeSpan = PsiUtilsKt.hasType(element2, MarkdownTokenTypes.BACKTICK) && PsiUtilsKt.hasType(element2.getParent(), MarkdownElementTypes.CODE_SPAN) && Intrinsics.areEqual((Object)element2.getParent().getFirstChild(), (Object)element2);
        if (!PsiUtilsKt.hasType(element2, MarkdownTokenTypes.CODE_FENCE_CONTENT) && !inCodeSpan) {
            return null;
        }
        Object object = element2.getContainingFile().getVirtualFile().getParent();
        if (object == null || (object = object.getPath()) == null) {
            return null;
        }
        Object dir = object;
        String text = this.getText(element2);
        if (!CommandRunnerExtension.Companion.matches(element2.getProject(), (String)dir, true, text, inCodeSpan)) {
            return null;
        }
        getInfo.runAction.1[] nullArray = () -> MarkdownRunLineMarkersProvider.getInfo$lambda$0(text);
        Icon icon = AllIcons.RunConfigurations.TestState.Run;
        AnAction runAction2 = new AnAction((String)dir, text, (Supplier<String>)nullArray, icon){
            final /* synthetic */ String $dir;
            final /* synthetic */ String $text;
            {
                this.$dir = $dir;
                this.$text = $text;
                super($super_call_param$1, $super_call_param$2);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Project project = e.getProject();
                Intrinsics.checkNotNull((Object)project);
                CommandRunnerExtension.Companion.execute(project, this.$dir, true, this.$text, DefaultRunExecutor.getRunExecutorInstance(), RunnerPlace.EDITOR);
            }
        };
        nullArray = new getInfo.runAction.1[]{runAction2};
        return new RunLineMarkerContributor.Info(AllIcons.RunConfigurations.TestState.Run, (AnAction[])nullArray, arg_0 -> MarkdownRunLineMarkersProvider.getInfo$lambda$1((Function1)new Function1<PsiElement, String>(text){
            final /* synthetic */ String $text;
            {
                this.$text = $text;
                super(1);
            }

            public final String invoke(PsiElement it) {
                Object[] objectArray = new Object[]{this.$text};
                return MarkdownBundle.message("markdown.runner.launch.command", objectArray);
            }
        }, arg_0));
    }

    private final String collectFenceText(MarkdownCodeFence element2) {
        List<PsiElement> list2 = MarkdownCodeFence.Companion.obtainFenceContent(element2, false);
        if (list2 == null) {
            return null;
        }
        List<PsiElement> fenceElements = list2;
        return CommandRunnerExtension.Companion.trimPrompt$intellij_markdown_core(CollectionsKt.joinToString$default((Iterable)fenceElements, (CharSequence)"", null, null, (int)0, null, (Function1)collectFenceText.1.INSTANCE, (int)30, null));
    }

    private final RunLineMarkerContributor.Info processBlock(String lang, PsiElement element2) {
        Object object;
        MarkdownRunner runner;
        block8: {
            block7: {
                Object v0;
                block6: {
                    Language language = CodeFenceLanguageGuesser.guessLanguageForInjection(lang);
                    Iterable $this$firstOrNull$iv = MarkdownRunner.Companion.getEP_NAME().getExtensionList();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        MarkdownRunner it = (MarkdownRunner)element$iv;
                        boolean bl = false;
                        if (!it.isApplicable(language)) continue;
                        v0 = element$iv;
                        break block6;
                    }
                    v0 = null;
                }
                MarkdownRunner markdownRunner = v0;
                if (markdownRunner == null) {
                    return null;
                }
                runner = markdownRunner;
                PsiElement $i$f$firstOrNull = element2.getParent();
                object = $i$f$firstOrNull instanceof MarkdownCodeFence ? (MarkdownCodeFence)$i$f$firstOrNull : null;
                if (object == null) break block7;
                MarkdownCodeFence p0 = object;
                boolean bl = false;
                String string = this.collectFenceText(p0);
                object = string;
                if (string != null) break block8;
            }
            return null;
        }
        Object text = object;
        Object object2 = element2.getContainingFile().getVirtualFile().getParent();
        if (object2 == null || (object2 = object2.getPath()) == null) {
            return null;
        }
        Object dir = object2;
        AnAction[] anActionArray = () -> MarkdownRunLineMarkersProvider.processBlock$lambda$3(runner);
        Icon icon = AllIcons.RunConfigurations.TestState.Run_run;
        AnAction runAction2 = new AnAction(runner, (String)text, (String)dir, (Supplier<String>)anActionArray, icon){
            final /* synthetic */ MarkdownRunner $runner;
            final /* synthetic */ String $text;
            final /* synthetic */ String $dir;
            {
                this.$runner = $runner;
                this.$text = $text;
                this.$dir = $dir;
                super($super_call_param$1, $super_call_param$2);
            }

            public void actionPerformed(@NotNull AnActionEvent event) {
                Project project = (Project)event.getRequiredData(CommonDataKeys.PROJECT);
                TrustedProjectUtil.INSTANCE.executeIfTrusted(project, (Function0<Unit>)((Function0)new Function0<Unit>(project, this.$runner, this.$text, this.$dir){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ MarkdownRunner $runner;
                    final /* synthetic */ String $text;
                    final /* synthetic */ String $dir;
                    {
                        this.$project = $project;
                        this.$runner = $runner;
                        this.$text = $text;
                        this.$dir = $dir;
                        super(0);
                    }

                    public final void invoke() {
                        MarkdownUsageCollector.RUNNER_EXECUTED.log(this.$project, (Object)((Object)RunnerPlace.EDITOR), (Object)((Object)RunnerType.BLOCK), this.$runner.getClass());
                        this.$runner.run(this.$text, this.$project, this.$dir, DefaultRunExecutor.getRunExecutorInstance());
                    }
                }));
            }
        };
        anActionArray = new AnAction[]{runAction2};
        return new RunLineMarkerContributor.Info(AllIcons.RunConfigurations.TestState.Run_run, arg_0 -> MarkdownRunLineMarkersProvider.processBlock$lambda$4((Function1)new Function1<PsiElement, String>(runner){
            final /* synthetic */ MarkdownRunner $runner;
            {
                this.$runner = $runner;
                super(1);
            }

            public final String invoke(PsiElement it) {
                return this.$runner.title();
            }
        }, arg_0), anActionArray);
    }

    private final String getText(PsiElement element2) {
        if (PsiUtilsKt.hasType(element2, MarkdownTokenTypes.CODE_FENCE_CONTENT)) {
            return ((Object)StringsKt.trim((CharSequence)element2.getText())).toString();
        }
        if (PsiUtilsKt.hasType(element2, MarkdownTokenTypes.BACKTICK)) {
            String codeSpanText = element2.getParent().getText();
            String string = codeSpanText.substring(1, codeSpanText.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            return ((Object)StringsKt.trim((CharSequence)string)).toString();
        }
        return "";
    }

    private static final String getInfo$lambda$0(String $text) {
        Object[] objectArray = new Object[]{$text};
        return MarkdownBundle.message("markdown.runner.launch.command", objectArray);
    }

    private static final String getInfo$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final String processBlock$lambda$3(MarkdownRunner $runner) {
        return $runner.title();
    }

    private static final String processBlock$lambda$4(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }
}

