/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.extensions.jcef.commandRunner;

import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.runAnything.RunAnythingAction;
import com.intellij.ide.actions.runAnything.RunAnythingContext;
import com.intellij.ide.actions.runAnything.RunAnythingRunConfigurationProvider;
import com.intellij.ide.actions.runAnything.activity.RunAnythingCommandProvider;
import com.intellij.ide.actions.runAnything.activity.RunAnythingProvider;
import com.intellij.ide.actions.runAnything.activity.RunAnythingRecentProjectProvider;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AppUIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.MarkdownUsageCollector;
import org.intellij.plugins.markdown.extensions.MarkdownBrowserPreviewExtension;
import org.intellij.plugins.markdown.extensions.MarkdownExtensionsUtil;
import org.intellij.plugins.markdown.extensions.jcef.commandRunner.CommandRunnerExtension;
import org.intellij.plugins.markdown.extensions.jcef.commandRunner.MarkdownRunner;
import org.intellij.plugins.markdown.extensions.jcef.commandRunner.RunnerPlace;
import org.intellij.plugins.markdown.extensions.jcef.commandRunner.RunnerType;
import org.intellij.plugins.markdown.extensions.jcef.commandRunner.TrustedProjectUtil;
import org.intellij.plugins.markdown.injection.aliases.CodeFenceLanguageGuesser;
import org.intellij.plugins.markdown.settings.MarkdownExtensionsSettings;
import org.intellij.plugins.markdown.ui.preview.BrowserPipe;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.ResourceProvider;
import org.intellij.plugins.markdown.ui.preview.html.MarkdownUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0010\b\u0000\u0018\u0000 ,2\u00020\u0001:\u0004*+,-B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\tH\u0002J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\tH\u0002J\u0018\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\tH\u0002J\u0016\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\tJ\u0016\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001eJ\u001a\u0010%\u001a\u0004\u0018\u00010\t2\u0006\u0010$\u001a\u00020\t2\u0006\u0010&\u001a\u00020\u001eH\u0002J\u0010\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\tH\u0002J\u0010\u0010)\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\tH\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006."}, d2={"Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension;", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension;", "panel", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;", "provider", "Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension$Provider;", "(Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension$Provider;)V", "hash2Cmd", "", "", "getPanel", "()Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;", "resourceProvider", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "getResourceProvider", "()Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "scripts", "", "getScripts", "()Ljava/util/List;", "styles", "getStyles", "dispose", "", "executeBlock", "command", "executorId", "executeLineCommand", "getHtmlForLineRunner", "insideFence", "", "hash", "processCodeBlock", "codeFenceRawContent", "language", "processCodeLine", "rawCodeLine", "processLine", "allowRunConfigurations", "runBlock", "encodedLine", "runLine", "CommandRunnerIconsResourceProvider", "CommandRunnerResourceProvider", "Companion", "Provider", "intellij.markdown.core"})
public final class CommandRunnerExtension
implements MarkdownBrowserPreviewExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MarkdownHtmlPanel panel;
    @NotNull
    private final Provider provider;
    @NotNull
    private final List<String> scripts;
    @NotNull
    private final List<String> styles;
    @NotNull
    private final Map<String, String> hash2Cmd;
    @NotNull
    private final ResourceProvider resourceProvider;
    @NotNull
    private static final String RUN_LINE_EVENT = "runLine";
    @NotNull
    private static final String RUN_BLOCK_EVENT = "runBlock";
    @NotNull
    private static final String RUN_LINE_ICON = "commandRunner/run.png";
    @NotNull
    private static final String RUN_BLOCK_ICON = "commandRunner/runrun.png";
    @NotNull
    public static final String extensionId = "MarkdownCommandRunnerExtension";
    @NotNull
    private static final Logger LOG;

    public CommandRunnerExtension(@NotNull MarkdownHtmlPanel panel2, @NotNull Provider provider) {
        this.panel = panel2;
        this.provider = provider;
        this.scripts = CollectionsKt.listOf((Object)"commandRunner/commandRunner.js");
        this.styles = CollectionsKt.listOf((Object)"commandRunner/commandRunner.css");
        this.hash2Cmd = new LinkedHashMap();
        BrowserPipe browserPipe = this.panel.getBrowserPipe();
        if (browserPipe != null) {
            browserPipe.subscribe(RUN_LINE_EVENT, new BrowserPipe.Handler(){

                @Override
                public final void messageReceived(@NotNull String p0) {
                    CommandRunnerExtension.this.runLine(p0);
                }

                @NotNull
                public final Function<?> getFunctionDelegate() {
                    return (Function)new FunctionReferenceImpl(1, (Object)CommandRunnerExtension.this, CommandRunnerExtension.class, CommandRunnerExtension.RUN_LINE_EVENT, "runLine(Ljava/lang/String;)V", 0);
                }

                public final boolean equals(@Nullable Object other) {
                    return other instanceof BrowserPipe.Handler ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
                }

                public final int hashCode() {
                    return this.getFunctionDelegate().hashCode();
                }
            });
        }
        BrowserPipe browserPipe2 = this.panel.getBrowserPipe();
        if (browserPipe2 != null) {
            browserPipe2.subscribe(RUN_BLOCK_EVENT, new BrowserPipe.Handler(){

                @Override
                public final void messageReceived(@NotNull String p0) {
                    CommandRunnerExtension.this.runBlock(p0);
                }

                @NotNull
                public final Function<?> getFunctionDelegate() {
                    return (Function)new FunctionReferenceImpl(1, (Object)CommandRunnerExtension.this, CommandRunnerExtension.class, CommandRunnerExtension.RUN_BLOCK_EVENT, "runBlock(Ljava/lang/String;)V", 0);
                }

                public final boolean equals(@Nullable Object other) {
                    return other instanceof BrowserPipe.Handler ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
                }

                public final int hashCode() {
                    return this.getFunctionDelegate().hashCode();
                }
            });
        }
        Disposer.register((Disposable)this, () -> CommandRunnerExtension._init_$lambda$0(this));
        ResourceProvider[] resourceProviderArray = new ResourceProvider[]{new CommandRunnerResourceProvider(), new CommandRunnerIconsResourceProvider()};
        this.resourceProvider = ResourceProvider.Companion.aggregating(resourceProviderArray);
    }

    @NotNull
    public final MarkdownHtmlPanel getPanel() {
        return this.panel;
    }

    @Override
    @NotNull
    public List<String> getScripts() {
        return this.scripts;
    }

    @Override
    @NotNull
    public List<String> getStyles() {
        return this.styles;
    }

    @Override
    @NotNull
    public ResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    @NotNull
    public final String processCodeLine(@NotNull String rawCodeLine, boolean insideFence) {
        String string = this.processLine(rawCodeLine, !insideFence);
        if (string != null) {
            String hash = string;
            boolean bl = false;
            return this.getHtmlForLineRunner(insideFence, hash);
        }
        return "";
    }

    private final String processLine(String rawCodeLine, boolean allowRunConfigurations) {
        try {
            Project project = this.panel.getProject();
            VirtualFile file = this.panel.getVirtualFile();
            if (project != null && file != null && file.getParent() != null && Companion.matches(project, file.getParent().getCanonicalPath(), true, ((Object)StringsKt.trim((CharSequence)rawCodeLine)).toString(), allowRunConfigurations)) {
                String hash = MarkdownUtil.INSTANCE.md5(rawCodeLine, "");
                this.hash2Cmd.put(hash, rawCodeLine);
                return hash;
            }
            return null;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    private final String getHtmlForLineRunner(boolean insideFence, String hash) {
        String cssClass = "run-icon" + (insideFence ? " code-block" : "");
        return "<a class='" + cssClass + "' href='#' role='button' data-command='Run:" + hash + "'><img src='commandRunner/run.png'></a>";
    }

    @NotNull
    public final String processCodeBlock(@NotNull String codeFenceRawContent, @NotNull String language) {
        try {
            Object v0;
            Object it;
            block4: {
                Language lang = CodeFenceLanguageGuesser.guessLanguageForInjection(language);
                Iterable $this$firstOrNull$iv = MarkdownRunner.Companion.getEP_NAME().getExtensionList();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (MarkdownRunner)element$iv;
                    boolean bl = false;
                    if (!it.isApplicable(lang)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            MarkdownRunner runner = v0;
            if (runner == null) {
                return "";
            }
            String hash = MarkdownUtil.INSTANCE.md5(codeFenceRawContent, "");
            this.hash2Cmd.put(hash, codeFenceRawContent);
            List lines2 = StringsKt.lines((CharSequence)((Object)StringsKt.trimEnd((CharSequence)codeFenceRawContent)).toString());
            String firstLineHash = lines2.size() > 1 ? this.processLine((String)lines2.get(0), false) : null;
            it = firstLineHash;
            Object firstLineData = it == null || StringsKt.isBlank((CharSequence)it) ? "" : "data-firstLine='" + firstLineHash + "'";
            String cssClass = "run-icon code-block";
            return "<a class='" + cssClass + "' href='#' role='button' data-command='Run:" + hash + "' data-commandtype='block'" + (String)firstLineData + "><img src='commandRunner/runrun.png'></a>";
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return "";
        }
    }

    private final void runLine(String encodedLine) {
        String executorId = StringsKt.substringBefore$default((String)encodedLine, (String)":", null, (int)2, null);
        String cmdHash = StringsKt.substringAfter$default((String)encodedLine, (String)":", null, (int)2, null);
        String command = this.hash2Cmd.get(cmdHash);
        if (command == null) {
            LOG.error("Command index " + cmdHash + " not found. Please attach .md file to error report. commandCache = " + this.hash2Cmd);
            return;
        }
        this.executeLineCommand(command, executorId);
    }

    private final void executeLineCommand(String command, String executorId) {
        Executor executor = ExecutorRegistry.getInstance().getExecutorById(executorId);
        if (executor == null) {
            executor = DefaultRunExecutor.getRunExecutorInstance();
        }
        Executor executor2 = executor;
        Project project = this.panel.getProject();
        VirtualFile virtualFile = this.panel.getVirtualFile();
        if (project != null && virtualFile != null) {
            Companion.execute(project, virtualFile.getParent().getCanonicalPath(), true, command, executor2, RunnerPlace.PREVIEW);
        }
    }

    private final void executeBlock(String command, String executorId) {
        MarkdownRunner runner = (MarkdownRunner)CollectionsKt.first((List)MarkdownRunner.Companion.getEP_NAME().getExtensionList());
        Executor executor = ExecutorRegistry.getInstance().getExecutorById(executorId);
        if (executor == null) {
            executor = DefaultRunExecutor.getRunExecutorInstance();
        }
        Executor executor2 = executor;
        Project project = this.panel.getProject();
        VirtualFile virtualFile = this.panel.getVirtualFile();
        if (project != null && virtualFile != null) {
            TrustedProjectUtil.INSTANCE.executeIfTrusted(project, (Function0<Unit>)((Function0)new Function0<Unit>(project, runner, command, virtualFile, executor2){
                final /* synthetic */ Project $project;
                final /* synthetic */ MarkdownRunner $runner;
                final /* synthetic */ String $command;
                final /* synthetic */ VirtualFile $virtualFile;
                final /* synthetic */ Executor $executor;
                {
                    this.$project = $project;
                    this.$runner = $runner;
                    this.$command = $command;
                    this.$virtualFile = $virtualFile;
                    this.$executor = $executor;
                    super(0);
                }

                public final void invoke() {
                    MarkdownUsageCollector.RUNNER_EXECUTED.log(this.$project, (Object)((Object)RunnerPlace.PREVIEW), (Object)((Object)RunnerType.BLOCK), this.$runner.getClass());
                    MarkdownRunner markdownRunner = this.$runner;
                    String string = this.$command;
                    Project project = this.$project;
                    VirtualFile virtualFile = this.$virtualFile;
                    Executor executor = this.$executor;
                    Object modalityState$iv = null;
                    boolean $i$f$invokeLater = false;
                    ApplicationManager.getApplication().invokeLater(new Runnable(markdownRunner, string, project, virtualFile, executor){
                        final /* synthetic */ MarkdownRunner $runner$inlined;
                        final /* synthetic */ String $command$inlined;
                        final /* synthetic */ Project $project$inlined;
                        final /* synthetic */ VirtualFile $virtualFile$inlined;
                        final /* synthetic */ Executor $executor$inlined;
                        {
                            this.$runner$inlined = markdownRunner;
                            this.$command$inlined = string;
                            this.$project$inlined = project;
                            this.$virtualFile$inlined = virtualFile;
                            this.$executor$inlined = executor;
                        }

                        public final void run() {
                            boolean bl = false;
                            this.$runner$inlined.run(this.$command$inlined, this.$project$inlined, this.$virtualFile$inlined.getParent().getCanonicalPath(), this.$executor$inlined);
                        }
                    }, ModalityState.defaultModalityState());
                }
            }));
        }
    }

    private final void runBlock(String encodedLine) {
        String[] stringArray = new String[]{":"};
        List args = StringsKt.split$default((CharSequence)encodedLine, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String executorId = (String)args.get(0);
        String cmdHash = (String)args.get(1);
        String command = this.hash2Cmd.get(cmdHash);
        String firstLineCommand = this.hash2Cmd.get(args.get(2));
        if (command == null) {
            LOG.error("Command hash " + cmdHash + " not found. Please attach .md file to error report.\n" + this.hash2Cmd);
            return;
        }
        String trimmedCmd = Companion.trimPrompt$intellij_markdown_core(command);
        if (firstLineCommand == null) {
            ApplicationManager.getApplication().invokeLater(() -> CommandRunnerExtension.runBlock$lambda$3(this, trimmedCmd, executorId));
            return;
        }
        int x = Integer.parseInt((String)args.get(3));
        int y = Integer.parseInt((String)args.get(4));
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        Supplier<String> supplier = CommandRunnerExtension::runBlock$lambda$4;
        Object object = AllIcons.RunConfigurations.TestState.Run_run;
        AnAction runBlockAction2 = new AnAction(this, trimmedCmd, executorId, supplier, (Icon)object){
            final /* synthetic */ CommandRunnerExtension this$0;
            final /* synthetic */ String $trimmedCmd;
            final /* synthetic */ String $executorId;
            {
                this.this$0 = $receiver;
                this.$trimmedCmd = $trimmedCmd;
                this.$executorId = $executorId;
                super($super_call_param$1, $super_call_param$2);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                ApplicationManager.getApplication().invokeLater(() -> runBlock.runBlockAction.1.actionPerformed$lambda$0(this.this$0, this.$trimmedCmd, this.$executorId));
            }

            private static final void actionPerformed$lambda$0(CommandRunnerExtension this$0, String $trimmedCmd, String $executorId) {
                CommandRunnerExtension.access$executeBlock(this$0, $trimmedCmd, $executorId);
            }
        };
        object = CommandRunnerExtension::runBlock$lambda$5;
        Icon icon = AllIcons.RunConfigurations.TestState.Run;
        AnAction runLineAction2 = new AnAction(this, firstLineCommand, executorId, (Supplier<String>)object, icon){
            final /* synthetic */ CommandRunnerExtension this$0;
            final /* synthetic */ String $firstLineCommand;
            final /* synthetic */ String $executorId;
            {
                this.this$0 = $receiver;
                this.$firstLineCommand = $firstLineCommand;
                this.$executorId = $executorId;
                super($super_call_param$1, $super_call_param$2);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                ApplicationManager.getApplication().invokeLater(() -> runBlock.runLineAction.1.actionPerformed$lambda$0(this.this$0, this.$firstLineCommand, this.$executorId));
            }

            private static final void actionPerformed$lambda$0(CommandRunnerExtension this$0, String $firstLineCommand, String $executorId) {
                CommandRunnerExtension.access$executeLineCommand(this$0, $firstLineCommand, $executorId);
            }
        };
        actionGroup.add(runBlockAction2);
        actionGroup.add(runLineAction2);
        AppUIUtil.invokeOnEdt(() -> CommandRunnerExtension.runBlock$lambda$6(actionManager, actionGroup, this, x, y));
    }

    public void dispose() {
        Map map = this.provider.getExtensions();
        VirtualFile virtualFile = this.panel.getVirtualFile();
        TypeIntrinsics.asMutableMap((Object)map).remove(virtualFile);
    }

    private static final void _init_$lambda$0(CommandRunnerExtension this$0) {
        block1: {
            BrowserPipe browserPipe = this$0.panel.getBrowserPipe();
            if (browserPipe != null) {
                browserPipe.removeSubscription(RUN_LINE_EVENT, new BrowserPipe.Handler(this$0){
                    final /* synthetic */ CommandRunnerExtension $tmp0;
                    {
                        this.$tmp0 = $tmp0;
                    }

                    public final void messageReceived(@NotNull String p0) {
                        CommandRunnerExtension.access$runLine(this.$tmp0, p0);
                    }

                    @NotNull
                    public final Function<?> getFunctionDelegate() {
                        return (Function)new FunctionReferenceImpl(1, (Object)this.$tmp0, CommandRunnerExtension.class, "runLine", "runLine(Ljava/lang/String;)V", 0);
                    }

                    public final boolean equals(@Nullable Object other) {
                        return other instanceof BrowserPipe.Handler ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
                    }

                    public final int hashCode() {
                        return this.getFunctionDelegate().hashCode();
                    }
                });
            }
            BrowserPipe browserPipe2 = this$0.panel.getBrowserPipe();
            if (browserPipe2 == null) break block1;
            browserPipe2.removeSubscription(RUN_BLOCK_EVENT, new BrowserPipe.Handler(this$0){
                final /* synthetic */ CommandRunnerExtension $tmp0;
                {
                    this.$tmp0 = $tmp0;
                }

                public final void messageReceived(@NotNull String p0) {
                    CommandRunnerExtension.access$runBlock(this.$tmp0, p0);
                }

                @NotNull
                public final Function<?> getFunctionDelegate() {
                    return (Function)new FunctionReferenceImpl(1, (Object)this.$tmp0, CommandRunnerExtension.class, "runBlock", "runBlock(Ljava/lang/String;)V", 0);
                }

                public final boolean equals(@Nullable Object other) {
                    return other instanceof BrowserPipe.Handler ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
                }

                public final int hashCode() {
                    return this.getFunctionDelegate().hashCode();
                }
            });
        }
    }

    private static final void runBlock$lambda$3(CommandRunnerExtension this$0, String $trimmedCmd, String $executorId) {
        this$0.executeBlock($trimmedCmd, $executorId);
    }

    private static final String runBlock$lambda$4() {
        return MarkdownBundle.message("markdown.runner.launch.block", new Object[0]);
    }

    private static final String runBlock$lambda$5() {
        return MarkdownBundle.message("markdown.runner.launch.line", new Object[0]);
    }

    private static final void runBlock$lambda$6(ActionManager $actionManager, DefaultActionGroup $actionGroup, CommandRunnerExtension this$0, int $x, int $y) {
        $actionManager.createActionPopupMenu("ICON_NAVIGATION_SECONDARY_BUTTON", (ActionGroup)$actionGroup).getComponent().show(this$0.panel.getComponent(), $x, $y);
    }

    public static final /* synthetic */ void access$executeBlock(CommandRunnerExtension $this, String command, String executorId) {
        $this.executeBlock(command, executorId);
    }

    public static final /* synthetic */ void access$executeLineCommand(CommandRunnerExtension $this, String command, String executorId) {
        $this.executeLineCommand(command, executorId);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CommandRunnerExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension$CommandRunnerResourceProvider;", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "(Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension;)V", "canProvide", "", "resourceName", "", "loadResource", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider$Resource;", "intellij.markdown.core"})
    private final class CommandRunnerResourceProvider
    implements ResourceProvider {
        @Override
        public boolean canProvide(@NotNull String resourceName) {
            return CommandRunnerExtension.this.getScripts().contains(resourceName) || CommandRunnerExtension.this.getStyles().contains(resourceName);
        }

        @Override
        @Nullable
        public ResourceProvider.Resource loadResource(@NotNull String resourceName) {
            ResourceProvider.Companion $this$iv = ResourceProvider.Companion;
            String contentType$iv = null;
            boolean $i$f$loadInternalResource = false;
            return $this$iv.loadInternalResource(CommandRunnerResourceProvider.class, resourceName, contentType$iv);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension$CommandRunnerIconsResourceProvider;", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "()V", "canProvide", "", "resourceName", "", "loadResource", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider$Resource;", "Companion", "intellij.markdown.core"})
    private static final class CommandRunnerIconsResourceProvider
    implements ResourceProvider {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final Set<String> icons;

        @Override
        public boolean canProvide(@NotNull String resourceName) {
            return icons.contains(resourceName);
        }

        @Override
        @Nullable
        public ResourceProvider.Resource loadResource(@NotNull String resourceName) {
            Icon icon;
            String string = resourceName;
            if (Intrinsics.areEqual((Object)string, (Object)CommandRunnerExtension.RUN_LINE_ICON)) {
                icon = AllIcons.RunConfigurations.TestState.Run;
            } else if (Intrinsics.areEqual((Object)string, (Object)CommandRunnerExtension.RUN_BLOCK_ICON)) {
                icon = AllIcons.RunConfigurations.TestState.Run_run;
            } else {
                return null;
            }
            Icon icon2 = icon;
            String format = StringsKt.substringAfterLast$default((String)resourceName, (String)".", null, (int)2, null);
            return new ResourceProvider.Resource(MarkdownExtensionsUtil.INSTANCE.loadIcon(icon2, format), null, 2, null);
        }

        static {
            Object[] objectArray = new String[]{CommandRunnerExtension.RUN_LINE_ICON, CommandRunnerExtension.RUN_BLOCK_ICON};
            icons = SetsKt.setOf((Object[])objectArray);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension$CommandRunnerIconsResourceProvider$Companion;", "", "()V", "icons", "", "", "intellij.markdown.core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension$Provider;", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension$Provider;", "()V", "extensions", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension;", "getExtensions", "()Ljava/util/concurrent/ConcurrentHashMap;", "createBrowserExtension", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension;", "panel", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;", "intellij.markdown.core"})
    public static final class Provider
    implements MarkdownBrowserPreviewExtension.Provider {
        @NotNull
        private final ConcurrentHashMap<VirtualFile, CommandRunnerExtension> extensions = new ConcurrentHashMap();

        @NotNull
        public final ConcurrentHashMap<VirtualFile, CommandRunnerExtension> getExtensions() {
            return this.extensions;
        }

        @Override
        @Nullable
        public MarkdownBrowserPreviewExtension createBrowserExtension(@NotNull MarkdownHtmlPanel panel2) {
            VirtualFile virtualFile = panel2.getVirtualFile();
            if (virtualFile == null) {
                return null;
            }
            VirtualFile virtualFile2 = virtualFile;
            if (!Companion.isExtensionEnabled()) {
                return null;
            }
            return this.extensions.computeIfAbsent(virtualFile2, arg_0 -> Provider.createBrowserExtension$lambda$0((Function1)new Function1<VirtualFile, CommandRunnerExtension>(panel2, this){
                final /* synthetic */ MarkdownHtmlPanel $panel;
                final /* synthetic */ Provider this$0;
                {
                    this.$panel = $panel;
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final CommandRunnerExtension invoke(@NotNull VirtualFile it) {
                    return new CommandRunnerExtension(this.$panel, this.this$0);
                }
            }, arg_0));
        }

        private static final CommandRunnerExtension createBrowserExtension$lambda$0(Function1 $tmp0, Object p0) {
            return (CommandRunnerExtension)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0002J.\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J8\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020\rJ2\u0010\"\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u00072\b\b\u0002\u0010\u0010\u001a\u00020\rJ\u0015\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b%R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "RUN_BLOCK_EVENT", "", "RUN_BLOCK_ICON", "RUN_LINE_EVENT", "RUN_LINE_ICON", "extensionId", "checkForCLI", "", "it", "Lcom/intellij/ide/actions/runAnything/activity/RunAnythingProvider;", "allowRunConfigurations", "createDataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "project", "Lcom/intellij/openapi/project/Project;", "localSession", "workingDirectory", "executor", "Lcom/intellij/execution/Executor;", "execute", "command", "place", "Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/RunnerPlace;", "getRunnerByFile", "Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isExtensionEnabled", "matches", "trimPrompt", "cmd", "trimPrompt$intellij_markdown_core", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isExtensionEnabled() {
            Boolean bl = MarkdownExtensionsSettings.Companion.getInstance().getExtensionsEnabledState().get(CommandRunnerExtension.extensionId);
            return bl != null ? bl : true;
        }

        @Nullable
        public final CommandRunnerExtension getRunnerByFile(@NotNull VirtualFile file) {
            MarkdownExtensionsUtil this_$iv = MarkdownExtensionsUtil.INSTANCE;
            boolean $i$f$findBrowserExtensionProvider = false;
            Provider provider = (Provider)((MarkdownBrowserPreviewExtension.Provider)MarkdownBrowserPreviewExtension.Provider.Companion.getEP().findExtension(Provider.class));
            Object object = provider;
            return object != null && (object = ((Provider)object).getExtensions()) != null ? (CommandRunnerExtension)((ConcurrentHashMap)object).get(file) : null;
        }

        public final boolean matches(@NotNull Project project, @Nullable String workingDirectory, boolean localSession, @NotNull String command, boolean allowRunConfigurations) {
            String trimmedCmd = ((Object)StringsKt.trim((CharSequence)command)).toString();
            if (((CharSequence)trimmedCmd).length() == 0) {
                return false;
            }
            DataContext dataContext = org.intellij.plugins.markdown.extensions.jcef.commandRunner.CommandRunnerExtension$Companion.createDataContext$default(this, project, localSession, workingDirectory, null, 8, null);
            boolean $i$f$runReadAction = false;
            return (Boolean)ApplicationManager.getApplication().runReadAction(new Computable(allowRunConfigurations, dataContext, trimmedCmd){
                final /* synthetic */ boolean $allowRunConfigurations$inlined;
                final /* synthetic */ DataContext $dataContext$inlined;
                final /* synthetic */ String $trimmedCmd$inlined;
                {
                    this.$allowRunConfigurations$inlined = bl;
                    this.$dataContext$inlined = dataContext;
                    this.$trimmedCmd$inlined = string;
                }

                public final T compute() {
                    boolean bl;
                    block1: {
                        boolean bl2 = false;
                        Sequence $this$any$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)RunAnythingProvider.EP_NAME.getExtensionList()), (Function1)((Function1)new Function1<RunAnythingProvider<?>, Boolean>(this.$allowRunConfigurations$inlined){
                            final /* synthetic */ boolean $allowRunConfigurations;
                            {
                                this.$allowRunConfigurations = $allowRunConfigurations;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(RunAnythingProvider<?> it) {
                                return org.intellij.plugins.markdown.extensions.jcef.commandRunner.CommandRunnerExtension$Companion.access$checkForCLI(CommandRunnerExtension.Companion, it, this.$allowRunConfigurations);
                            }
                        }));
                        boolean $i$f$any = false;
                        for (E element$iv : $this$any$iv) {
                            RunAnythingProvider provider = (RunAnythingProvider)element$iv;
                            boolean bl3 = false;
                            if (!(provider.findMatchingValue(this.$dataContext$inlined, this.$trimmedCmd$inlined) != null)) continue;
                            bl = true;
                            break block1;
                        }
                        bl = false;
                    }
                    return (T)Boolean.valueOf(bl);
                }
            });
        }

        public static /* synthetic */ boolean matches$default(Companion companion, Project project, String string, boolean bl, String string2, boolean bl2, int n, Object object) {
            if ((n & 0x10) != 0) {
                bl2 = false;
            }
            return companion.matches(project, string, bl, string2, bl2);
        }

        public final boolean execute(@NotNull Project project, @Nullable String workingDirectory, boolean localSession, @NotNull String command, @NotNull Executor executor, @NotNull RunnerPlace place) {
            DataContext dataContext = this.createDataContext(project, localSession, workingDirectory, executor);
            String trimmedCmd = ((Object)StringsKt.trim((CharSequence)command)).toString();
            boolean $i$f$runReadAction = false;
            return (Boolean)ApplicationManager.getApplication().runReadAction(new Computable(dataContext, trimmedCmd, project, place){
                final /* synthetic */ DataContext $dataContext$inlined;
                final /* synthetic */ String $trimmedCmd$inlined;
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ RunnerPlace $place$inlined;
                {
                    this.$dataContext$inlined = dataContext;
                    this.$trimmedCmd$inlined = string;
                    this.$project$inlined = project;
                    this.$place$inlined = runnerPlace;
                }

                public final T compute() {
                    boolean bl;
                    block1: {
                        boolean bl2 = false;
                        for (RunAnythingProvider provider : RunAnythingProvider.EP_NAME.getExtensionList()) {
                            Object object = provider.findMatchingValue(this.$dataContext$inlined, this.$trimmedCmd$inlined);
                            if (object == null) continue;
                            Object value = object;
                            bl = TrustedProjectUtil.INSTANCE.executeIfTrusted(this.$project$inlined, (Function0<Unit>)((Function0)new Function0<Unit>(this.$project$inlined, this.$place$inlined, provider, this.$dataContext$inlined, value){
                                final /* synthetic */ Project $project;
                                final /* synthetic */ RunnerPlace $place;
                                final /* synthetic */ RunAnythingProvider<?> $provider;
                                final /* synthetic */ DataContext $dataContext;
                                final /* synthetic */ Object $value;
                                {
                                    this.$project = $project;
                                    this.$place = $place;
                                    this.$provider = $provider;
                                    this.$dataContext = $dataContext;
                                    this.$value = $value;
                                    super(0);
                                }

                                public final void invoke() {
                                    MarkdownUsageCollector.RUNNER_EXECUTED.log(this.$project, (Object)((Object)this.$place), (Object)((Object)RunnerType.LINE), this.$provider.getClass());
                                    RunAnythingProvider<?> runAnythingProvider = this.$provider;
                                    DataContext dataContext = this.$dataContext;
                                    Object object = this.$value;
                                    Object modalityState$iv = null;
                                    boolean $i$f$invokeLater = false;
                                    ApplicationManager.getApplication().invokeLater(new Runnable(runAnythingProvider, dataContext, object){
                                        final /* synthetic */ RunAnythingProvider $provider$inlined;
                                        final /* synthetic */ DataContext $dataContext$inlined;
                                        final /* synthetic */ Object $value$inlined;
                                        {
                                            this.$provider$inlined = runAnythingProvider;
                                            this.$dataContext$inlined = dataContext;
                                            this.$value$inlined = object;
                                        }

                                        public final void run() {
                                            boolean bl = false;
                                            this.$provider$inlined.execute(this.$dataContext$inlined, this.$value$inlined);
                                        }
                                    }, ModalityState.defaultModalityState());
                                }
                            }));
                            break block1;
                        }
                        bl = false;
                    }
                    return (T)Boolean.valueOf(bl);
                }
            });
        }

        private final DataContext createDataContext(Project project, boolean localSession, String workingDirectory, Executor executor) {
            SimpleDataContext.Builder builder;
            VirtualFile virtualFile = localSession && workingDirectory != null ? LocalFileSystem.getInstance().findFileByPath(workingDirectory) : null;
            SimpleDataContext.Builder $this$createDataContext_u24lambda_u243 = builder = SimpleDataContext.builder().add(CommonDataKeys.PROJECT, (Object)project).add(RunAnythingAction.EXECUTOR_KEY, (Object)executor);
            boolean bl = false;
            if (virtualFile != null) {
                $this$createDataContext_u24lambda_u243.add(CommonDataKeys.VIRTUAL_FILE, (Object)virtualFile);
                $this$createDataContext_u24lambda_u243.add(RunAnythingProvider.EXECUTING_CONTEXT, (Object)new RunAnythingContext.RecentDirectoryContext(virtualFile.getPath()));
            }
            return builder.build();
        }

        static /* synthetic */ DataContext createDataContext$default(Companion companion, Project project, boolean bl, String string, Executor executor, int n, Object object) {
            if ((n & 8) != 0) {
                executor = null;
            }
            return companion.createDataContext(project, bl, string, executor);
        }

        private final boolean checkForCLI(RunAnythingProvider<?> it, boolean allowRunConfigurations) {
            return !(it instanceof RunAnythingCommandProvider) && !(it instanceof RunAnythingRecentProjectProvider) && (!(it instanceof RunAnythingRunConfigurationProvider) || allowRunConfigurations);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String trimPrompt$intellij_markdown_core(@NotNull String cmd) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = StringsKt.lines((CharSequence)cmd);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String line = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = ((CharSequence)line).length() > 0;
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, (Function1)trimPrompt.2.INSTANCE, (int)30, null);
        }

        public static final /* synthetic */ boolean access$checkForCLI(Companion $this, RunAnythingProvider it, boolean allowRunConfigurations) {
            return $this.checkForCLI(it, allowRunConfigurations);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

