/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.extensions.jcef;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.jcef.JBCefPsiNavigationUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.intellij.plugins.markdown.extensions.MarkdownBrowserPreviewExtension;
import org.intellij.plugins.markdown.ui.preview.BrowserPipe;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanelEx;
import org.intellij.plugins.markdown.ui.preview.ResourceProvider;
import org.intellij.plugins.markdown.ui.preview.accessor.MarkdownLinkOpener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0002\u0019\u001aB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0012\u001a\u00020\rH\u0016J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\rH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/intellij/plugins/markdown/extensions/jcef/ProcessLinksExtension;", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension;", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "panel", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;", "(Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;)V", "handler", "Lorg/intellij/plugins/markdown/ui/preview/BrowserPipe$Handler;", "resourceProvider", "getResourceProvider", "()Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "scripts", "", "", "getScripts", "()Ljava/util/List;", "canProvide", "", "resourceName", "dispose", "", "loadResource", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider$Resource;", "openLink", "link", "Companion", "Provider", "intellij.markdown.core"})
public final class ProcessLinksExtension
implements MarkdownBrowserPreviewExtension,
ResourceProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MarkdownHtmlPanel panel;
    @NotNull
    private final BrowserPipe.Handler handler;
    @NotNull
    private final List<String> scripts;
    @NotNull
    private final ResourceProvider resourceProvider;
    @NotNull
    private static final String openLinkEventName = "openLink";

    public ProcessLinksExtension(@NotNull MarkdownHtmlPanel panel2) {
        this.panel = panel2;
        this.handler = arg_0 -> ProcessLinksExtension.handler$lambda$0(this, arg_0);
        BrowserPipe browserPipe = this.panel.getBrowserPipe();
        if (browserPipe != null) {
            browserPipe.subscribe(openLinkEventName, this.handler);
        }
        Disposer.register((Disposable)this, () -> ProcessLinksExtension._init_$lambda$1(this));
        this.scripts = CollectionsKt.listOf((Object)"processLinks/processLinks.js");
        this.resourceProvider = this;
    }

    private final void openLink(MarkdownHtmlPanel panel2, String link) {
        if (!Registry.is((String)"markdown.open.link.in.external.browser")) {
            return;
        }
        if (JBCefPsiNavigationUtils.INSTANCE.navigateTo(link)) {
            return;
        }
        if (panel2 instanceof MarkdownHtmlPanelEx && Intrinsics.areEqual((Object)((MarkdownHtmlPanelEx)panel2).getUserData(MarkdownHtmlPanelEx.Companion.getDO_NOT_USE_LINK_OPENER()), (Object)true)) {
            Object $this$openLink_u24lambda_u242;
            ProcessLinksExtension processLinksExtension = this;
            try {
                $this$openLink_u24lambda_u242 = processLinksExtension;
                boolean bl = false;
                BrowserUtil.browse((String)link);
                $this$openLink_u24lambda_u242 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                $this$openLink_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            ProcessLinksExtension $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(ProcessLinksExtension.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
            LoggerKt.getOrLogException((Object)$this$openLink_u24lambda_u242, (Logger)logger);
            return;
        }
        MarkdownLinkOpener.Companion.getInstance().openLink(panel2.getProject(), link);
    }

    @Override
    @NotNull
    public List<String> getScripts() {
        return this.scripts;
    }

    @Override
    @NotNull
    public ResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    @Override
    public boolean canProvide(@NotNull String resourceName) {
        return this.getScripts().contains(resourceName);
    }

    @Override
    @Nullable
    public ResourceProvider.Resource loadResource(@NotNull String resourceName) {
        return ResourceProvider.Companion.loadInternalResource$default(ResourceProvider.Companion, Reflection.getOrCreateKotlinClass(this.getClass()), resourceName, null, 4, null);
    }

    public void dispose() {
    }

    private static final void handler$lambda$0(ProcessLinksExtension this$0, String it) {
        this$0.openLink(this$0.panel, it);
    }

    private static final void _init_$lambda$1(ProcessLinksExtension this$0) {
        block0: {
            BrowserPipe browserPipe = this$0.panel.getBrowserPipe();
            if (browserPipe == null) break block0;
            browserPipe.removeSubscription(openLinkEventName, this$0.handler);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/intellij/plugins/markdown/extensions/jcef/ProcessLinksExtension$Provider;", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension$Provider;", "()V", "createBrowserExtension", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension;", "panel", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;", "intellij.markdown.core"})
    public static final class Provider
    implements MarkdownBrowserPreviewExtension.Provider {
        @Override
        @NotNull
        public MarkdownBrowserPreviewExtension createBrowserExtension(@NotNull MarkdownHtmlPanel panel2) {
            return new ProcessLinksExtension(panel2);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/intellij/plugins/markdown/extensions/jcef/ProcessLinksExtension$Companion;", "", "()V", "openLinkEventName", "", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

