/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.extensions.common.highlighter;

import com.intellij.lang.Language;
import com.intellij.markdown.utils.lang.HtmlSyntaxHighlighter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.plugins.markdown.extensions.CodeFenceGeneratingProvider;
import org.intellij.plugins.markdown.extensions.common.highlighter.HtmlCacheManager;
import org.intellij.plugins.markdown.extensions.jcef.commandRunner.CommandRunnerExtension;
import org.intellij.plugins.markdown.injection.aliases.CodeFenceLanguageGuesser;
import org.intellij.plugins.markdown.ui.preview.html.DefaultCodeFenceGeneratingProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\r0\u00100\u000f2\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u0014H\u0002J \u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J&\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\tJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\rH\u0016J\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\rH\u0002J \u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0014\u0010$\u001a\u00020\u0011*\u00020\u00112\u0006\u0010%\u001a\u00020&H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/intellij/plugins/markdown/extensions/common/highlighter/MarkdownCodeFencePreviewHighlighter;", "Lorg/intellij/plugins/markdown/extensions/CodeFenceGeneratingProvider;", "()V", "cacheManager", "Lorg/intellij/plugins/markdown/extensions/common/highlighter/HtmlCacheManager;", "getCacheManager", "()Lorg/intellij/plugins/markdown/extensions/common/highlighter/HtmlCacheManager;", "currentFile", "Ljava/lang/ThreadLocal;", "Lcom/intellij/openapi/vfs/VirtualFile;", "appendWithReplacements", "", "line", "", "targets", "", "Lkotlin/Pair;", "Lkotlin/ranges/IntRange;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "generateHtml", "language", "raw", "node", "Lorg/intellij/markdown/ast/ASTNode;", "generateHtmlForFile", "file", "isApplicable", "", "processCodeLine", "rawCodeLine", "render", "lang", "Lcom/intellij/lang/Language;", "text", "shift", "value", "", "intellij.markdown.core"})
public final class MarkdownCodeFencePreviewHighlighter
implements CodeFenceGeneratingProvider {
    @NotNull
    private final ThreadLocal<VirtualFile> currentFile = new ThreadLocal();

    private final HtmlCacheManager getCacheManager() {
        return HtmlCacheManager.Companion.getInstance$default(HtmlCacheManager.Companion, null, 1, null);
    }

    @Override
    public boolean isApplicable(@NotNull String language) {
        return CodeFenceLanguageGuesser.guessLanguageForInjection(language) != null;
    }

    @NotNull
    public final String generateHtmlForFile(@NotNull String language, @NotNull String raw, @NotNull ASTNode node, @NotNull VirtualFile file) {
        this.currentFile.set(file);
        String result2 = this.generateHtml(language, raw, node);
        this.currentFile.set(null);
        return result2;
    }

    @Override
    @NotNull
    public String generateHtml(@NotNull String language, @NotNull String raw, @NotNull ASTNode node) {
        Language lang = CodeFenceLanguageGuesser.guessLanguageForInjection(language);
        if (lang == null) {
            return DefaultCodeFenceGeneratingProvider.Companion.escape$intellij_markdown_core(raw);
        }
        String cacheKey = this.getCacheManager().obtainCacheKey(raw, language);
        String cached = this.getCacheManager().obtainCachedHtml(cacheKey);
        if (cached != null) {
            return cached;
        }
        String text = this.render(lang, raw, node);
        this.getCacheManager().cacheHtml(cacheKey, text);
        return text;
    }

    /*
     * WARNING - void declaration
     */
    private final String render(Language lang, String text, ASTNode node) {
        Object object;
        CharSequence charSequence;
        CharSequence charSequence2;
        ArrayList<Object> arrayList;
        block10: {
            block9: {
                void it;
                String string;
                CharSequence charSequence3;
                CharSequence charSequence4;
                ArrayList<Object> arrayList2;
                block8: {
                    Map highlightTokens = new LinkedHashMap();
                    HtmlSyntaxHighlighter.Companion.parseContent(null, lang, text, (Function3)new Function3<String, IntRange, Color, Unit>((Map<IntRange, String>)highlightTokens){
                        final /* synthetic */ Map<IntRange, String> $highlightTokens;
                        {
                            this.$highlightTokens = $highlightTokens;
                            super(3);
                        }

                        public final void invoke(@NotNull String content2, @NotNull IntRange intRange, @Nullable Color color) {
                            if (color != null) {
                                this.$highlightTokens.put(intRange, "<span style=\"color:" + ColorUtil.toHtmlColor((Color)color) + "\">" + DefaultCodeFenceGeneratingProvider.Companion.escape$intellij_markdown_core(content2) + "</span>");
                            }
                        }
                    });
                    int baseOffset = DefaultCodeFenceGeneratingProvider.Companion.calcCodeFenceContentBaseOffset$intellij_markdown_core(node);
                    ArrayList<Object> lines2 = new ArrayList<Object>();
                    int left = 0;
                    for (String line : StringsKt.lines((CharSequence)text)) {
                        void $this$render_u24lambda_u242;
                        Object $this$mapTo$iv$iv;
                        void $this$map$iv;
                        IntRange range;
                        Map.Entry entry;
                        void $this$filterTo$iv$iv;
                        Iterable $this$filter$iv = highlightTokens.entrySet();
                        boolean $i$f$filter = false;
                        Iterable iterable = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            entry = (Map.Entry)element$iv$iv;
                            boolean bl = false;
                            range = (IntRange)entry.getKey();
                            if (!(range.getFirst() >= left && range.getLast() <= left + line.length())) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        boolean $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        Iterator iterator = $this$mapTo$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            Object item$iv$iv = iterator.next();
                            entry = (Map.Entry)item$iv$iv;
                            arrayList2 = destination$iv$iv;
                            boolean bl = false;
                            range = (IntRange)entry.getKey();
                            String replacement = (String)entry.getValue();
                            arrayList2.add(TuplesKt.to((Object)this.shift(range, -left), (Object)replacement));
                        }
                        List targets = (List)destination$iv$iv;
                        int right = left + line.length() + 1;
                        $this$mapTo$iv$iv = $i$f$map = new StringBuilder();
                        arrayList2 = lines2;
                        boolean bl = false;
                        $this$render_u24lambda_u242.append("<span " + HtmlGenerator.Companion.getSRC_ATTRIBUTE_NAME() + "='" + (left + baseOffset) + ".." + (right + baseOffset) + "'>");
                        if (!((Collection)lines2).isEmpty()) {
                            $this$render_u24lambda_u242.append(this.processCodeLine(line));
                        }
                        this.appendWithReplacements(line, targets, (StringBuilder)$this$render_u24lambda_u242);
                        $this$render_u24lambda_u242.append("</span>");
                        String string2 = ((StringBuilder)$i$f$map).toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
                        arrayList2.add(string2);
                        left = right;
                    }
                    Iterable iterable = node.getChildren();
                    charSequence4 = "<span " + HtmlGenerator.Companion.getSRC_ATTRIBUTE_NAME() + "='" + node.getStartOffset() + ".." + baseOffset + "'/>";
                    charSequence3 = "\n";
                    arrayList2 = lines2;
                    Iterable iterable2 = iterable;
                    for (Object $i$f$map : iterable2) {
                        ASTNode it2 = (ASTNode)$i$f$map;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it2.getType(), (Object)MarkdownTokenTypes.CODE_FENCE_END)) continue;
                        string = (String)$i$f$map;
                        break block8;
                    }
                    string = null;
                }
                String string3 = string;
                arrayList = arrayList2;
                charSequence2 = charSequence3;
                charSequence = charSequence4;
                object = (ASTNode)string3;
                if (object == null) break block9;
                ASTNode right = object;
                charSequence4 = charSequence;
                charSequence3 = charSequence2;
                arrayList2 = arrayList;
                boolean bl = false;
                string3 = "<span " + HtmlGenerator.Companion.getSRC_ATTRIBUTE_NAME() + "='" + it.getStartOffset() + ".." + it.getEndOffset() + "'/>";
                arrayList = arrayList2;
                charSequence2 = charSequence3;
                charSequence = charSequence4;
                String string4 = string3;
                object = string4;
                if (string4 != null) break block10;
            }
            object = "";
        }
        return CollectionsKt.joinToString$default((Iterable)arrayList, (CharSequence)charSequence2, (CharSequence)charSequence, (CharSequence)((CharSequence)object), (int)0, null, null, (int)56, null);
    }

    private final IntRange shift(IntRange $this$shift, int value) {
        return new IntRange($this$shift.getFirst() + value, $this$shift.getLast() + value);
    }

    private final void appendWithReplacements(String line, List<Pair<IntRange, String>> targets, StringBuilder builder) {
        String actualLine = line;
        int left = 0;
        Iterable $this$sortedBy$iv = targets;
        boolean $i$f$sortedBy = false;
        for (Pair pair : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(((IntRange)it.getFirst()).getFirst());
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((IntRange)it.getFirst()).getFirst()));
            }
        })) {
            IntRange range = (IntRange)pair.component1();
            String replacement = (String)pair.component2();
            String string = actualLine.substring(0, range.getFirst() - left);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            builder.append(DefaultCodeFenceGeneratingProvider.Companion.escape$intellij_markdown_core(string));
            builder.append(replacement);
            Intrinsics.checkNotNullExpressionValue((Object)actualLine.substring(range.getLast() - left), (String)"this as java.lang.String).substring(startIndex)");
            left = range.getLast();
        }
        builder.append(DefaultCodeFenceGeneratingProvider.Companion.escape$intellij_markdown_core(actualLine));
    }

    private final String processCodeLine(String rawCodeLine) {
        Object object;
        block4: {
            block3: {
                object = this.currentFile.get();
                if (object == null) break block3;
                VirtualFile file = object;
                boolean bl = false;
                CommandRunnerExtension commandRunnerExtension = CommandRunnerExtension.Companion.getRunnerByFile(file);
                String string = commandRunnerExtension != null ? commandRunnerExtension.processCodeLine(rawCodeLine, true) : null;
                object = string;
                if (string != null) break block4;
            }
            object = "";
        }
        return object;
    }
}

