/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableRow;
import org.intellij.plugins.markdown.settings.MarkdownSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J#\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0005\u001a\u00020\u0004H\u0096\u0002J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/intentions/MarkdownRemoveRowIntention;", "Lcom/intellij/codeInsight/intention/PsiElementBaseIntentionAction;", "()V", "findContentNonHeaderRow", "Lcom/intellij/psi/PsiElement;", "element", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isAvailable", "", "intellij.markdown.core"})
public final class MarkdownRemoveRowIntention
extends PsiElementBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        return MarkdownBundle.message("markdown.remove.row.intention.text", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor2, @NotNull PsiElement element2) {
        if (!MarkdownSettings.Companion.getInstance(project).isEnhancedEditingEnabled()) {
            return false;
        }
        return this.findContentNonHeaderRow(element2) != null;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull PsiElement element2) {
        PsiElement psiElement = this.findContentNonHeaderRow(element2);
        if (psiElement == null) {
            return;
        }
        PsiElement row = psiElement;
        row.delete();
    }

    private final PsiElement findContentNonHeaderRow(PsiElement element2) {
        MarkdownTableRow markdownTableRow;
        MarkdownTableRow markdownTableRow2 = TableUtils.findRow(element2);
        if (markdownTableRow2 != null) {
            MarkdownTableRow markdownTableRow3;
            MarkdownTableRow it = markdownTableRow3 = markdownTableRow2;
            boolean bl = false;
            markdownTableRow = !TableUtils.INSTANCE.isHeaderRow(it) ? markdownTableRow3 : null;
        } else {
            markdownTableRow = null;
        }
        return (PsiElement)markdownTableRow;
    }
}

