/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.editor.tables.TableModificationUtils;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableCell;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableSeparatorRow;
import org.intellij.plugins.markdown.settings.MarkdownSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J#\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096\u0002J\"\u0010\u000f\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/intentions/MarkdownInsertTableColumnIntention;", "Lcom/intellij/codeInsight/intention/PsiElementBaseIntentionAction;", "insertAfter", "", "(Z)V", "getFamilyName", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "isAvailable", "InsertAfter", "InsertBefore", "intellij.markdown.core"})
public abstract class MarkdownInsertTableColumnIntention
extends PsiElementBaseIntentionAction {
    private final boolean insertAfter;

    public MarkdownInsertTableColumnIntention(boolean insertAfter) {
        this.insertAfter = insertAfter;
    }

    @NotNull
    public String getFamilyName() {
        return MarkdownBundle.message("markdown.insert.table.column.intention.family", new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor2, @NotNull PsiElement element2) {
        if (!MarkdownSettings.Companion.getInstance(project).isEnhancedEditingEnabled()) {
            return false;
        }
        MarkdownTableCell cell = TableUtils.findCell(element2);
        if (cell == null) return false;
        if (editor2 == null) return false;
        MarkdownTable markdownTable = cell.getParentTable();
        if (markdownTable == null) return false;
        if (!TableModificationUtils.INSTANCE.hasCorrectBorders(markdownTable)) return false;
        return true;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull PsiElement element2) {
        MarkdownTable table;
        MarkdownTableCell cell;
        MarkdownTableCell markdownTableCell = cell = TableUtils.findCell(element2);
        MarkdownTable markdownTable = table = markdownTableCell != null ? markdownTableCell.getParentTable() : null;
        if (cell == null || table == null || editor2 == null) {
            return;
        }
        TableModificationUtils.insertColumn$default(TableModificationUtils.INSTANCE, table, editor2.getDocument(), cell.getColumnIndex(), this.insertAfter, MarkdownTableSeparatorRow.CellAlignment.LEFT, 0, 16, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/intentions/MarkdownInsertTableColumnIntention$InsertBefore;", "Lorg/intellij/plugins/markdown/editor/tables/intentions/MarkdownInsertTableColumnIntention;", "()V", "getText", "", "intellij.markdown.core"})
    public static final class InsertBefore
    extends MarkdownInsertTableColumnIntention {
        public InsertBefore() {
            super(false);
        }

        @NotNull
        public String getText() {
            return MarkdownBundle.message("markdown.insert.table.column.to.the.left.intention.text", new Object[0]);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/intentions/MarkdownInsertTableColumnIntention$InsertAfter;", "Lorg/intellij/plugins/markdown/editor/tables/intentions/MarkdownInsertTableColumnIntention;", "()V", "getText", "", "intellij.markdown.core"})
    public static final class InsertAfter
    extends MarkdownInsertTableColumnIntention {
        public InsertAfter() {
            super(true);
        }

        @NotNull
        public String getText() {
            return MarkdownBundle.message("markdown.insert.table.column.to.the.right.intention.text", new Object[0]);
        }
    }
}

