/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ExtensionsKt;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.editor.tables.TableFormattingUtils;
import org.intellij.plugins.markdown.editor.tables.TableModificationUtils;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.editor.tables.intentions.FixTableBordersIntention;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElementFactory;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableCell;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableRow;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableSeparatorRow;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J#\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0096\u0002J\"\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0018"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/intentions/FixTableBordersIntention;", "Lcom/intellij/codeInsight/intention/PsiElementBaseIntentionAction;", "()V", "fixRow", "", "row", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableRow;", "columnsCount", "", "fixSeparatorRow", "separatorRow", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableSeparatorRow;", "getFamilyName", "", "getText", "invoke", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "isAvailable", "", "intellij.markdown.core"})
public final class FixTableBordersIntention
extends PsiElementBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        return MarkdownBundle.message("markdown.fix.table.borders.intention.text", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor2, @NotNull PsiElement element2) {
        MarkdownTable table;
        MarkdownTable markdownTable = table = TableUtils.findTable(element2);
        return markdownTable != null ? !TableModificationUtils.INSTANCE.hasCorrectBorders(markdownTable) : false;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull PsiElement element2) {
        MarkdownTable markdownTable = TableUtils.findTable(element2);
        Intrinsics.checkNotNull((Object)markdownTable);
        MarkdownTable table = markdownTable;
        List<MarkdownTableRow> rows = table.getRows(true);
        Integer n = (Integer)SequencesKt.maxOrNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)rows), (Function1)invoke.columnsCount.1.INSTANCE));
        int columnsCount2 = n != null ? n : 0;
        for (MarkdownTableRow row : rows) {
            this.fixRow(row, columnsCount2);
        }
        MarkdownTableSeparatorRow markdownTableSeparatorRow = TableUtils.INSTANCE.getSeparatorRow(table);
        if (markdownTableSeparatorRow != null) {
            MarkdownTableSeparatorRow it = markdownTableSeparatorRow;
            boolean bl = false;
            if (!TableModificationUtils.INSTANCE.hasCorrectBorders(it)) {
                this.fixSeparatorRow(it);
            }
        }
        if (editor2 != null && !TableModificationUtils.isCorrectlyFormatted$default(TableModificationUtils.INSTANCE, table, false, 1, null)) {
            Document document = editor2.getDocument();
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
            TableFormattingUtils.INSTANCE.reformatAllColumns(table, document, true, false);
        }
    }

    private final void fixSeparatorRow(MarkdownTableSeparatorRow separatorRow) {
        StringBuilder stringBuilder;
        String currentText = separatorRow.getText();
        StringBuilder $this$fixSeparatorRow_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (!StringsKt.startsWith$default((CharSequence)currentText, (char)'|', (boolean)false, (int)2, null)) {
            $this$fixSeparatorRow_u24lambda_u241.append('|');
        }
        $this$fixSeparatorRow_u24lambda_u241.append(currentText);
        if (!StringsKt.endsWith$default((CharSequence)currentText, (char)'|', (boolean)false, (int)2, null)) {
            $this$fixSeparatorRow_u24lambda_u241.append('|');
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String newText = string;
        separatorRow.replace((PsiElement)MarkdownPsiElementFactory.createTableSeparatorRow(separatorRow.getProject(), newText));
    }

    private final void fixRow(MarkdownTableRow row, int columnsCount2) {
        Project project = row.getProject();
        PsiElement psiElement = row.getFirstChild();
        boolean bl = psiElement != null ? !PsiUtilsKt.hasType(psiElement, MarkdownTokenTypes.TABLE_SEPARATOR) : false;
        if (bl) {
            row.addBefore(MarkdownPsiElementFactory.createTableSeparator(project), row.getFirstChild());
        }
        PsiElement psiElement2 = row.getLastChild();
        boolean bl2 = psiElement2 != null ? !PsiUtilsKt.hasType(psiElement2, MarkdownTokenTypes.TABLE_SEPARATOR) : false;
        if (bl2) {
            row.addAfter(MarkdownPsiElementFactory.createTableSeparator(project), row.getLastChild());
        }
        int columnsDiff = columnsCount2 - TableUtils.INSTANCE.getColumnsCount(row);
        int n = 0;
        while (n < columnsDiff) {
            int it = n++;
            boolean bl3 = false;
            Pair<MarkdownTableCell, PsiElement> pair = MarkdownPsiElementFactory.createTableCell(project, StringsKt.repeat((CharSequence)" ", (int)5));
            MarkdownTableCell cell = (MarkdownTableCell)ExtensionsKt.component1(pair);
            PsiElement separator = (PsiElement)ExtensionsKt.component2(pair);
            row.addRange((PsiElement)cell, separator);
        }
    }
}

