/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.editor.tables.TableModificationUtils;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableCell;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableSeparatorRow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016J#\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096\u0002J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/intentions/FixCellAlignmentIntention;", "Lcom/intellij/codeInsight/intention/PsiElementBaseIntentionAction;", "()V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "isAvailable", "", "intellij.markdown.core"})
public final class FixCellAlignmentIntention
extends PsiElementBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        return MarkdownBundle.message("markdown.fix.cell.alignment.intention.text", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor2, @NotNull PsiElement element2) {
        MarkdownTableCell cell = TableUtils.findCell(element2);
        if (editor2 == null || cell == null || cell.getParentTable() == null) {
            return false;
        }
        return !TableModificationUtils.INSTANCE.hasCorrectPadding(cell) || !TableModificationUtils.INSTANCE.hasValidAlignment(cell);
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull PsiElement element2) {
        if (editor2 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        MarkdownTableCell markdownTableCell = TableUtils.findCell(element2);
        if (markdownTableCell == null) {
            return;
        }
        MarkdownTableCell cell = markdownTableCell;
        Object object = cell.getParentTable();
        if (object == null || (object = TableUtils.INSTANCE.getColumnAlignment((MarkdownTable)object, cell.getColumnIndex())) == null) {
            return;
        }
        Object expectedAlignment = object;
        TableModificationUtils.INSTANCE.updateAlignment(cell, editor2.getDocument(), (MarkdownTableSeparatorRow.CellAlignment)((Object)expectedAlignment));
    }
}

