/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import kotlin.Metadata;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.editor.tables.TableModificationUtils;
import org.intellij.plugins.markdown.editor.tables.intentions.FixCellAlignmentIntention;
import org.intellij.plugins.markdown.editor.tables.intentions.ReformatTableIntention;
import org.intellij.plugins.markdown.lang.psi.MarkdownElementVisitor;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableCell;
import org.intellij.plugins.markdown.settings.MarkdownSettings;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/inspections/MarkdownIncorrectTableFormattingInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "intellij.markdown.core"})
@ApiStatus.Internal
public final class MarkdownIncorrectTableFormattingInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!MarkdownSettings.Companion.getInstance(holder.getProject()).isEnhancedEditingEnabled()) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new MarkdownElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitTable(@NotNull MarkdownTable table) {
                super.visitTable(table);
                if (!TableModificationUtils.INSTANCE.isCorrectlyFormatted(table, false)) {
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{(LocalQuickFix)new IntentionWrapper((IntentionAction)new ReformatTableIntention())};
                    this.$holder.registerProblem((PsiElement)table, MarkdownBundle.message("markdown.incorrect.table.formatting.inspection.description", new Object[0]), localQuickFixArray);
                }
            }

            public void visitElement(@NotNull PsiElement element2) {
                super.visitElement(element2);
                MarkdownTableCell markdownTableCell = element2 instanceof MarkdownTableCell ? (MarkdownTableCell)element2 : null;
                boolean bl = markdownTableCell != null ? !TableModificationUtils.INSTANCE.hasValidAlignment(markdownTableCell) : false;
                if (bl) {
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{(LocalQuickFix)new IntentionWrapper((IntentionAction)new FixCellAlignmentIntention())};
                    this.$holder.registerProblem(element2, MarkdownBundle.message("markdown.incorrect.table.formatting.inspection.local.cell.description", new Object[0]), localQuickFixArray);
                }
            }
        };
    }
}

