/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.handlers;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.editor.tables.TableFormattingUtils;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableCell;
import org.intellij.plugins.markdown.settings.MarkdownSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J$\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/handlers/MarkdownTableReformatAfterActionHook;", "Lcom/intellij/openapi/editor/actionSystem/EditorWriteActionHandler;", "baseHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "(Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "actuallyExecute", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "executeWriteAction", "isEnabledForCaret", "", "intellij.markdown.core"})
public final class MarkdownTableReformatAfterActionHook
extends EditorWriteActionHandler {
    @Nullable
    private final EditorActionHandler baseHandler;

    public MarkdownTableReformatAfterActionHook(@Nullable EditorActionHandler baseHandler) {
        this.baseHandler = baseHandler;
    }

    protected boolean isEnabledForCaret(@NotNull Editor editor2, @NotNull Caret caret, @Nullable DataContext dataContext) {
        EditorActionHandler editorActionHandler = this.baseHandler;
        return editorActionHandler != null ? editorActionHandler.isEnabled(editor2, caret, dataContext) : false;
    }

    public void executeWriteAction(@NotNull Editor editor2, @Nullable Caret caret, @Nullable DataContext dataContext) {
        EditorActionHandler editorActionHandler = this.baseHandler;
        if (editorActionHandler != null) {
            editorActionHandler.execute(editor2, caret, dataContext);
        }
        this.actuallyExecute(editor2, caret, dataContext);
    }

    private final void actuallyExecute(Editor editor2, Caret caret, DataContext dataContext) {
        Integer columnIndex;
        MarkdownTableCell cell;
        Project project = editor2.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        if (!Registry.is((String)"markdown.tables.editing.support.enable") || !MarkdownSettings.Companion.getInstance(project2).isEnhancedEditingEnabled()) {
            return;
        }
        Document document = editor2.getDocument();
        Caret caret2 = caret;
        if (caret2 == null) {
            return;
        }
        int caretOffset = caret2.getOffset();
        if (!TableUtils.isProbablyInsideTableCell(document, caretOffset) || editor2.getCaretModel().getCaretCount() != 1) {
            return;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
        PsiFile psiFile = documentManager.getPsiFile(document);
        if (psiFile == null) {
            return;
        }
        PsiFile file = psiFile;
        if (!TableUtils.INSTANCE.isFormattingEnabledForTables$intellij_markdown_core(file)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
        MarkdownTableCell markdownTableCell = cell = TableUtils.findCell(file, caretOffset);
        MarkdownTable table = markdownTableCell != null ? markdownTableCell.getParentTable() : null;
        MarkdownTableCell markdownTableCell2 = cell;
        Integer n = columnIndex = markdownTableCell2 != null ? Integer.valueOf(markdownTableCell2.getColumnIndex()) : null;
        if (cell == null || table == null || columnIndex == null) {
            return;
        }
        CharSequence text = document.getCharsSequence();
        TextRange it = cell.getTextRange();
        boolean bl = false;
        if (StringsKt.isBlank((CharSequence)((Object)text.subSequence(it.getStartOffset(), it.getEndOffset())).toString())) {
            return;
        }
        Project project$iv = table.getProject();
        String name$iv = null;
        Object groupId$iv = null;
        boolean $i$f$executeCommand = false;
        CommandProcessor.getInstance().executeCommand(project$iv, new Runnable(table, document, editor2, columnIndex){
            final /* synthetic */ MarkdownTable $table$inlined;
            final /* synthetic */ Document $document$inlined;
            final /* synthetic */ Editor $editor$inlined;
            final /* synthetic */ Integer $columnIndex$inlined;
            {
                this.$table$inlined = markdownTable;
                this.$document$inlined = document;
                this.$editor$inlined = editor2;
                this.$columnIndex$inlined = n;
            }

            public final void run() {
                boolean bl = false;
                TableFormattingUtils.INSTANCE.reformatColumnOnChange(this.$table$inlined, this.$document$inlined, this.$editor$inlined.getCaretModel().getAllCarets(), this.$columnIndex$inlined, false, false);
            }
        }, name$iv, groupId$iv);
    }
}

