/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.handlers;

import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.editor.tables.TableFormattingUtils;
import org.intellij.plugins.markdown.editor.tables.TableModificationUtils;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.lang.MarkdownLanguageUtils;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableCell;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableSeparatorRow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/handlers/MarkdownTableBackspaceHandler;", "Lcom/intellij/codeInsight/editorActions/BackspaceHandlerDelegate;", "()V", "beforeCharDeleted", "", "c", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "charDeleted", "", "char", "updateSeparator", "document", "Lcom/intellij/openapi/editor/Document;", "separatorRange", "Lcom/intellij/openapi/util/TextRange;", "width", "", "intellij.markdown.core"})
public final class MarkdownTableBackspaceHandler
extends BackspaceHandlerDelegate {
    public void beforeCharDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor2) {
    }

    public boolean charDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor2) {
        MarkdownTableSeparatorRow markdownTableSeparatorRow;
        if (!TableUtils.INSTANCE.isFormattingEnabledForTables$intellij_markdown_core(file) || !MarkdownLanguageUtils.INSTANCE.isMarkdownType(file.getFileType())) {
            return false;
        }
        int caretOffset = editor2.getCaretModel().getCurrentCaret().getOffset();
        Document document = editor2.getDocument();
        if (!TableUtils.isProbablyInsideTableCell(document, caretOffset)) {
            return false;
        }
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
        MarkdownTable markdownTable = TableUtils.findTable(file, caretOffset);
        if (markdownTable == null) {
            return false;
        }
        MarkdownTable table = markdownTable;
        Integer n = TableUtils.findCellIndex(file, caretOffset);
        if (n == null) {
            return false;
        }
        int cellIndex = n;
        Object object = TableUtils.INSTANCE.getSeparatorRow(table);
        if (object == null || (object = object.getCellAlignment(cellIndex)) == null) {
            return false;
        }
        Object alignment = object;
        MarkdownTableCell markdownTableCell = TableUtils.findCell(file, caretOffset);
        int width = markdownTableCell != null && (markdownTableCell = markdownTableCell.getTextRange()) != null ? markdownTableCell.getLength() : ((markdownTableSeparatorRow = TableUtils.INSTANCE.getSeparatorRow(table)) != null && (markdownTableSeparatorRow = MarkdownTableSeparatorRow.getCellRange$default(markdownTableSeparatorRow, cellIndex, false, 2, null)) != null ? markdownTableSeparatorRow.getLength() : 0);
        CharSequence text = document.getCharsSequence();
        Project project$iv = table.getProject();
        String name$iv = null;
        Object groupId$iv = null;
        boolean $i$f$executeCommand = false;
        CommandProcessor.getInstance().executeCommand(project$iv, new Runnable(table, cellIndex, (MarkdownTableSeparatorRow.CellAlignment)((Object)alignment), file, document, caretOffset, c, editor2, this, width, text){
            final /* synthetic */ MarkdownTable $table$inlined;
            final /* synthetic */ int $cellIndex$inlined;
            final /* synthetic */ MarkdownTableSeparatorRow.CellAlignment $alignment$inlined;
            final /* synthetic */ PsiFile $file$inlined;
            final /* synthetic */ Document $document$inlined;
            final /* synthetic */ int $caretOffset$inlined;
            final /* synthetic */ char $char$inlined;
            final /* synthetic */ Editor $editor$inlined;
            final /* synthetic */ MarkdownTableBackspaceHandler this$0;
            final /* synthetic */ int $width$inlined;
            final /* synthetic */ CharSequence $text$inlined;
            {
                this.$table$inlined = markdownTable;
                this.$cellIndex$inlined = n;
                this.$alignment$inlined = cellAlignment;
                this.$file$inlined = psiFile;
                this.$document$inlined = document;
                this.$caretOffset$inlined = n2;
                this.$char$inlined = c;
                this.$editor$inlined = editor2;
                this.this$0 = markdownTableBackspaceHandler;
                this.$width$inlined = n3;
                this.$text$inlined = charSequence;
            }

            /*
             * Unable to fully structure code
             */
            public final void run() {
                block2: {
                    $i$a$-executeCommand$default-MarkdownTableBackspaceHandler$charDeleted$1 = false;
                    TableModificationUtils.INSTANCE.modifyColumn(this.$table$inlined, this.$cellIndex$inlined, (Function1<? super TextRange, Unit>)((Function1)new Function1<TextRange, Unit>(this.this$0, this.$document$inlined, this.$width$inlined){
                        final /* synthetic */ MarkdownTableBackspaceHandler this$0;
                        final /* synthetic */ Document $document;
                        final /* synthetic */ int $width;
                        {
                            this.this$0 = $receiver;
                            this.$document = $document;
                            this.$width = $width;
                            super(1);
                        }

                        public final void invoke(@NotNull TextRange it) {
                            MarkdownTableBackspaceHandler.access$updateSeparator(this.this$0, this.$document, it, this.$width);
                        }
                    }), (Function1<? super MarkdownTableCell, Unit>)((Function1)new Function1<MarkdownTableCell, Unit>(this.$width$inlined, this.$text$inlined, this.$document$inlined){
                        final /* synthetic */ int $width;
                        final /* synthetic */ CharSequence $text;
                        final /* synthetic */ Document $document;
                        {
                            this.$width = $width;
                            this.$text = $text;
                            this.$document = $document;
                            super(1);
                        }

                        public final void invoke(@NotNull MarkdownTableCell cell) {
                            TextRange range = cell.getTextRange();
                            if (range.getLength() > this.$width && this.$text.charAt(range.getEndOffset() - 1) == ' ' && this.$text.charAt(range.getEndOffset() - 2) == ' ') {
                                this.$document.deleteString(range.getEndOffset() - 1, range.getEndOffset());
                            }
                        }
                    }));
                    if (this.$alignment$inlined == MarkdownTableSeparatorRow.CellAlignment.NONE) break block2;
                    PsiDocumentManager.getInstance((Project)this.$file$inlined.getProject()).commitDocument(this.$document$inlined);
                    reparsedTable = TableUtils.findTable(this.$file$inlined, this.$caretOffset$inlined);
                    v0 = TableUtils.findCell(this.$file$inlined, this.$caretOffset$inlined);
                    if (v0 == null || (v0 = v0.getTextRange()) == null) ** GOTO lbl-1000
                    it = v0;
                    $i$a$-let-MarkdownTableBackspaceHandler$charDeleted$1$isBlank$1 = false;
                    v1 = this.$text$inlined.subSequence(it.getStartOffset(), it.getEndOffset()).toString();
                    v0 = v1;
                    if (v1 != null) {
                        v2 = StringsKt.isBlank((CharSequence)((CharSequence)v0));
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = true;
                    }
                    isBlank = v2;
                    shouldPreventExpand = isBlank != false && this.$char$inlined == ' ';
                    v3 = reparsedTable;
                    if (v3 == null) break block2;
                    TableFormattingUtils.INSTANCE.reformatColumnOnChange(v3, this.$document$inlined, this.$editor$inlined.getCaretModel().getAllCarets(), this.$cellIndex$inlined, false, shouldPreventExpand);
                }
            }
        }, name$iv, groupId$iv);
        return true;
    }

    private final void updateSeparator(Document document, TextRange separatorRange, int width) {
        CharSequence text = document.getCharsSequence();
        if (separatorRange.getLength() > width) {
            int n;
            int endOffset = separatorRange.getEndOffset();
            if (text.charAt(endOffset - 1) == '-') {
                n = separatorRange.getEndOffset() - 1;
            } else if (text.charAt(endOffset - 2) == '-') {
                n = separatorRange.getEndOffset() - 2;
            } else {
                return;
            }
            int offset = n;
            document.deleteString(offset, offset + 1);
        }
    }

    public static final /* synthetic */ void access$updateSeparator(MarkdownTableBackspaceHandler $this, Document document, TextRange separatorRange, int width) {
        $this.updateSeparator(document, separatorRange, width);
    }
}

