/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.actions.row;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.editor.tables.actions.TableActionKeys;
import org.intellij.plugins.markdown.lang.MarkdownLanguageUtils;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableRow;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableSeparatorRow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\"\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\"\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J6\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\n\u0018\u00010\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002JX\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\n\u0018\u00010\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102 \u0010\u0015\u001a\u001c\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001a\u001a\u00020\nH\u0002J \u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\nH$J\u0010\u0010 \u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J$\u0010 \u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00142\b\u0010\u001f\u001a\u0004\u0018\u00010\nH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/row/RowBasedTableAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "considerSeparatorRow", "", "(Z)V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "findRow", "Lcom/intellij/psi/PsiElement;", "file", "Lcom/intellij/psi/PsiFile;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "findRowOrSeparator", "findTableAndRow", "Lkotlin/Pair;", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;", "rowGetter", "Lkotlin/Function3;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "obtainParentTable", "element", "performAction", "editor", "Lcom/intellij/openapi/editor/Editor;", "table", "rowElement", "update", "intellij.markdown.core"})
public abstract class RowBasedTableAction
extends AnAction {
    private final boolean considerSeparatorRow;

    public RowBasedTableAction(boolean considerSeparatorRow) {
        this.considerSeparatorRow = considerSeparatorRow;
    }

    public /* synthetic */ RowBasedTableAction(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Editor editor2 = (Editor)event.getRequiredData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)event.getRequiredData(CommonDataKeys.PSI_FILE);
        int offset = ((Caret)event.getRequiredData(CommonDataKeys.CARET)).getOffset();
        Document document = editor2.getDocument();
        Pair<MarkdownTable, PsiElement> tableAndRow = this.findTableAndRow(event, file, document, offset);
        if (tableAndRow == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        MarkdownTable table = (MarkdownTable)tableAndRow.component1();
        PsiElement row = (PsiElement)tableAndRow.component2();
        this.performAction(editor2, table, row);
    }

    public void update(@NotNull AnActionEvent event) {
        Integer offset;
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        Editor editor2 = (Editor)event.getData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
        Caret caret = (Caret)event.getData(CommonDataKeys.CARET);
        Integer n = offset = caret != null ? Integer.valueOf(caret.getOffset()) : null;
        if (project == null || editor2 == null || file == null || offset == null || !MarkdownLanguageUtils.INSTANCE.isMarkdownLanguage(file.getLanguage())) {
            event.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Document document = editor2.getDocument();
        Pair<MarkdownTable, PsiElement> tableAndRow = this.findTableAndRow(event, file, document, offset);
        event.getPresentation().setEnabledAndVisible(tableAndRow != null);
        if (tableAndRow != null) {
            MarkdownTable table = (MarkdownTable)tableAndRow.component1();
            PsiElement row = (PsiElement)tableAndRow.component2();
            this.update(event, table, row);
        } else {
            this.update(event, null, null);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    protected abstract void performAction(@NotNull Editor var1, @NotNull MarkdownTable var2, @NotNull PsiElement var3);

    protected void update(@NotNull AnActionEvent event, @Nullable MarkdownTable table, @Nullable PsiElement rowElement) {
    }

    private final Pair<MarkdownTable, PsiElement> findTableAndRow(AnActionEvent event, PsiFile file, Document document, int offset) {
        return this.considerSeparatorRow ? this.findTableAndRow(event, file, document, offset, (Function3<? super PsiFile, ? super Document, ? super Integer, ? extends PsiElement>)((Function3)new Function3<PsiFile, Document, Integer, PsiElement>((Object)this){

            @Nullable
            public final PsiElement invoke(@NotNull PsiFile p0, @NotNull Document p1, int p2) {
                return ((RowBasedTableAction)((Object)this.receiver)).findRowOrSeparator(p0, p1, p2);
            }
        })) : this.findTableAndRow(event, file, document, offset, (Function3<? super PsiFile, ? super Document, ? super Integer, ? extends PsiElement>)((Function3)new Function3<PsiFile, Document, Integer, PsiElement>((Object)this){

            @Nullable
            public final PsiElement invoke(@NotNull PsiFile p0, @NotNull Document p1, int p2) {
                return ((RowBasedTableAction)((Object)this.receiver)).findRow(p0, p1, p2);
            }
        }));
    }

    @Nullable
    protected PsiElement findRowOrSeparator(@NotNull PsiFile file, @NotNull Document document, int offset) {
        return TableUtils.findRowOrSeparator(file, offset);
    }

    @Nullable
    protected PsiElement findRow(@NotNull PsiFile file, @NotNull Document document, int offset) {
        return (PsiElement)TableUtils.findRow(file, offset);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Pair<MarkdownTable, PsiElement> findTableAndRow(AnActionEvent event, PsiFile file, Document document, int offset, Function3<? super PsiFile, ? super Document, ? super Integer, ? extends PsiElement> rowGetter) {
        Object object;
        PsiElement row;
        PsiElement psiElement;
        MarkdownTable table;
        PsiElement elementFromEvent;
        WeakReference weakReference = (WeakReference)event.getData(TableActionKeys.INSTANCE.getELEMENT());
        Object object2 = elementFromEvent = weakReference != null ? (PsiElement)weakReference.get() : null;
        if (elementFromEvent != null && (table = this.obtainParentTable(elementFromEvent)) != null) {
            return TuplesKt.to((Object)table, (Object)elementFromEvent);
        }
        PsiElement psiElement2 = (PsiElement)rowGetter.invoke((Object)file, (Object)document, (Object)offset);
        if (psiElement2 == null) return null;
        PsiElement psiElement3 = psiElement = psiElement2;
        boolean bl = false;
        if (!psiElement3.isValid()) return null;
        PsiElement psiElement5 = psiElement;
        psiElement5 = row = psiElement5;
        Object object3 = psiElement5;
        if (psiElement5 == null) return null;
        PsiElement psiElement6 = object3;
        boolean bl2 = false;
        MarkdownTable markdownTable = this.obtainParentTable(psiElement6);
        object3 = markdownTable;
        if (markdownTable == null) return null;
        Object object4 = object = object3;
        boolean bl3 = false;
        if (!object4.isValid()) return null;
        Object object5 = object;
        Object table2 = object5;
        Object object6 = table2;
        if (object6 == null) return null;
        Pair pair = TuplesKt.to(object6, (Object)row);
        return pair;
    }

    private final MarkdownTable obtainParentTable(PsiElement element2) {
        PsiElement psiElement = element2;
        return psiElement instanceof MarkdownTableRow ? ((MarkdownTableRow)element2).getParentTable() : (psiElement instanceof MarkdownTableSeparatorRow ? ((MarkdownTableSeparatorRow)element2).getParentTable() : null);
    }

    public RowBasedTableAction() {
        this(false, 1, null);
    }
}

