/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.actions.column;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import org.intellij.plugins.markdown.editor.tables.TableModificationUtils;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.editor.tables.actions.column.ColumnBasedTableAction;
import org.intellij.plugins.markdown.lang.MarkdownLanguageUtils;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableSeparatorRow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b \u0018\u00002\u00020\u0001:\u0003\u000e\u000f\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/column/SetColumnAlignmentAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "alignment", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableSeparatorRow$CellAlignment;", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableSeparatorRow$CellAlignment;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "Center", "Left", "Right", "intellij.markdown.core"})
public abstract class SetColumnAlignmentAction
extends ToggleAction {
    @NotNull
    private final MarkdownTableSeparatorRow.CellAlignment alignment;

    public SetColumnAlignmentAction(@NotNull MarkdownTableSeparatorRow.CellAlignment alignment) {
        this.alignment = alignment;
    }

    public boolean isSelected(@NotNull AnActionEvent event) {
        Integer offset;
        Editor editor2 = (Editor)event.getData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
        Caret caret = (Caret)event.getData(CommonDataKeys.CARET);
        Integer n = offset = caret != null ? Integer.valueOf(caret.getOffset()) : null;
        if (editor2 == null || file == null || offset == null || !MarkdownLanguageUtils.INSTANCE.isMarkdownLanguage(file.getLanguage())) {
            event.getPresentation().setEnabledAndVisible(false);
            return false;
        }
        Document document = editor2.getDocument();
        Pair<MarkdownTable, Integer> pair = ColumnBasedTableAction.Companion.findTableAndIndex(event, file, document, offset);
        MarkdownTable table = (MarkdownTable)pair.component1();
        Integer columnIndex = (Integer)pair.component2();
        MarkdownTable markdownTable = table;
        event.getPresentation().setEnabledAndVisible(markdownTable != null ? TableModificationUtils.INSTANCE.hasCorrectBorders(markdownTable) : false);
        return table == null || columnIndex == null ? false : TableUtils.INSTANCE.getColumnAlignment(table, columnIndex) == this.alignment;
    }

    public void setSelected(@NotNull AnActionEvent event, boolean state) {
        Integer offset;
        Editor editor2 = (Editor)event.getData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
        Caret caret = (Caret)event.getData(CommonDataKeys.CARET);
        Integer n = offset = caret != null ? Integer.valueOf(caret.getOffset()) : null;
        if (editor2 == null || file == null || offset == null) {
            return;
        }
        Document document = editor2.getDocument();
        Pair<MarkdownTable, Integer> pair = ColumnBasedTableAction.Companion.findTableAndIndex(event, file, document, offset);
        MarkdownTable table = (MarkdownTable)pair.component1();
        Integer columnIndex = (Integer)pair.component2();
        if (table != null && columnIndex != null) {
            boolean $i$f$runWriteAction = false;
            ApplicationManager.getApplication().runWriteAction(new Computable(table, state, this, editor2, columnIndex){
                final /* synthetic */ MarkdownTable $table$inlined;
                final /* synthetic */ boolean $state$inlined;
                final /* synthetic */ SetColumnAlignmentAction this$0;
                final /* synthetic */ Editor $editor$inlined;
                final /* synthetic */ Integer $columnIndex$inlined;
                {
                    this.$table$inlined = markdownTable;
                    this.$state$inlined = bl;
                    this.this$0 = setColumnAlignmentAction;
                    this.$editor$inlined = editor2;
                    this.$columnIndex$inlined = n;
                }

                public final T compute() {
                    boolean bl = false;
                    Project project$iv = this.$table$inlined.getProject();
                    String name$iv = null;
                    Object groupId$iv = null;
                    boolean $i$f$executeCommand = false;
                    CommandProcessor.getInstance().executeCommand(project$iv, new Runnable(this.$state$inlined, this.this$0, this.$table$inlined, this.$editor$inlined, this.$columnIndex$inlined){
                        final /* synthetic */ boolean $state$inlined;
                        final /* synthetic */ SetColumnAlignmentAction this$0;
                        final /* synthetic */ MarkdownTable $table$inlined;
                        final /* synthetic */ Editor $editor$inlined;
                        final /* synthetic */ Integer $columnIndex$inlined;
                        {
                            this.$state$inlined = bl;
                            this.this$0 = setColumnAlignmentAction;
                            this.$table$inlined = markdownTable;
                            this.$editor$inlined = editor2;
                            this.$columnIndex$inlined = n;
                        }

                        public final void run() {
                            boolean bl = false;
                            MarkdownTableSeparatorRow.CellAlignment actualAlignment = this.$state$inlined ? SetColumnAlignmentAction.access$getAlignment$p(this.this$0) : MarkdownTableSeparatorRow.CellAlignment.NONE;
                            TableModificationUtils.INSTANCE.updateColumnAlignment(this.$table$inlined, this.$editor$inlined.getDocument(), this.$columnIndex$inlined, actualAlignment);
                        }
                    }, name$iv, groupId$iv);
                    return (T)Unit.INSTANCE;
                }
            });
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public static final /* synthetic */ MarkdownTableSeparatorRow.CellAlignment access$getAlignment$p(SetColumnAlignmentAction $this) {
        return $this.alignment;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/column/SetColumnAlignmentAction$Left;", "Lorg/intellij/plugins/markdown/editor/tables/actions/column/SetColumnAlignmentAction;", "()V", "intellij.markdown.core"})
    public static final class Left
    extends SetColumnAlignmentAction {
        public Left() {
            super(MarkdownTableSeparatorRow.CellAlignment.LEFT);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/column/SetColumnAlignmentAction$Center;", "Lorg/intellij/plugins/markdown/editor/tables/actions/column/SetColumnAlignmentAction;", "()V", "intellij.markdown.core"})
    public static final class Center
    extends SetColumnAlignmentAction {
        public Center() {
            super(MarkdownTableSeparatorRow.CellAlignment.CENTER);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/column/SetColumnAlignmentAction$Right;", "Lorg/intellij/plugins/markdown/editor/tables/actions/column/SetColumnAlignmentAction;", "()V", "intellij.markdown.core"})
    public static final class Right
    extends SetColumnAlignmentAction {
        public Right() {
            super(MarkdownTableSeparatorRow.CellAlignment.RIGHT);
        }
    }
}

