/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.suggested.UtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.editor.tables.TableUtils$special$;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableCell;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableRow;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableSeparatorRow;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.intellij.plugins.markdown.settings.MarkdownSettings;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u00102\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0004H\u0007J\u001f\u0010#\u001a\u0004\u0018\u00010\u00042\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010$J\u0012\u0010%\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u001a\u0010%\u001a\u0004\u0018\u00010\b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0004H\u0007J\u0012\u0010&\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u001a\u0010&\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0004H\u0007J\u0012\u0010'\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u001a\u0010'\u001a\u0004\u0018\u00010\u001a2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0004H\u0007J\u0012\u0010(\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u001a\u0010(\u001a\u0004\u0018\u00010\u00052\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0004H\u0007J\u0015\u0010)\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!H\u0000\u00a2\u0006\u0002\b*J\u0018\u0010+\u001a\u00020\u00142\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0004H\u0007J\u0012\u0010/\u001a\u000200*\u00020\u00052\u0006\u00101\u001a\u00020\u0004J\"\u00102\u001a\b\u0012\u0004\u0012\u00020\u001003*\u00020\u00052\u0006\u00104\u001a\u00020\u00042\b\b\u0002\u00105\u001a\u00020\u0014J\u0018\u00106\u001a\b\u0012\u0004\u0012\u00020703*\u00020\u00052\u0006\u00104\u001a\u00020\u0004R\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\tR\u0015\u0010\n\u001a\u00020\u000b*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0015\u0010\n\u001a\u00020\u000b*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0015\u0010\u000f\u001a\u00020\u0004*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0015\u0010\u0013\u001a\u00020\u0014*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0015\u0010\u0016\u001a\u00020\u0014*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0015R\u0015\u0010\u0017\u001a\u00020\u0004*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0012R\u0017\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00068"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/TableUtils;", "", "()V", "columnsCount", "", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;", "getColumnsCount", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;)I", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableRow;", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableRow;)I", "columnsIndices", "Lkotlin/ranges/IntRange;", "getColumnsIndices", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;)Lkotlin/ranges/IntRange;", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableRow;)Lkotlin/ranges/IntRange;", "firstNonWhitespaceOffset", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableCell;", "getFirstNonWhitespaceOffset", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableCell;)I", "isHeaderRow", "", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableRow;)Z", "isLast", "lastNonWhitespaceOffset", "getLastNonWhitespaceOffset", "separatorRow", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableSeparatorRow;", "getSeparatorRow", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;)Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableSeparatorRow;", "findCell", "element", "Lcom/intellij/psi/PsiElement;", "file", "Lcom/intellij/psi/PsiFile;", "offset", "findCellIndex", "(Lcom/intellij/psi/PsiFile;I)Ljava/lang/Integer;", "findRow", "findRowOrSeparator", "findSeparatorRow", "findTable", "isFormattingEnabledForTables", "isFormattingEnabledForTables$intellij_markdown_core", "isProbablyInsideTableCell", "document", "Lcom/intellij/openapi/editor/Document;", "caretOffset", "getColumnAlignment", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableSeparatorRow$CellAlignment;", "columnIndex", "getColumnCells", "", "index", "withHeader", "getColumnTextRanges", "Lcom/intellij/openapi/util/TextRange;", "intellij.markdown.core"})
@ApiStatus.Experimental
public final class TableUtils {
    @NotNull
    public static final TableUtils INSTANCE = new TableUtils();

    private TableUtils() {
    }

    @JvmStatic
    @Nullable
    public static final MarkdownTableCell findCell(@NotNull PsiFile file, int offset) {
        PsiElement element2 = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)offset);
        if (PsiUtilsKt.hasType(element2, MarkdownTokenTypes.TABLE_SEPARATOR) && !(element2 instanceof MarkdownTableSeparatorRow) && Intrinsics.areEqual((Object)element2.getText(), (Object)"|")) {
            PsiElement psiElement = element2.getPrevSibling();
            return psiElement instanceof MarkdownTableCell ? (MarkdownTableCell)psiElement : null;
        }
        return TableUtils.findCell(element2);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final MarkdownTableCell findCell(@NotNull PsiElement element2) {
        void $this$parentOfType$iv;
        PsiElement psiElement = element2;
        boolean withSelf$iv = true;
        boolean $i$f$parentOfType = false;
        return (MarkdownTableCell)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, MarkdownTableCell.class, (boolean)false);
    }

    @JvmStatic
    @Nullable
    public static final MarkdownTable findTable(@NotNull PsiFile file, int offset) {
        PsiElement element2 = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)offset);
        return TableUtils.findTable(element2);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final MarkdownTable findTable(@NotNull PsiElement element2) {
        void $this$parentOfType$iv;
        PsiElement psiElement = element2;
        boolean withSelf$iv = true;
        boolean $i$f$parentOfType = false;
        return (MarkdownTable)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, MarkdownTable.class, (boolean)false);
    }

    @JvmStatic
    @Nullable
    public static final MarkdownTableSeparatorRow findSeparatorRow(@NotNull PsiFile file, int offset) {
        PsiElement element2 = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)offset);
        return TableUtils.findSeparatorRow(element2);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final MarkdownTableSeparatorRow findSeparatorRow(@NotNull PsiElement element2) {
        void $this$parentOfType$iv;
        PsiElement psiElement = element2;
        boolean withSelf$iv = true;
        boolean $i$f$parentOfType = false;
        return (MarkdownTableSeparatorRow)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, MarkdownTableSeparatorRow.class, (boolean)false);
    }

    @JvmStatic
    @Nullable
    public static final MarkdownTableRow findRow(@NotNull PsiFile file, int offset) {
        PsiElement element2 = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)offset);
        return TableUtils.findRow(element2);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final MarkdownTableRow findRow(@NotNull PsiElement element2) {
        void $this$parentOfType$iv;
        PsiElement psiElement = element2;
        boolean withSelf$iv = true;
        boolean $i$f$parentOfType = false;
        return (MarkdownTableRow)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, MarkdownTableRow.class, (boolean)false);
    }

    @JvmStatic
    @Nullable
    public static final PsiElement findRowOrSeparator(@NotNull PsiFile file, int offset) {
        MarkdownTableRow row;
        MarkdownTableRow markdownTableRow = row = TableUtils.findRow(file, offset);
        return markdownTableRow != null ? (PsiElement)markdownTableRow : (PsiElement)TableUtils.findSeparatorRow(file, offset);
    }

    @JvmStatic
    @Nullable
    public static final PsiElement findRowOrSeparator(@NotNull PsiElement element2) {
        MarkdownTableRow markdownTableRow = TableUtils.findRow(element2);
        return markdownTableRow != null ? (PsiElement)markdownTableRow : (PsiElement)TableUtils.findSeparatorRow(element2);
    }

    @JvmStatic
    @Nullable
    public static final Integer findCellIndex(@NotNull PsiFile file, int offset) {
        PsiElement parent;
        Object v1;
        block2: {
            PsiElement element2 = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)offset);
            if (PsiUtilsKt.hasType(element2, MarkdownTokenTypes.TABLE_SEPARATOR) && !(element2 instanceof MarkdownTableSeparatorRow) && Intrinsics.areEqual((Object)element2.getText(), (Object)"|")) {
                PsiElement psiElement = element2.getPrevSibling();
                MarkdownTableCell markdownTableCell = psiElement instanceof MarkdownTableCell ? (MarkdownTableCell)psiElement : null;
                return markdownTableCell != null ? Integer.valueOf(markdownTableCell.getColumnIndex()) : null;
            }
            Sequence sequence = PsiTreeUtilKt.parents((PsiElement)element2, (boolean)true);
            for (Object e : sequence) {
                PsiElement it = (PsiElement)e;
                boolean bl = false;
                if (!(PsiUtilsKt.hasType(it, MarkdownElementTypes.TABLE_CELL) || it instanceof MarkdownTableSeparatorRow)) continue;
                v1 = e;
                break block2;
            }
            v1 = null;
        }
        PsiElement psiElement = parent = (PsiElement)v1;
        return psiElement instanceof MarkdownTableSeparatorRow ? ((MarkdownTableSeparatorRow)parent).getColumnIndexFromOffset(offset) : (psiElement instanceof MarkdownTableCell ? Integer.valueOf(((MarkdownTableCell)parent).getColumnIndex()) : null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<MarkdownTableCell> getColumnCells(@NotNull MarkdownTable $this$getColumnCells, int index, boolean withHeader) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = $this$getColumnCells.getRows(withHeader);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            MarkdownTableCell it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            MarkdownTableRow it = (MarkdownTableRow)element$iv$iv;
            boolean bl2 = false;
            if (it.getCell(index) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List getColumnCells$default(TableUtils tableUtils, MarkdownTable markdownTable, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        return tableUtils.getColumnCells(markdownTable, n, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TextRange> getColumnTextRanges(@NotNull MarkdownTable $this$getColumnTextRanges, int index) {
        ArrayList<TextRange> result2;
        block1: {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.getColumnCells($this$getColumnTextRanges, index, true);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                MarkdownTableCell markdownTableCell = (MarkdownTableCell)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getTextRange());
            }
            List cells = (List)destination$iv$iv;
            result2 = new ArrayList<TextRange>(cells.size() + 1);
            result2.addAll(cells);
            MarkdownTableSeparatorRow markdownTableSeparatorRow = this.getSeparatorRow($this$getColumnTextRanges);
            if (markdownTableSeparatorRow == null) break block1;
            MarkdownTableSeparatorRow it = markdownTableSeparatorRow;
            boolean bl = false;
            result2.add(it.getTextRange());
        }
        return result2;
    }

    @Nullable
    public final MarkdownTableSeparatorRow getSeparatorRow(@NotNull MarkdownTable $this$separatorRow) {
        Sequence $this$filterIsInstance$iv = PsiTreeUtilKt.siblings((PsiElement)$this$separatorRow.getFirstChild(), (boolean)true, (boolean)true);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)special$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        return (MarkdownTableSeparatorRow)SequencesKt.firstOrNull((Sequence)sequence);
    }

    public final boolean isHeaderRow(@NotNull MarkdownTableRow $this$isHeaderRow) {
        Object v0;
        block1: {
            Sequence sequence = PsiTreeUtilKt.siblings((PsiElement)((PsiElement)$this$isHeaderRow), (boolean)false, (boolean)false);
            for (Object e : sequence) {
                PsiElement it = (PsiElement)e;
                boolean bl = false;
                if (!(it instanceof MarkdownTableRow)) continue;
                v0 = e;
                break block1;
            }
            v0 = null;
        }
        return v0 == null;
    }

    public final boolean isLast(@NotNull MarkdownTableRow $this$isLast) {
        Object v0;
        block1: {
            Sequence sequence = PsiTreeUtilKt.siblings((PsiElement)((PsiElement)$this$isLast), (boolean)true, (boolean)false);
            for (Object e : sequence) {
                PsiElement it = (PsiElement)e;
                boolean bl = false;
                if (!(it instanceof MarkdownTableRow)) continue;
                v0 = e;
                break block1;
            }
            v0 = null;
        }
        return v0 == null;
    }

    public final int getColumnsCount(@NotNull MarkdownTableRow $this$columnsCount) {
        int n;
        PsiElement psiElement = $this$columnsCount.getFirstChild();
        if (psiElement != null && (psiElement = PsiTreeUtilKt.siblings((PsiElement)psiElement, (boolean)true, (boolean)true)) != null) {
            PsiElement $this$count$iv = psiElement;
            boolean $i$f$count = false;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(it instanceof MarkdownTableCell) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        } else {
            n = 0;
        }
        return n;
    }

    public final int getColumnsCount(@NotNull MarkdownTable $this$columnsCount) {
        MarkdownTableRow markdownTableRow = $this$columnsCount.getHeaderRow();
        return markdownTableRow != null ? this.getColumnsCount(markdownTableRow) : 0;
    }

    @NotNull
    public final IntRange getColumnsIndices(@NotNull MarkdownTable $this$columnsIndices) {
        return RangesKt.until((int)0, (int)this.getColumnsCount($this$columnsIndices));
    }

    @NotNull
    public final IntRange getColumnsIndices(@NotNull MarkdownTableRow $this$columnsIndices) {
        return RangesKt.until((int)0, (int)this.getColumnsCount($this$columnsIndices));
    }

    @NotNull
    public final MarkdownTableSeparatorRow.CellAlignment getColumnAlignment(@NotNull MarkdownTable $this$getColumnAlignment, int columnIndex) {
        MarkdownTableSeparatorRow markdownTableSeparatorRow = this.getSeparatorRow($this$getColumnAlignment);
        MarkdownTableSeparatorRow.CellAlignment cellAlignment = markdownTableSeparatorRow != null ? markdownTableSeparatorRow.getCellAlignment(columnIndex) : null;
        Intrinsics.checkNotNull((Object)((Object)cellAlignment));
        return cellAlignment;
    }

    /*
     * WARNING - void declaration
     */
    public final int getFirstNonWhitespaceOffset(@NotNull MarkdownTableCell $this$firstNonWhitespaceOffset) {
        int n;
        int n2;
        block1: {
            void $this$indexOfFirst$iv;
            CharSequence charSequence = $this$firstNonWhitespaceOffset.getText();
            n2 = UtilsKt.getStartOffset((PsiElement)((PsiElement)$this$firstNonWhitespaceOffset));
            boolean $i$f$indexOfFirst = false;
            int n3 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n3; ++index$iv) {
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl = false;
                if (!(it != ' ')) continue;
                n = index$iv;
                break block1;
            }
            n = -1;
        }
        int n4 = n;
        return n2 + RangesKt.coerceAtLeast((int)n4, (int)0);
    }

    /*
     * WARNING - void declaration
     */
    public final int getLastNonWhitespaceOffset(@NotNull MarkdownTableCell $this$lastNonWhitespaceOffset) {
        int n;
        int n2;
        block2: {
            void $this$indexOfLast$iv;
            CharSequence charSequence = $this$lastNonWhitespaceOffset.getText();
            n2 = UtilsKt.getStartOffset((PsiElement)((PsiElement)$this$lastNonWhitespaceOffset));
            boolean $i$f$indexOfLast = false;
            int n3 = $this$indexOfLast$iv.length() + -1;
            if (0 <= n3) {
                do {
                    int index$iv = n3--;
                    char it = $this$indexOfLast$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!(it != ' ')) continue;
                    n = index$iv;
                    break block2;
                } while (0 <= n3);
            }
            n = -1;
        }
        int n4 = n;
        return n2 + RangesKt.coerceAtLeast((int)n4, (int)0);
    }

    @JvmStatic
    public static final boolean isProbablyInsideTableCell(@NotNull Document document, int caretOffset) {
        if (caretOffset == 0) {
            return false;
        }
        CharSequence text = document.getCharsSequence();
        int lineNumber = document.getLineNumber(caretOffset);
        int lineStartOffset = document.getLineStartOffset(lineNumber);
        int lineEndOffset = document.getLineEndOffset(lineNumber);
        boolean leftBarFound = false;
        int offset = caretOffset - 1;
        if (lineStartOffset <= offset) {
            while (true) {
                if (text.charAt(offset) == '|') {
                    leftBarFound = true;
                    break;
                }
                if (offset == lineStartOffset) break;
                --offset;
            }
        }
        for (offset = caretOffset; offset < lineEndOffset; ++offset) {
            if (text.charAt(offset) != '|') continue;
            return leftBarFound;
        }
        return false;
    }

    public final boolean isFormattingEnabledForTables$intellij_markdown_core(@NotNull PsiFile file) {
        return Registry.is((String)"markdown.tables.editing.support.enable") && MarkdownSettings.Companion.getInstance(file.getProject()).isEnhancedEditingEnabled() && !CodeStyle.getSettings((PsiFile)file).getExcludedFiles().contains(file);
    }
}

