/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.suggested.UtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.apache.commons.lang.StringUtils;
import org.intellij.plugins.markdown.editor.tables.TableFormattingUtils;
import org.intellij.plugins.markdown.editor.tables.TableModificationUtils;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableCell;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableSeparatorRow;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001.B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J6\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J#\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u001aJ8\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0014H\u0002J0\u0010#\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u0014H\u0002J*\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\"\u001a\u00020\u0014J\"\u0010\u0003\u001a\u00020\u0004*\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0012\u0010*\u001a\u00020\u0014*\u00020)2\u0006\u0010+\u001a\u00020,J:\u0010-\u001a\u00020\u001c*\u00020)2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010&\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\"\u001a\u00020\u0014\u00a8\u0006/"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/TableFormattingUtils;", "", "()V", "buildCellState", "Lorg/intellij/plugins/markdown/editor/tables/TableFormattingUtils$CellContentState;", "range", "Lcom/intellij/openapi/util/TextRange;", "document", "Lcom/intellij/openapi/editor/Document;", "carets", "", "Lcom/intellij/openapi/editor/Caret;", "calculateContentsMaxWidth", "", "cells", "", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableCell;", "cellsContentsWithCarets", "separatorCellRange", "trimToMaxContent", "", "calculateNewCaretsPositions", "", "content", "", "cellRange", "(Ljava/lang/String;Lcom/intellij/openapi/util/TextRange;)[Ljava/lang/Integer;", "processCell", "", "cell", "state", "maxCellWidth", "alignment", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableSeparatorRow$CellAlignment;", "preventExpand", "processSeparator", "separatorRow", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableSeparatorRow;", "columnIndex", "reformatAllColumns", "table", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;", "isSoftWrapping", "editor", "Lcom/intellij/openapi/editor/Editor;", "reformatColumnOnChange", "CellContentState", "intellij.markdown.core"})
@ApiStatus.Internal
public final class TableFormattingUtils {
    @NotNull
    public static final TableFormattingUtils INSTANCE = new TableFormattingUtils();

    private TableFormattingUtils() {
    }

    /*
     * WARNING - void declaration
     */
    private final CellContentState buildCellState(TextRange range, Document document, Iterable<? extends Caret> carets) {
        StringBuilder stringBuilder;
        boolean bl;
        List caretsOffsets;
        String content2;
        Caret[] caretsInside;
        block8: {
            Iterator $this$mapTo$iv$iv;
            void $this$toTypedArray$iv;
            Collection $this$sortedBy$iv;
            int n;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = carets;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo22 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Caret it = (Caret)element$iv$iv;
                n = 0;
                if (!range.containsOffset(it.getOffset())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Caret it = (Caret)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getOffset());
                    it = (Caret)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getOffset()));
                }
            });
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            caretsInside = thisCollection$iv.toArray(new Caret[0]);
            content2 = ((Object)document.getCharsSequence().subSequence(range.getStartOffset(), range.getEndOffset())).toString();
            if (caretsInside.length == 0) {
                return new CellContentState(content2, null, 2, null);
            }
            Caret[] $this$map$iv = caretsInside;
            boolean $i$f$map = false;
            Caret[] $i$f$filterTo22 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            n = ((void)$this$mapTo$iv$iv).length;
            for (int it = 0; it < n; ++it) {
                void it2;
                void item$iv$iv;
                void var15_24 = item$iv$iv = $this$mapTo$iv$iv[it];
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(it2.getOffset() - range.getStartOffset());
            }
            caretsOffsets = (List)destination$iv$iv2;
            Iterable $this$all$iv = caretsOffsets;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl3 = false;
                    if (it <= content2.length()) continue;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
        }
        if (!bl) {
            boolean bl4 = false;
            String string = "Content indices: " + StringsKt.getIndices((CharSequence)content2) + "; Carets offsets: " + caretsOffsets;
            throw new IllegalStateException(string.toString());
        }
        StringBuilder $this$buildCellState_u24lambda_u245 = stringBuilder = new StringBuilder();
        boolean bl5 = false;
        int previousOffset = 0;
        Iterator iterator = caretsOffsets.iterator();
        while (iterator.hasNext()) {
            int caretOffset = ((Number)iterator.next()).intValue();
            String string = content2.substring(previousOffset, caretOffset);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            $this$buildCellState_u24lambda_u245.append(string);
            $this$buildCellState_u24lambda_u245.append('\n');
            previousOffset = caretOffset;
        }
        String string = content2.substring(previousOffset, content2.length());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        $this$buildCellState_u24lambda_u245.append(string);
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        String contentWithReplacements = string2;
        return new CellContentState(contentWithReplacements, caretsInside);
    }

    private final CellContentState buildCellState(MarkdownTableCell $this$buildCellState, Document document, Iterable<? extends Caret> carets) {
        return this.buildCellState($this$buildCellState.getTextRange(), document, carets);
    }

    private final int calculateContentsMaxWidth(Collection<? extends MarkdownTableCell> cells, Iterable<CellContentState> cellsContentsWithCarets, TextRange separatorCellRange, boolean trimToMaxContent) {
        Integer contentCellsWidth2;
        Integer n;
        if (trimToMaxContent) {
            Object object;
            var7_5 = SequencesKt.map((Sequence)CollectionsKt.asSequence(cellsContentsWithCarets), (Function1)calculateContentsMaxWidth.contentCellsWidth.1.INSTANCE).iterator();
            if (!var7_5.hasNext()) {
                object = null;
            } else {
                it = (String)var7_5.next();
                boolean bl = false;
                it = ((String)it).length() + 2;
                while (var7_5.hasNext()) {
                    Object it = (String)var7_5.next();
                    $i$a$-maxOfOrNull-TableFormattingUtils$calculateContentsMaxWidth$contentCellsWidth$2 = false;
                    if (it.compareTo(it = (Comparable)Integer.valueOf(((String)it).length() + 2)) >= 0) continue;
                    it = it;
                }
                object = it;
            }
            n = (Integer)object;
        } else {
            Comparable comparable;
            var7_5 = ((Iterable)cells).iterator();
            if (!var7_5.hasNext()) {
                comparable = null;
            } else {
                it = (MarkdownTableCell)var7_5.next();
                boolean bl = false;
                Comparable comparable2 = Integer.valueOf(it.getTextRange().getLength());
                while (var7_5.hasNext()) {
                    MarkdownTableCell it = (MarkdownTableCell)var7_5.next();
                    $i$a$-maxOfOrNull-TableFormattingUtils$calculateContentsMaxWidth$contentCellsWidth$3 = false;
                    Comparable comparable3 = Integer.valueOf(it.getTextRange().getLength());
                    if (comparable2.compareTo(comparable3) >= 0) continue;
                    comparable2 = comparable3;
                }
                comparable = comparable2;
            }
            n = (Integer)comparable;
        }
        if ((contentCellsWidth2 = n) == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        TextRange textRange = separatorCellRange;
        return Integer.max(Integer.max(contentCellsWidth2, textRange != null ? textRange.getLength() : -1), 5);
    }

    /*
     * WARNING - void declaration
     */
    private final Integer[] calculateNewCaretsPositions(String content2, TextRange cellRange) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        int it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = (Iterable)StringsKt.getIndices((CharSequence)content2);
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (!(content2.charAt(it) == '\n')) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it + cellRange.getStartOffset());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Integer[] positions = thisCollection$iv.toArray(new Integer[0]);
        int n = positions.length;
        for (int index = 0; index < n; ++index) {
            int n2 = index;
            positions[n2] = positions[n2] - index;
        }
        return positions;
    }

    private final void processCell(Document document, MarkdownTableCell cell, CellContentState state, int maxCellWidth, MarkdownTableSeparatorRow.CellAlignment alignment, boolean preventExpand) {
        String expectedContent = TableModificationUtils.INSTANCE.buildRealignedCellContent(state.getTrimmedContentWithCarets(), maxCellWidth + state.getCaretsInside().length, alignment);
        TextRange range = cell.getTextRange();
        String cellContent = ((Object)document.getCharsSequence().subSequence(range.getStartOffset(), range.getEndOffset())).toString();
        if (preventExpand && cellContent.length() < maxCellWidth) {
            return;
        }
        String expectedContentWithoutCarets = StringsKt.replace$default((String)expectedContent, (String)"\n", (String)"", (boolean)false, (int)4, null);
        if (!Intrinsics.areEqual((Object)cellContent, (Object)expectedContentWithoutCarets)) {
            document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)expectedContentWithoutCarets);
            Object[] caretsPositions = this.calculateNewCaretsPositions(expectedContent, range);
            if (!(caretsPositions.length == state.getCaretsInside().length)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            for (Pair pair : SequencesKt.zip((Sequence)ArraysKt.asSequence((Object[])state.getCaretsInside()), (Sequence)ArraysKt.asSequence((Object[])caretsPositions))) {
                Caret caret = (Caret)pair.component1();
                int position = ((Number)pair.component2()).intValue();
                caret.moveToOffset(position);
            }
        }
    }

    private final void processSeparator(Document document, MarkdownTableSeparatorRow separatorRow, int columnIndex, int maxCellWidth, boolean preventExpand) {
        TextRange textRange = MarkdownTableSeparatorRow.getCellRange$default(separatorRow, columnIndex, false, 2, null);
        Intrinsics.checkNotNull((Object)textRange);
        TextRange range = textRange;
        String content2 = ((Object)document.getCharsSequence().subSequence(range.getStartOffset(), range.getEndOffset())).toString();
        if (preventExpand && content2.length() < maxCellWidth) {
            return;
        }
        MarkdownTableSeparatorRow.CellAlignment alignment = separatorRow.getCellAlignment(columnIndex);
        String expectedContent = TableModificationUtils.INSTANCE.buildSeparatorCellContent(alignment, maxCellWidth);
        if (!Intrinsics.areEqual((Object)content2, (Object)expectedContent)) {
            document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)expectedContent);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void reformatColumnOnChange(@NotNull MarkdownTable $this$reformatColumnOnChange, @NotNull Document document, @NotNull Iterable<? extends Caret> carets, int columnIndex, boolean trimToMaxContent, boolean preventExpand) {
        boolean bl;
        boolean bl2;
        Collection collection;
        Iterable iterable;
        MarkdownTableSeparatorRow separatorRow;
        List cellsStates;
        Object object;
        Collection destination$iv$iv;
        List cells;
        block6: {
            String $this$mapTo$iv$iv;
            cells = CollectionsKt.asReversed(TableUtils.INSTANCE.getColumnCells($this$reformatColumnOnChange, columnIndex, true));
            Iterable $this$map$iv = cells;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo22 = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv = iterator.next();
                MarkdownTableCell markdownTableCell = (MarkdownTableCell)item$iv$iv;
                object = destination$iv$iv;
                boolean bl3 = false;
                object.add(INSTANCE.buildCellState((MarkdownTableCell)it, document, carets));
            }
            cellsStates = (List)destination$iv$iv;
            MarkdownTableSeparatorRow markdownTableSeparatorRow = TableUtils.INSTANCE.getSeparatorRow($this$reformatColumnOnChange);
            if (markdownTableSeparatorRow == null) {
                $this$mapTo$iv$iv = "Required value was null.";
                throw new IllegalStateException($this$mapTo$iv$iv.toString());
            }
            separatorRow = markdownTableSeparatorRow;
            TextRange textRange = MarkdownTableSeparatorRow.getCellRange$default(separatorRow, columnIndex, false, 2, null);
            Intrinsics.checkNotNull((Object)textRange);
            TextRange separatorCellRange = textRange;
            Collection $i$f$mapTo22 = destination$iv$iv = separatorCellRange;
            iterable = cellsStates;
            collection = cells;
            object = this;
            boolean bl4 = false;
            Iterable<? extends Caret> $this$any$iv = carets;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                Iterator<? extends Caret> bl3 = $this$any$iv.iterator();
                while (bl3.hasNext()) {
                    Caret element$iv;
                    Caret it = element$iv = bl3.next();
                    boolean bl5 = false;
                    if (!separatorCellRange.containsOffset(it.getOffset())) continue;
                    bl2 = true;
                    break block6;
                }
                bl2 = false;
            }
        }
        int maxCellWidth = super.calculateContentsMaxWidth(collection, iterable, (TextRange)((bl = bl2) ? destination$iv$iv : null), trimToMaxContent);
        MarkdownTableSeparatorRow.CellAlignment alignment = TableUtils.INSTANCE.getColumnAlignment($this$reformatColumnOnChange, columnIndex);
        Sequence contentCells2 = SequencesKt.takeWhile((Sequence)SequencesKt.zip((Sequence)CollectionsKt.asSequence((Iterable)cells), (Sequence)CollectionsKt.asSequence((Iterable)cellsStates)), (Function1)reformatColumnOnChange.contentCells.1.INSTANCE);
        for (Pair pair : contentCells2) {
            MarkdownTableCell cell = (MarkdownTableCell)pair.component1();
            CellContentState state = (CellContentState)pair.component2();
            this.processCell(document, cell, state, maxCellWidth, alignment, preventExpand);
        }
        this.processSeparator(document, separatorRow, columnIndex, maxCellWidth, preventExpand);
        this.processCell(document, (MarkdownTableCell)CollectionsKt.last((List)cells), (CellContentState)CollectionsKt.last((List)cellsStates), maxCellWidth, alignment, preventExpand);
    }

    public static /* synthetic */ void reformatColumnOnChange$default(TableFormattingUtils tableFormattingUtils, MarkdownTable markdownTable, Document document, Iterable iterable, int n, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            bl2 = false;
        }
        tableFormattingUtils.reformatColumnOnChange(markdownTable, document, iterable, n, bl, bl2);
    }

    public final void reformatAllColumns(@NotNull MarkdownTable table, @NotNull Document document, boolean trimToMaxContent, boolean preventExpand) {
        int n;
        IntRange columnsIndices = TableUtils.INSTANCE.getColumnsIndices(table);
        int tableOffset = UtilsKt.getStartOffset((PsiElement)((PsiElement)table));
        int columnIndex = columnsIndices.getFirst();
        if (columnIndex <= (n = columnsIndices.getLast())) {
            while (true) {
                MarkdownTable currentTable;
                PsiDocumentManager.getInstance((Project)table.getProject()).commitDocument(document);
                if (TableUtils.findTable(table.getContainingFile(), tableOffset) == null) break;
                IntRange intRange = TableUtils.INSTANCE.getColumnsIndices(currentTable);
                int n2 = intRange.getFirst();
                boolean bl = columnIndex <= intRange.getLast() ? n2 <= columnIndex : false;
                if (!bl) break;
                this.reformatColumnOnChange(currentTable, document, CollectionsKt.emptyList(), columnIndex, trimToMaxContent, preventExpand);
                if (columnIndex == n) break;
                ++columnIndex;
            }
        }
    }

    public static /* synthetic */ void reformatAllColumns$default(TableFormattingUtils tableFormattingUtils, MarkdownTable markdownTable, Document document, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        tableFormattingUtils.reformatAllColumns(markdownTable, document, bl, bl2);
    }

    public final boolean isSoftWrapping(@NotNull MarkdownTable $this$isSoftWrapping, @NotNull Editor editor2) {
        TextRange range = $this$isSoftWrapping.getTextRange();
        return !((Collection)editor2.getSoftWrapModel().getSoftWrapsForRange(range.getStartOffset(), range.getEndOffset())).isEmpty();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\r\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u000e\u0010\fR\u001b\u0010\u0011\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0010\u001a\u0004\b\u0012\u0010\f\u00a8\u0006\u0014"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/TableFormattingUtils$CellContentState;", "", "contentWithCarets", "", "caretsInside", "", "Lcom/intellij/openapi/editor/Caret;", "(Ljava/lang/String;[Lcom/intellij/openapi/editor/Caret;)V", "getCaretsInside", "()[Lcom/intellij/openapi/editor/Caret;", "[Lcom/intellij/openapi/editor/Caret;", "getContentWithCarets", "()Ljava/lang/String;", "trimmedContentWithCarets", "getTrimmedContentWithCarets", "trimmedContentWithCarets$delegate", "Lkotlin/Lazy;", "trimmedContentWithoutCarets", "getTrimmedContentWithoutCarets", "trimmedContentWithoutCarets$delegate", "intellij.markdown.core"})
    private static final class CellContentState {
        @NotNull
        private final String contentWithCarets;
        @NotNull
        private final Caret[] caretsInside;
        @NotNull
        private final Lazy trimmedContentWithCarets$delegate;
        @NotNull
        private final Lazy trimmedContentWithoutCarets$delegate;

        public CellContentState(@NotNull String contentWithCarets, @NotNull Caret[] caretsInside) {
            this.contentWithCarets = contentWithCarets;
            this.caretsInside = caretsInside;
            this.trimmedContentWithCarets$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ CellContentState this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    char[] cArray = new char[]{' '};
                    return StringsKt.trim((String)this.this$0.getContentWithCarets(), (char[])cArray);
                }
            }));
            this.trimmedContentWithoutCarets$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ CellContentState this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final String invoke() {
                    return StringUtils.remove((String)this.this$0.getTrimmedContentWithCarets(), (char)'\n');
                }
            }));
        }

        public /* synthetic */ CellContentState(String string, Caret[] caretArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                boolean $i$f$emptyArray = false;
                caretArray = new Caret[]{};
            }
            this(string, caretArray);
        }

        @NotNull
        public final String getContentWithCarets() {
            return this.contentWithCarets;
        }

        @NotNull
        public final Caret[] getCaretsInside() {
            return this.caretsInside;
        }

        @NotNull
        public final String getTrimmedContentWithCarets() {
            Lazy lazy = this.trimmedContentWithCarets$delegate;
            return (String)lazy.getValue();
        }

        @NotNull
        public final String getTrimmedContentWithoutCarets() {
            Lazy lazy = this.trimmedContentWithoutCarets$delegate;
            return (String)lazy.getValue();
        }
    }
}

