/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.lists;

import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.suggested.UtilsKt;
import com.intellij.util.DocumentUtil;
import com.intellij.util.text.CharArrayUtil;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.editor.lists.ListRenumberUtils;
import org.intellij.plugins.markdown.editor.lists.ListUtils;
import org.intellij.plugins.markdown.editor.lists.MarkdownListMarkerBackspaceHandlerDelegate$charDeleted$;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCompositePsiElementBase;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownList;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItem;
import org.intellij.plugins.markdown.settings.MarkdownSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/intellij/plugins/markdown/editor/lists/MarkdownListMarkerBackspaceHandlerDelegate;", "Lcom/intellij/codeInsight/editorActions/BackspaceHandlerDelegate;", "()V", "item", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItem;", "beforeCharDeleted", "", "c", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "charDeleted", "", "listWillBeSplitToTwoLists", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.markdown.core"})
public final class MarkdownListMarkerBackspaceHandlerDelegate
extends BackspaceHandlerDelegate {
    @Nullable
    private MarkdownListItem item;

    public void beforeCharDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor2) {
        int nonWsStartOffset;
        this.item = null;
        int deletedOffset = editor2.getCaretModel().getOffset() - 1;
        if (!(file instanceof MarkdownFile) || deletedOffset < 0 || !MarkdownSettings.Companion.getInstance(((MarkdownFile)file).getProject()).isEnhancedEditingEnabled()) {
            return;
        }
        PsiDocumentManager.getInstance((Project)((MarkdownFile)file).getProject()).commitDocument(editor2.getDocument());
        PsiElement psiElement = file.findElementAt(deletedOffset);
        if (psiElement == null) {
            return;
        }
        PsiElement marker2 = psiElement;
        if (MarkdownTokenTypeSets.LIST_MARKERS.contains(PsiTreeUtilKt.getElementType((PsiElement)marker2)) && (nonWsStartOffset = CharArrayUtil.shiftForward((CharSequence)editor2.getDocument().getCharsSequence(), (int)UtilsKt.getStartOffset((PsiElement)marker2), (String)" \t")) <= deletedOffset) {
            PsiElement $this$parentOfType_u24default$iv = marker2;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            this.item = (MarkdownListItem)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, MarkdownListItem.class, (boolean)true);
        }
    }

    public boolean charDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor2) {
        block4: {
            Integer n;
            MarkdownListItem markdownListItem = this.item;
            if (markdownListItem == null) {
                return false;
            }
            MarkdownListItem item = markdownListItem;
            Document document = editor2.getDocument();
            boolean createsNewList = this.listWillBeSplitToTwoLists(item, document);
            PsiElement $this$descendantsOfType_u24default$iv = (PsiElement)ListUtils.INSTANCE.getList(item);
            boolean childrenFirst$iv = false;
            boolean $i$f$descendantsOfType = false;
            Sequence $this$filterIsInstance$iv$iv = PsiTreeUtilKt.descendants$default((PsiElement)$this$descendantsOfType_u24default$iv, (boolean)childrenFirst$iv, null, (int)2, null);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv$iv, (Function1)charDeleted$$inlined$descendantsOfType$default$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            MarkdownListItem markdownListItem2 = (MarkdownListItem)SequencesKt.firstOrNull((Sequence)SequencesKt.drop((Sequence)SequencesKt.dropWhile((Sequence)sequence, (Function1)((Function1)new Function1<MarkdownListItem, Boolean>(item){
                final /* synthetic */ MarkdownListItem $item;
                {
                    this.$item = $item;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull MarkdownListItem it) {
                    return !Intrinsics.areEqual((Object)it, (Object)this.$item);
                }
            })), (int)1));
            if (markdownListItem2 != null) {
                MarkdownListItem it = markdownListItem2;
                boolean bl = false;
                n = document.getLineNumber(UtilsKt.getStartOffset((PsiElement)((PsiElement)it)));
            } else {
                n = null;
            }
            Integer nextItemFirstLine2 = n;
            PsiElement psiElement = item.getMarkerElement();
            Intrinsics.checkNotNull((Object)psiElement);
            TextRange range = psiElement.getTextRange();
            boolean $i$f$runWriteAction = false;
            ApplicationManager.getApplication().runWriteAction(new Computable(document, range){
                final /* synthetic */ Document $document$inlined;
                final /* synthetic */ TextRange $range$inlined;
                {
                    this.$document$inlined = document;
                    this.$range$inlined = textRange;
                }

                public final T compute() {
                    boolean bl = false;
                    this.$document$inlined.deleteString(this.$range$inlined.getStartOffset(), this.$range$inlined.getEndOffset() - 1);
                    return (T)Unit.INSTANCE;
                }
            });
            if (nextItemFirstLine2 == null || createsNewList || !Registry.is((String)"markdown.lists.renumber.on.type.enable")) break block4;
            PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
            Intrinsics.checkNotNull((Object)file, (String)"null cannot be cast to non-null type org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile");
            MarkdownListItem updatedItem = ListUtils.INSTANCE.getListItemAtLine((MarkdownFile)file, nextItemFirstLine2, document);
            MarkdownCompositePsiElementBase markdownCompositePsiElementBase = updatedItem;
            if (markdownCompositePsiElementBase != null && (markdownCompositePsiElementBase = ListUtils.INSTANCE.getList((MarkdownListItem)markdownCompositePsiElementBase)) != null) {
                ListRenumberUtils.renumberInBulk$default(ListRenumberUtils.INSTANCE, (MarkdownList)markdownCompositePsiElementBase, document, false, false, false, 8, null);
            }
        }
        return true;
    }

    private final boolean listWillBeSplitToTwoLists(MarkdownListItem item, Document document) {
        int itemFirstLine = document.getLineNumber(UtilsKt.getStartOffset((PsiElement)((PsiElement)item)));
        int itemLastLine = document.getLineNumber(Math.min(UtilsKt.getEndOffset((PsiElement)((PsiElement)item)) - 1, document.getTextLength()));
        boolean emptyLineBefore = itemFirstLine > 0 && DocumentUtil.isLineEmpty((Document)document, (int)(itemFirstLine - 1));
        boolean emptyLineAfter = itemLastLine + 1 < document.getLineCount() && DocumentUtil.isLineEmpty((Document)document, (int)(itemFirstLine + 1));
        boolean nearEmptyLine = emptyLineBefore || emptyLineAfter;
        CharSequence charSequence = document.getText();
        PsiElement psiElement = item.getMarkerElement();
        Intrinsics.checkNotNull((Object)psiElement);
        boolean onlyMarkerLine = CharArrayUtil.shiftForward((CharSequence)charSequence, (int)(UtilsKt.getEndOffset((PsiElement)psiElement) - 1), (String)" \t") == document.getLineEndOffset(itemFirstLine);
        PsiElement $this$parentsOfType_u24default$iv = (PsiElement)item;
        boolean withSelf$iv = true;
        boolean $i$f$parentsOfType = false;
        boolean hasPreviousItem = !Intrinsics.areEqual((Object)CollectionsKt.first(ListUtils.INSTANCE.getItems((MarkdownList)SequencesKt.last((Sequence)PsiTreeUtilKt.parentsOfType((PsiElement)$this$parentsOfType_u24default$iv, MarkdownList.class, (boolean)withSelf$iv)))), (Object)item);
        return hasPreviousItem && nearEmptyLine && onlyMarkerLine;
    }
}

