/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import org.intellij.plugins.markdown.editor.CodeFenceLanguageListCompletionProvider;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.jetbrains.annotations.NotNull;

public class MarkdownTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result checkAutoPopup(char charTyped, @NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file) {
        if (!(file instanceof MarkdownFile)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (charTyped == '`') {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor2.getDocument());
            for (Caret caret : editor2.getCaretModel().getAllCarets()) {
                int offset = caret.getOffset();
                if (CodeFenceLanguageListCompletionProvider.isInMiddleOfUnCollapsedFence(file.findElementAt(offset), offset)) continue;
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor2, null);
            return TypedHandlerDelegate.Result.STOP;
        }
        if (charTyped == '<') {
            AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor2, null);
            return TypedHandlerDelegate.Result.STOP;
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }
}

