/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.trace;

import io.opencensus.internal.Utils;
import io.opencensus.trace.BigendianEncoding;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TraceId
implements Comparable<TraceId> {
    public static final int SIZE = 16;
    private static final int BASE16_SIZE = 32;
    private static final long INVALID_ID = 0L;
    public static final TraceId INVALID = new TraceId(0L, 0L);
    private final long idHi;
    private final long idLo;

    private TraceId(long idHi, long idLo) {
        this.idHi = idHi;
        this.idLo = idLo;
    }

    public static TraceId fromBytes(byte[] src) {
        Utils.checkNotNull(src, "src");
        Utils.checkArgument(src.length == 16, "Invalid size: expected %s, got %s", 16, src.length);
        return TraceId.fromBytes(src, 0);
    }

    public static TraceId fromBytes(byte[] src, int srcOffset) {
        Utils.checkNotNull(src, "src");
        return new TraceId(BigendianEncoding.longFromByteArray(src, srcOffset), BigendianEncoding.longFromByteArray(src, srcOffset + 8));
    }

    public static TraceId fromLowerBase16(CharSequence src) {
        Utils.checkNotNull(src, "src");
        Utils.checkArgument(src.length() == 32, "Invalid size: expected %s, got %s", 32, src.length());
        return TraceId.fromLowerBase16(src, 0);
    }

    public static TraceId fromLowerBase16(CharSequence src, int srcOffset) {
        Utils.checkNotNull(src, "src");
        return new TraceId(BigendianEncoding.longFromBase16String(src, srcOffset), BigendianEncoding.longFromBase16String(src, srcOffset + 16));
    }

    public static TraceId generateRandomId(Random random) {
        long idLo;
        long idHi;
        do {
            idHi = random.nextLong();
            idLo = random.nextLong();
        } while (idHi == 0L && idLo == 0L);
        return new TraceId(idHi, idLo);
    }

    public byte[] getBytes() {
        byte[] bytes = new byte[16];
        BigendianEncoding.longToByteArray(this.idHi, bytes, 0);
        BigendianEncoding.longToByteArray(this.idLo, bytes, 8);
        return bytes;
    }

    public void copyBytesTo(byte[] dest, int destOffset) {
        BigendianEncoding.longToByteArray(this.idHi, dest, destOffset);
        BigendianEncoding.longToByteArray(this.idLo, dest, destOffset + 8);
    }

    public void copyLowerBase16To(char[] dest, int destOffset) {
        BigendianEncoding.longToBase16String(this.idHi, dest, destOffset);
        BigendianEncoding.longToBase16String(this.idLo, dest, destOffset + 16);
    }

    public boolean isValid() {
        return this.idHi != 0L || this.idLo != 0L;
    }

    public String toLowerBase16() {
        char[] chars = new char[32];
        this.copyLowerBase16To(chars, 0);
        return new String(chars);
    }

    public long getLowerLong() {
        return this.idHi < 0L ? -this.idHi : this.idHi;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TraceId)) {
            return false;
        }
        TraceId that = (TraceId)obj;
        return this.idHi == that.idHi && this.idLo == that.idLo;
    }

    public int hashCode() {
        int result2 = 1;
        result2 = 31 * result2 + (int)(this.idHi ^ this.idHi >>> 32);
        result2 = 31 * result2 + (int)(this.idLo ^ this.idLo >>> 32);
        return result2;
    }

    public String toString() {
        return "TraceId{traceId=" + this.toLowerBase16() + "}";
    }

    @Override
    public int compareTo(TraceId that) {
        if (this.idHi == that.idHi) {
            if (this.idLo == that.idLo) {
                return 0;
            }
            return this.idLo < that.idLo ? -1 : 1;
        }
        return this.idHi < that.idHi ? -1 : 1;
    }
}

