/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.resources;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import git4idea.repo.GitRepository;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;

public class RepositoryRemotePanel {
    private JPanel remotePanel;
    private JTextField remoteNameField;
    private GitRepository gitRepository;
    private static final String CLOUD_SOURCE_REPO_REMOTE_PREFIX = "cloud-platform-";

    public RepositoryRemotePanel(@Nullable GitRepository gitRepository) {
        this.gitRepository = gitRepository;
        this.$$$setupUI$$$();
        this.disableRemoteNameField();
    }

    public void update(String cloudRepository) {
        if (!StringUtil.isEmpty((String)cloudRepository)) {
            this.remoteNameField.setEnabled(true);
            this.remoteNameField.setText(this.getRemoteNameSuggestion(cloudRepository));
        } else {
            this.disableRemoteNameField();
        }
    }

    public JTextField getRemoteNameField() {
        return this.remoteNameField;
    }

    public String getText() {
        return this.remoteNameField.getText();
    }

    private void disableRemoteNameField() {
        this.remoteNameField.setEnabled(false);
        this.remoteNameField.setText("origin");
    }

    private String getRemoteNameSuggestion(String cloudRepository) {
        if (this.gitRepository != null && this.hasOriginRemote()) {
            return CLOUD_SOURCE_REPO_REMOTE_PREFIX + cloudRepository;
        }
        return "origin";
    }

    private boolean hasOriginRemote() {
        return this.gitRepository.getRemotes().stream().anyMatch(remote -> "origin".equals(remote.getName()));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JPanel jPanel;
        this.remotePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.remoteNameField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.remotePanel;
    }
}

