/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.git;

import com.google.api.client.repackaged.com.google.common.base.Strings;
import com.google.gct.idea.git.GcpHttpAuthDataProvider;
import com.google.gct.idea.resources.ProjectSelector;
import com.google.gct.idea.resources.RepositorySelector;
import com.google.gct.idea.util.GctBundle;
import com.google.gct.login.CredentialedUser;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloneCloudRepositoryDialog
extends DialogWrapper {
    private static final String INVALID_FILENAME_CHARS = "[/\\\\?%*:|\"<>]";
    private JPanel rootPanel;
    private ProjectSelector projectSelector;
    private TextFieldWithBrowseButton parentDirectory;
    private JTextField directoryName;
    private JLabel parentDirectoryLabel;
    private RepositorySelector repositorySelector;
    private JLabel directoryNameLabel;
    @NotNull
    private String defaultDirectoryName = "";
    @NotNull
    private final Project project;

    public CloneCloudRepositoryDialog(@NotNull Project project) {
        super(project, true);
        this.project = project;
        this.$$$setupUI$$$();
        this.parentDirectoryLabel.setText(DvcsBundle.message((String)"clone.parent.dir", (Object[])new Object[0]));
        this.init();
        this.initComponents();
        this.setTitle(GctBundle.message("clonefromgcp.title", new Object[0]));
        this.setOKButtonText(GctBundle.message("clonefromgcp.button", new Object[0]));
    }

    @Nullable
    public String getSourceRepositoryUrl() {
        return this.getCurrentUrlText();
    }

    @Nullable
    public String getParentDirectory() {
        return this.parentDirectory.getText();
    }

    @Nullable
    public String getDirectoryName() {
        return this.directoryName.getText();
    }

    @Nullable
    public String getGcpUserName() {
        CredentialedUser selectedUser = this.projectSelector.getSelectedUser();
        return selectedUser != null ? selectedUser.getEmail() : null;
    }

    private void initComponents() {
        FileChooserDescriptor fcd = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        fcd.setShowFileSystemRoots(true);
        fcd.setTitle(GctBundle.message("clonefromgcp.destination.directory.title", new Object[0]));
        fcd.setDescription(GctBundle.message("clonefromgcp.destination.directory.description", new Object[0]));
        fcd.setHideIgnored(false);
        this.parentDirectory.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>(fcd.getTitle(), fcd.getDescription(), (ComponentWithBrowseButton)this.parentDirectory, this.project, fcd, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT){

            protected VirtualFile getInitialFile() {
                VirtualFile file;
                String text = this.getComponentText();
                if (text.isEmpty() && (file = CloneCloudRepositoryDialog.this.project.getBaseDir()) != null) {
                    return file;
                }
                return super.getInitialFile();
            }
        });
        DocumentAdapter updateOkButtonListener = new DocumentAdapter(){

            protected void textChanged(DocumentEvent event) {
                CloneCloudRepositoryDialog.this.updateButtons();
            }
        };
        ((JTextField)this.parentDirectory.getChildComponent()).getDocument().addDocumentListener((DocumentListener)updateOkButtonListener);
        this.parentDirectory.setText(ProjectUtil.getBaseDir());
        this.directoryName.getDocument().addDocumentListener((DocumentListener)updateOkButtonListener);
        this.setOKActionEnabled(false);
    }

    protected String getDimensionServiceKey() {
        return "GCPCloneDialog";
    }

    protected String getHelpId() {
        return "reference.VersionControl.Git.CloneRepository";
    }

    private void updateButtons() {
        if (!StringUtil.isEmpty((String)this.projectSelector.getText()) && this.projectSelector.getSelectedUser() == null) {
            this.setErrorText(GctBundle.message("cloud.repository.dialog.invalid.project", new Object[0]));
            this.setOKActionEnabled(false);
            return;
        }
        if (!StringUtil.isEmpty((String)this.repositorySelector.getText()) && StringUtil.isEmpty((String)this.repositorySelector.getSelectedRepository())) {
            this.setErrorText(GctBundle.message("cloud.repository.dialog.invalid.repository", new Object[0]));
            this.setOKActionEnabled(false);
            return;
        }
        if (this.projectSelector.getSelectedUser() == null || StringUtil.isEmpty((String)this.repositorySelector.getSelectedRepository())) {
            this.setErrorText(null);
            this.setOKActionEnabled(false);
            return;
        }
        if (StringUtil.isEmpty((String)this.parentDirectory.getText()) || StringUtil.isEmpty((String)this.directoryName.getText())) {
            this.setErrorText(null);
            this.setOKActionEnabled(false);
            return;
        }
        File file = new File(this.parentDirectory.getText(), this.directoryName.getText());
        if (file.exists()) {
            this.setErrorText(GctBundle.message("clonefromgcp.destination.exists.error", new Object[0]));
            this.setOKActionEnabled(false);
            this.paintDirectorySelectionError();
            return;
        }
        if (!file.getParentFile().exists()) {
            this.setErrorText(GctBundle.message("clonefromgcp.parent.missing.error", new Object[0]));
            this.setOKActionEnabled(false);
            this.paintParentDirectorySelectionError();
            return;
        }
        this.paintSelectionOk();
        this.setErrorText(null);
        this.setOKActionEnabled(true);
    }

    @Nullable
    private String getCurrentUrlText() {
        CredentialedUser selectedUser = this.projectSelector.getSelectedUser();
        if (selectedUser == null || StringUtil.isEmpty((String)this.projectSelector.getText()) || StringUtil.isEmpty((String)this.repositorySelector.getText())) {
            return null;
        }
        return GcpHttpAuthDataProvider.getGcpUrl(this.projectSelector.getText(), this.repositorySelector.getText());
    }

    private void createUIComponents() {
        this.projectSelector = new ProjectSelector();
        this.projectSelector.setMinimumSize(new Dimension(300, 0));
        this.projectSelector.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent event) {
                if (CloneCloudRepositoryDialog.this.defaultDirectoryName.equals(CloneCloudRepositoryDialog.this.directoryName.getText()) || CloneCloudRepositoryDialog.this.directoryName.getText().isEmpty()) {
                    String projectDescription = CloneCloudRepositoryDialog.this.projectSelector.getProjectDescription();
                    if (!Strings.isNullOrEmpty((String)projectDescription)) {
                        CloneCloudRepositoryDialog.this.defaultDirectoryName = projectDescription.replaceAll(CloneCloudRepositoryDialog.INVALID_FILENAME_CHARS, "");
                        CloneCloudRepositoryDialog.this.defaultDirectoryName = CloneCloudRepositoryDialog.this.defaultDirectoryName.replaceAll("\\s", "");
                    } else {
                        CloneCloudRepositoryDialog.this.defaultDirectoryName = "";
                    }
                    CloneCloudRepositoryDialog.this.directoryName.setText(CloneCloudRepositoryDialog.this.defaultDirectoryName);
                }
                CloneCloudRepositoryDialog.this.repositorySelector.setCloudProject(CloneCloudRepositoryDialog.this.projectSelector.getText());
                CloneCloudRepositoryDialog.this.repositorySelector.setUser(CloneCloudRepositoryDialog.this.projectSelector.getSelectedUser());
                CloneCloudRepositoryDialog.this.repositorySelector.setText("");
                CloneCloudRepositoryDialog.this.repositorySelector.loadRepositories();
                CloneCloudRepositoryDialog.this.updateButtons();
            }
        });
        this.repositorySelector = new RepositorySelector(this.projectSelector.getText(), this.projectSelector.getSelectedUser(), false);
        this.repositorySelector.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent event) {
                CloneCloudRepositoryDialog.this.updateButtons();
            }
        });
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.projectSelector;
    }

    protected JComponent createCenterPanel() {
        return this.rootPanel;
    }

    private void paintSelectionOk() {
        this.parentDirectoryLabel.setForeground(Color.BLACK);
        this.directoryNameLabel.setForeground(Color.BLACK);
    }

    private void paintParentDirectorySelectionError() {
        this.paintSelectionOk();
        this.parentDirectoryLabel.setForeground(Color.RED);
    }

    private void paintDirectorySelectionError() {
        this.paintSelectionOk();
        this.directoryNameLabel.setForeground(Color.RED);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JLabel jLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel2;
        JPanel jPanel;
        this.createUIComponents();
        this.rootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/CloudToolsBundle").getString("cloud.repository.dialog.project.label"));
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(4, 1, 1, 3, 0, 1, 6, 1, null, null, null));
        this.parentDirectoryLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/CloudToolsBundle").getString("cloud.repository.clone.parent.dir.name"));
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.parentDirectory = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 3, 0, 1, 6, 0, null, null, null));
        this.directoryNameLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/CloudToolsBundle").getString("cloud.repository.clone.dir.name"));
        jPanel.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.directoryName = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(3, 1, 1, 3, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        ProjectSelector projectSelector = this.projectSelector;
        jPanel.add((Component)projectSelector, new GridConstraints(0, 1, 1, 3, 0, 3, 2, 2, new Dimension(200, -1), null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/CloudToolsBundle").getString("cloud.repository.dialog.repository.label"));
        jPanel.add((Component)jLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        RepositorySelector repositorySelector = this.repositorySelector;
        jPanel.add((Component)repositorySelector, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        jLabel.setLabelFor(jTextField);
        jLabel4.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.rootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

