/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.appengine.admin;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.services.appengine.v1.Appengine;
import com.google.api.services.appengine.v1.model.Application;
import com.google.api.services.appengine.v1.model.ListLocationsResponse;
import com.google.api.services.appengine.v1.model.Location;
import com.google.api.services.appengine.v1.model.Operation;
import com.google.api.services.appengine.v1.model.Status;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gct.idea.appengine.admin.AppEngineAdminService;
import com.google.gct.idea.appengine.admin.GoogleApiException;
import com.google.gct.idea.util.GoogleApiClientFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoogleApiClientAppEngineAdminService
extends AppEngineAdminService {
    private static final String APP_ENGINE_RESOURCE_WILDCARD = "-";
    private static final long CREATE_APPLICATION_POLLING_INTERVAL_MS = 1000L;
    private static final int APPLICATION_CACHE_MAX_SIZE = 10000;
    private static final int LOCATION_CACHE_MAX_SIZE = 10000;
    private static final String ALL_LOCATIONS_KEY = "ALL_LOCATIONS";
    private final Cache<String, Application> appEngineApplicationCache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(1L, TimeUnit.DAYS).build();
    private final Cache<String, List<Location>> appEngineLocationCache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(1L, TimeUnit.DAYS).build();

    @Override
    @Nullable
    public Application getApplicationForProjectId(@NotNull String projectId, @NotNull Credential credential) throws IOException, GoogleApiException {
        try {
            return (Application)this.appEngineApplicationCache.get((Object)projectId, () -> this.fetchApplicationForProjectId(projectId, credential));
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof AppEngineApplicationNotFoundException) {
                return null;
            }
            this.handleExecutionException(e);
            throw new RuntimeException(e);
        }
    }

    @NotNull
    @VisibleForTesting
    Application fetchApplicationForProjectId(@NotNull String projectId, @NotNull Credential credential) throws IOException, GoogleApiException, AppEngineApplicationNotFoundException {
        try {
            return (Application)GoogleApiClientFactory.getInstance().getAppEngineApiClient((HttpRequestInitializer)credential).apps().get(projectId).execute();
        }
        catch (GoogleJsonResponseException e) {
            if (e.getStatusCode() == 404) {
                throw new AppEngineApplicationNotFoundException();
            }
            throw GoogleApiException.from(e);
        }
    }

    @Override
    public Application createApplication(@NotNull String locationId, @NotNull String projectId, @NotNull Credential credential) throws IOException, GoogleApiException {
        Operation operation;
        Application arg = new Application();
        arg.setId(projectId);
        arg.setLocationId(locationId);
        Appengine.Apps.Create createRequest = GoogleApiClientFactory.getInstance().getAppEngineApiClient((HttpRequestInitializer)credential).apps().create(arg);
        try {
            operation = (Operation)createRequest.execute();
            boolean done = false;
            while (!done) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                if ((operation = this.getOperation(projectId, operation.getName(), credential)).getDone() == null) continue;
                done = operation.getDone();
            }
        }
        catch (GoogleJsonResponseException e) {
            throw GoogleApiException.from(e);
        }
        if (operation.getError() != null) {
            Status status = operation.getError();
            throw new GoogleApiException(status.getMessage(), status.getCode());
        }
        Application result = new Application();
        result.putAll(operation.getResponse());
        return result;
    }

    private Operation getOperation(@NotNull String projectId, @NotNull String operationName, @NotNull Credential credential) throws IOException {
        String[] nameParts = operationName.split("/");
        if (nameParts.length < 1) {
            throw new IllegalArgumentException("Operation name " + operationName + " is malformatted");
        }
        String id = nameParts[nameParts.length - 1];
        return (Operation)GoogleApiClientFactory.getInstance().getAppEngineApiClient((HttpRequestInitializer)credential).apps().operations().get(projectId, id).execute();
    }

    @Override
    @NotNull
    public List<Location> getAllAppEngineLocations(Credential credential) throws IOException, GoogleApiException {
        try {
            return (List)this.appEngineLocationCache.get((Object)ALL_LOCATIONS_KEY, () -> this.fetchAllAppEngineLocations(credential));
        }
        catch (ExecutionException e) {
            this.handleExecutionException(e);
            throw new RuntimeException(e);
        }
    }

    private List<Location> fetchAllAppEngineLocations(Credential credential) throws GoogleApiException, IOException {
        try {
            ListLocationsResponse response = this.fetchAppEngineLocationPage(credential, null);
            ArrayList<Location> locations = new ArrayList<Location>(response.getLocations());
            while (response.getNextPageToken() != null) {
                response = this.fetchAppEngineLocationPage(credential, response.getNextPageToken());
                locations.addAll(response.getLocations());
            }
            return locations;
        }
        catch (GoogleJsonResponseException e) {
            throw GoogleApiException.from(e);
        }
    }

    private void handleExecutionException(ExecutionException e) throws GoogleApiException, IOException {
        Throwable cause = e.getCause();
        if (cause instanceof GoogleApiException) {
            throw (GoogleApiException)cause;
        }
        if (cause instanceof IOException) {
            throw (IOException)cause;
        }
    }

    private ListLocationsResponse fetchAppEngineLocationPage(Credential credential, @Nullable String pageToken) throws IOException {
        return (ListLocationsResponse)GoogleApiClientFactory.getInstance().getAppEngineApiClient((HttpRequestInitializer)credential).apps().locations().list(APP_ENGINE_RESOURCE_WILDCARD).setPageToken(pageToken).execute();
    }

    @VisibleForTesting
    static class AppEngineApplicationNotFoundException
    extends Exception {
        AppEngineApplicationNotFoundException() {
        }
    }
}

