/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.ui.impl;

import com.intellij.debugger.streams.ui.PaintingListener;
import com.intellij.debugger.streams.ui.ValuesPositionsListener;
import com.intellij.debugger.streams.ui.impl.CollectionTree;
import com.intellij.debugger.streams.ui.impl.CollectionView;
import com.intellij.debugger.streams.ui.impl.ValueWithPositionImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.EventDispatcher;
import java.awt.Rectangle;
import java.util.EventListener;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ\b\u0010\u000e\u001a\u00020\fH\u0002J\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J,\u0010\u0012\u001a\u00020\u0010*\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0010H\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/debugger/streams/ui/impl/PositionsAwareCollectionView;", "Lcom/intellij/debugger/streams/ui/impl/CollectionView;", "tree", "Lcom/intellij/debugger/streams/ui/impl/CollectionTree;", "values", "", "Lcom/intellij/debugger/streams/ui/impl/ValueWithPositionImpl;", "(Lcom/intellij/debugger/streams/ui/impl/CollectionTree;Ljava/util/List;)V", "myDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/debugger/streams/ui/ValuesPositionsListener;", "addValuesPositionsListener", "", "listener", "updateValues", "invalidate", "", "modified", "set", "pos", "", "visible", "highlighted", "intellij.java.debugger.streams"})
public class PositionsAwareCollectionView
extends CollectionView {
    @NotNull
    private final List<ValueWithPositionImpl> values;
    @NotNull
    private final EventDispatcher<ValuesPositionsListener> myDispatcher;

    public PositionsAwareCollectionView(@NotNull CollectionTree tree, @NotNull List<ValueWithPositionImpl> values) {
        super(tree);
        this.values = values;
        this.myDispatcher = EventDispatcher.create(ValuesPositionsListener.class);
        this.getInstancesTree().addPaintingListener(new PaintingListener(){

            @Override
            public void componentPainted() {
                this.updateValues();
            }
        });
    }

    public final void addValuesPositionsListener(@NotNull ValuesPositionsListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    private final void updateValues() {
        boolean changed = false;
        Rectangle visibleRect = this.getInstancesTree().getVisibleRect();
        for (ValueWithPositionImpl value : this.values) {
            Rectangle rect = this.getInstancesTree().getRectByValue(value.getTraceElement());
            changed = rect == null ? this.invalidate(value, changed) : this.set(value, changed, rect.y + rect.height / 2 - visibleRect.y, visibleRect.intersects(rect), this.getInstancesTree().isHighlighted(value.getTraceElement()));
        }
        if (changed) {
            ApplicationManager.getApplication().invokeLater(() -> PositionsAwareCollectionView.updateValues$lambda$0(this));
        }
    }

    private final boolean invalidate(ValueWithPositionImpl $this$invalidate, boolean modified) {
        boolean bl;
        boolean bl2 = modified;
        if (bl2) {
            $this$invalidate.setInvalid();
            bl = true;
        } else if (!bl2) {
            bl = $this$invalidate.updateToInvalid();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    private final boolean set(ValueWithPositionImpl $this$set, boolean modified, int pos, boolean visible, boolean highlighted) {
        boolean bl;
        boolean bl2 = modified;
        if (bl2) {
            $this$set.setProperties(pos, visible, highlighted);
            bl = true;
        } else if (!bl2) {
            bl = $this$set.updateProperties(pos, visible, highlighted);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    private static final void updateValues$lambda$0(PositionsAwareCollectionView this$0) {
        ((ValuesPositionsListener)this$0.myDispatcher.getMulticaster()).valuesPositionsChanged();
    }
}

