/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.trace.impl.interpret;

import com.intellij.debugger.streams.trace.CallTraceInterpreter;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.TraceInfo;
import com.intellij.debugger.streams.trace.impl.interpret.SimplePeekCallTraceInterpreter;
import com.intellij.debugger.streams.trace.impl.interpret.ValuesOrderInfo;
import com.intellij.debugger.streams.trace.impl.interpret.ex.UnexpectedArrayLengthException;
import com.intellij.debugger.streams.trace.impl.interpret.ex.UnexpectedValueException;
import com.intellij.debugger.streams.trace.impl.interpret.ex.UnexpectedValueTypeException;
import com.intellij.debugger.streams.wrapper.StreamCall;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DistinctCallTraceInterpreter
implements CallTraceInterpreter {
    private final CallTraceInterpreter myPeekResolver = new SimplePeekCallTraceInterpreter();

    @Override
    @NotNull
    public TraceInfo resolve(@NotNull StreamCall call2, @NotNull Value value) {
        if (value instanceof ArrayReference) {
            Value peekTrace = ((ArrayReference)value).getValue(0);
            Value trace = ((ArrayReference)value).getValue(1);
            TraceInfo order = this.myPeekResolver.resolve(call2, peekTrace);
            Map<TraceElement, List<TraceElement>> direct = DistinctCallTraceInterpreter.resolve(trace, order, Direction.DIRECT);
            Map<TraceElement, List<TraceElement>> reverse = DistinctCallTraceInterpreter.resolve(trace, order, Direction.REVERSE);
            return new MyDistinctInfo(order, direct, reverse);
        }
        throw new UnexpectedValueException("distinct trace must be an array value");
    }

    @NotNull
    private static Map<TraceElement, List<TraceElement>> resolve(@NotNull Value value, @NotNull TraceInfo order, @NotNull Direction direction) {
        if (value instanceof ArrayReference) {
            ArrayReference convertedMap = (ArrayReference)value;
            Value keys = convertedMap.getValue(0);
            Value values = convertedMap.getValue(1);
            if (keys instanceof ArrayReference && values instanceof ArrayReference) {
                ArrayReference keysArray = (ArrayReference)keys;
                ArrayReference valuesArray = (ArrayReference)values;
                return Direction.DIRECT.equals((Object)direction) ? DistinctCallTraceInterpreter.resolveDirectTrace(keysArray, valuesArray, order) : DistinctCallTraceInterpreter.resolveReverseTrace(keysArray, valuesArray, order);
            }
            throw new UnexpectedValueException("keys and values arrays must be arrays");
        }
        throw new UnexpectedValueException("value must be an array reference");
    }

    @NotNull
    private static Map<TraceElement, List<TraceElement>> resolveDirectTrace(@NotNull ArrayReference keys, @NotNull ArrayReference values, @NotNull TraceInfo order) {
        int size = keys.length();
        if (size != values.length()) {
            throw new UnexpectedArrayLengthException("length of keys array should be same with values array");
        }
        HashMap<TraceElement, List<TraceElement>> result = new HashMap<TraceElement, List<TraceElement>>();
        Map<Integer, TraceElement> before = order.getValuesOrderBefore();
        Map<Integer, TraceElement> after = order.getValuesOrderAfter();
        for (int i = 0; i < size; ++i) {
            int fromTime = DistinctCallTraceInterpreter.extractIntValue(keys.getValue(i));
            int afterTime = DistinctCallTraceInterpreter.extractIntValue(values.getValue(i));
            result.put(before.get(fromTime), Collections.singletonList(after.get(afterTime)));
        }
        return result;
    }

    @NotNull
    private static Map<TraceElement, List<TraceElement>> resolveReverseTrace(@NotNull ArrayReference keys, @NotNull ArrayReference values, @NotNull TraceInfo order) {
        int size = keys.length();
        if (size != values.length()) {
            throw new UnexpectedArrayLengthException("length of keys array should be same with values array");
        }
        HashMap<TraceElement, List<TraceElement>> result = new HashMap<TraceElement, List<TraceElement>>();
        Map<Integer, TraceElement> before = order.getValuesOrderBefore();
        Map<Integer, TraceElement> after = order.getValuesOrderAfter();
        for (int i = 0; i < size; ++i) {
            int fromTime = DistinctCallTraceInterpreter.extractIntValue(keys.getValue(i));
            int afterTime = DistinctCallTraceInterpreter.extractIntValue(values.getValue(i));
            TraceElement beforeElement = before.get(fromTime);
            TraceElement afterElement = after.get(afterTime);
            result.computeIfAbsent(afterElement, x -> new ArrayList()).add(beforeElement);
        }
        return result;
    }

    private static int extractIntValue(@NotNull Value value) {
        if (value instanceof IntegerValue) {
            return ((IntegerValue)value).value();
        }
        throw new UnexpectedValueTypeException("value should be IntegerValue, but actual is " + value.type().name());
    }

    private static enum Direction {
        DIRECT,
        REVERSE;

    }

    private static final class MyDistinctInfo
    extends ValuesOrderInfo {
        private final Map<TraceElement, List<TraceElement>> myDirectTrace;
        private final Map<TraceElement, List<TraceElement>> myReverseTrace;

        private MyDistinctInfo(@NotNull TraceInfo info, @NotNull Map<TraceElement, List<TraceElement>> directTrace, @NotNull Map<TraceElement, List<TraceElement>> reverseTrace) {
            super(info.getCall(), info.getValuesOrderBefore(), info.getValuesOrderAfter());
            this.myDirectTrace = directTrace;
            this.myReverseTrace = reverseTrace;
        }

        @Override
        @Nullable
        public Map<TraceElement, List<TraceElement>> getDirectTrace() {
            return Collections.unmodifiableMap(this.myDirectTrace);
        }

        @Override
        @Nullable
        public Map<TraceElement, List<TraceElement>> getReverseTrace() {
            return Collections.unmodifiableMap(this.myReverseTrace);
        }
    }
}

