/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.resolve;

import com.intellij.debugger.streams.resolve.ValuesOrderResolver;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.TraceInfo;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MapResolver
implements ValuesOrderResolver {
    @Override
    @NotNull
    public ValuesOrderResolver.Result resolve(@NotNull TraceInfo info) {
        Map<Integer, TraceElement> before = info.getValuesOrderBefore();
        Map<Integer, TraceElement> after = info.getValuesOrderAfter();
        Iterator<TraceElement> leftIterator = before.values().iterator();
        Iterator<TraceElement> rightIterator = after.values().iterator();
        LinkedHashMap<TraceElement, List<TraceElement>> forward = new LinkedHashMap<TraceElement, List<TraceElement>>();
        LinkedHashMap<TraceElement, List<TraceElement>> backward = new LinkedHashMap<TraceElement, List<TraceElement>>();
        while (leftIterator.hasNext() && rightIterator.hasNext()) {
            TraceElement left = leftIterator.next();
            TraceElement right = rightIterator.next();
            forward.put(left, Collections.singletonList(right));
            backward.put(right, Collections.singletonList(left));
        }
        while (leftIterator.hasNext()) {
            forward.put(leftIterator.next(), Collections.emptyList());
        }
        return ValuesOrderResolver.Result.of(forward, backward);
    }
}

