/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.psi.impl;

import com.intellij.debugger.streams.psi.ChainDetector;
import com.intellij.debugger.streams.psi.ChainTransformer;
import com.intellij.debugger.streams.psi.PsiUtil;
import com.intellij.debugger.streams.wrapper.StreamChain;
import com.intellij.debugger.streams.wrapper.StreamChainBuilder;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifiableCodeBlock;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaStreamChainBuilder
implements StreamChainBuilder {
    private final ChainTransformer.Java myChainTransformer;
    private final ChainDetector myDetector;

    public JavaStreamChainBuilder(@NotNull ChainTransformer.Java transformer, @NotNull ChainDetector detector) {
        this.myChainTransformer = transformer;
        this.myDetector = detector;
    }

    @Override
    public boolean isChainExists(@NotNull PsiElement startElement) {
        PsiElement current = JavaStreamChainBuilder.getLatestElementInCurrentScope(PsiUtil.ignoreWhiteSpaces(startElement));
        MyStreamChainExistenceChecker existenceChecker = new MyStreamChainExistenceChecker();
        while (current != null) {
            current.accept((PsiElementVisitor)existenceChecker);
            if (existenceChecker.found()) {
                return true;
            }
            current = JavaStreamChainBuilder.toUpperLevel(current);
        }
        return false;
    }

    @Override
    @NotNull
    public List<StreamChain> build(@NotNull PsiElement startElement) {
        MyChainCollectorVisitor visitor2 = new MyChainCollectorVisitor();
        PsiElement current = JavaStreamChainBuilder.getLatestElementInCurrentScope(PsiUtil.ignoreWhiteSpaces(startElement));
        while (current != null) {
            current.accept((PsiElementVisitor)visitor2);
            current = JavaStreamChainBuilder.toUpperLevel(current);
        }
        List<List<PsiMethodCallExpression>> chains = visitor2.getPsiChains();
        return this.buildChains(chains, startElement);
    }

    @Nullable
    private static PsiElement toUpperLevel(@NotNull PsiElement element) {
        for (element = element.getParent(); element != null && !(element instanceof PsiLambdaExpression) && !(element instanceof PsiAnonymousClass); element = element.getParent()) {
        }
        return JavaStreamChainBuilder.getLatestElementInCurrentScope(element);
    }

    @Nullable
    @Contract(value="null -> null")
    private static PsiElement getLatestElementInCurrentScope(@Nullable PsiElement element) {
        PsiElement parent;
        PsiElement current = element;
        while (!(current == null || (parent = current.getParent()) instanceof PsiModifiableCodeBlock || parent instanceof PsiLambdaExpression || parent instanceof PsiStatement)) {
            current = parent;
        }
        return current;
    }

    @NotNull
    private List<StreamChain> buildChains(@NotNull List<List<PsiMethodCallExpression>> chains, @NotNull PsiElement context) {
        return ContainerUtil.map(chains, x -> this.myChainTransformer.transform(x, context));
    }

    private class MyStreamChainExistenceChecker
    extends MyVisitorBase {
        private boolean myFound = false;

        private MyStreamChainExistenceChecker() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (this.myFound) {
                return;
            }
            super.visitMethodCallExpression(expression);
            if (!this.myFound && JavaStreamChainBuilder.this.myDetector.isTerminationCall(expression)) {
                this.myFound = true;
            }
        }

        boolean found() {
            return this.myFound;
        }
    }

    private class MyChainCollectorVisitor
    extends MyVisitorBase {
        private final Set<PsiMethodCallExpression> myTerminationCalls = new HashSet<PsiMethodCallExpression>();
        private final Map<PsiMethodCallExpression, PsiMethodCallExpression> myPreviousCalls = new HashMap<PsiMethodCallExpression, PsiMethodCallExpression>();

        private MyChainCollectorVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            if (!this.myPreviousCalls.containsKey(expression) && JavaStreamChainBuilder.this.myDetector.isStreamCall(expression)) {
                this.updateCallTree(expression);
            }
        }

        private void updateCallTree(@NotNull PsiMethodCallExpression expression) {
            PsiElement parent;
            if (JavaStreamChainBuilder.this.myDetector.isTerminationCall(expression)) {
                this.myTerminationCalls.add(expression);
            }
            if (!((parent = expression.getParent()) instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement parentCall = parent.getParent();
            if (parentCall instanceof PsiMethodCallExpression && JavaStreamChainBuilder.this.myDetector.isStreamCall((PsiMethodCallExpression)parentCall)) {
                PsiMethodCallExpression parentCallExpression = (PsiMethodCallExpression)parentCall;
                this.myPreviousCalls.put(parentCallExpression, expression);
                this.updateCallTree(parentCallExpression);
            }
        }

        @NotNull
        List<List<PsiMethodCallExpression>> getPsiChains() {
            ArrayList<List<PsiMethodCallExpression>> chains = new ArrayList<List<PsiMethodCallExpression>>();
            for (PsiMethodCallExpression terminationCall : this.myTerminationCalls) {
                ArrayList<PsiMethodCallExpression> chain = new ArrayList<PsiMethodCallExpression>();
                PsiMethodCallExpression current = terminationCall;
                while (current != null && (JavaStreamChainBuilder.this.myDetector.isIntermediateCall(current) || JavaStreamChainBuilder.this.myDetector.isTerminationCall(current))) {
                    chain.add(current);
                    current = this.myPreviousCalls.get(current);
                }
                Collections.reverse(chain);
                chains.add(chain);
            }
            return chains;
        }
    }

    private static class MyVisitorBase
    extends JavaRecursiveElementVisitor {
        private MyVisitorBase() {
        }

        public void visitCodeBlock(@NotNull PsiCodeBlock block) {
        }

        public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
        }
    }
}

