/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.action;

import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.streams.action.ChainResolver;
import com.intellij.debugger.streams.diagnostic.ex.TraceCompilationException;
import com.intellij.debugger.streams.diagnostic.ex.TraceEvaluationException;
import com.intellij.debugger.streams.lib.LibrarySupportProvider;
import com.intellij.debugger.streams.psi.DebuggerPositionResolver;
import com.intellij.debugger.streams.psi.impl.DebuggerPositionResolverImpl;
import com.intellij.debugger.streams.trace.EvaluateExpressionTracer;
import com.intellij.debugger.streams.trace.ResolvedTracingResult;
import com.intellij.debugger.streams.trace.TraceExpressionBuilder;
import com.intellij.debugger.streams.trace.TracingCallback;
import com.intellij.debugger.streams.trace.TracingResult;
import com.intellij.debugger.streams.trace.impl.TraceResultInterpreterImpl;
import com.intellij.debugger.streams.ui.ChooserOption;
import com.intellij.debugger.streams.ui.impl.ElementChooserImpl;
import com.intellij.debugger.streams.ui.impl.EvaluationAwareTraceWindow;
import com.intellij.debugger.streams.wrapper.StreamChain;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class TraceStreamAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(TraceStreamAction.class);
    private static final ChainResolver CHAIN_RESOLVER = new ChainResolver();
    private final DebuggerPositionResolver myPositionResolver = new DebuggerPositionResolverImpl();

    public void update(@NotNull AnActionEvent e) {
        XDebugSession session = DebuggerUIUtil.getSession((AnActionEvent)e);
        PsiElement element = session == null ? null : this.myPositionResolver.getNearestElementToBreakpoint(session);
        Presentation presentation = e.getPresentation();
        if (element == null) {
            presentation.setVisible(true);
            presentation.setEnabled(false);
        } else {
            ChainResolver.ChainStatus chainStatus = CHAIN_RESOLVER.tryFindChain(element);
            switch (chainStatus) {
                case LANGUAGE_NOT_SUPPORTED: {
                    presentation.setEnabledAndVisible(false);
                    break;
                }
                case FOUND: {
                    presentation.setEnabledAndVisible(true);
                    break;
                }
                case COMPUTING: 
                case NOT_FOUND: {
                    presentation.setVisible(true);
                    presentation.setEnabled(false);
                }
            }
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        PsiElement element;
        XDebugSession session = DebuggerUIUtil.getSession((AnActionEvent)e);
        LibrarySupportProvider.EP_NAME.getExtensionList();
        XSourcePosition position = session == null ? null : session.getCurrentPosition();
        PsiElement psiElement = element = session == null ? null : this.myPositionResolver.getNearestElementToBreakpoint(session);
        if (element == null || position == null) {
            LOG.info("element at cursor not found");
            return;
        }
        List<ChainResolver.StreamChainWithLibrary> chains = CHAIN_RESOLVER.getChains(element);
        if (chains.isEmpty()) {
            LOG.warn("stream chain is not built");
            return;
        }
        if (chains.size() == 1) {
            TraceStreamAction.runTrace(chains.get((int)0).chain, chains.get((int)0).provider, session);
        } else {
            Project project = session.getProject();
            VirtualFile file = position.getFile();
            Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, file), true);
            LOG.assertTrue(editor != null);
            ApplicationManager.getApplication().invokeLater(() -> new MyStreamChainChooser(editor).show(ContainerUtil.map((Collection)chains, StreamChainOption::new), provider -> TraceStreamAction.runTrace(provider.chain, provider.provider, session)));
        }
    }

    private static void runTrace(@NotNull StreamChain chain, final @NotNull LibrarySupportProvider provider, @NotNull XDebugSession session) {
        final EvaluationAwareTraceWindow window = new EvaluationAwareTraceWindow(session, chain);
        ApplicationManager.getApplication().invokeLater(() -> ((EvaluationAwareTraceWindow)window).show());
        Project project = session.getProject();
        TraceExpressionBuilder expressionBuilder = provider.getExpressionBuilder(project);
        TraceResultInterpreterImpl resultInterpreter = new TraceResultInterpreterImpl(provider.getLibrarySupport().getInterpreterFactory());
        EvaluateExpressionTracer tracer = new EvaluateExpressionTracer(session, expressionBuilder, resultInterpreter);
        tracer.trace(chain, new TracingCallback(){

            @Override
            public void evaluated(@NotNull TracingResult result, @NotNull EvaluationContextImpl context) {
                ResolvedTracingResult resolvedTrace = result.resolve(provider.getLibrarySupport().getResolverFactory());
                ApplicationManager.getApplication().invokeLater(() -> window.setTrace(resolvedTrace, context));
            }

            @Override
            public void evaluationFailed(@NotNull String traceExpression, @NotNull String message) {
                this.notifyUI(message);
                throw new TraceEvaluationException(message, traceExpression);
            }

            @Override
            public void compilationFailed(@NotNull String traceExpression, @NotNull String message) {
                this.notifyUI(message);
                throw new TraceCompilationException(message, traceExpression);
            }

            private void notifyUI(@NotNull @Nls String message) {
                ApplicationManager.getApplication().invokeLater(() -> window.setFailMessage(message));
            }
        });
    }

    private static final class MyStreamChainChooser
    extends ElementChooserImpl<StreamChainOption> {
        MyStreamChainChooser(@NotNull Editor editor) {
            super(editor);
        }
    }

    private static final class StreamChainOption
    implements ChooserOption {
        final StreamChain chain;
        final LibrarySupportProvider provider;

        StreamChainOption(@NotNull ChainResolver.StreamChainWithLibrary chain) {
            this.chain = chain.chain;
            this.provider = chain.provider;
        }

        @Override
        @NotNull
        public Stream<TextRange> rangeStream() {
            return Stream.of(new TextRange(this.chain.getQualifierExpression().getTextRange().getStartOffset(), this.chain.getTerminationCall().getTextRange().getEndOffset()));
        }

        @Override
        @NotNull
        public String getText() {
            return this.chain.getCompactText();
        }
    }
}

