/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.action;

import com.intellij.debugger.streams.lib.LibrarySupportProvider;
import com.intellij.debugger.streams.wrapper.StreamChain;
import com.intellij.debugger.streams.wrapper.StreamChainBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.impl.ExtensionProcessingHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ChainResolver {
    private static final Logger LOG = Logger.getInstance(ChainResolver.class);
    private final AtomicReference<ChainsSearchResult> mySearchResult = new AtomicReference<ChainsSearchResult>(new ChainsSearchResult(0L, -1L, null));
    private final ExecutorService myExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"Stream debugger chains detector");

    ChainResolver() {
    }

    @NotNull
    ChainStatus tryFindChain(@NotNull PsiElement elementAtDebugger) {
        ChainsSearchResult result = this.mySearchResult.get();
        if (result.isSuitableFor(elementAtDebugger)) {
            return result.chainsStatus;
        }
        result = ChainsSearchResult.of(elementAtDebugger);
        ChainResolver.checkChainsExistenceInBackground(elementAtDebugger, result, this.myExecutor);
        this.mySearchResult.set(result);
        return result.chainsStatus;
    }

    private static void checkChainsExistenceInBackground(@NotNull PsiElement elementAtDebugger, @NotNull ChainsSearchResult searchResult, @NotNull ExecutorService executor) {
        List<LibrarySupportProvider> extensions = ChainResolver.forLanguage(elementAtDebugger.getLanguage());
        if (extensions.isEmpty()) {
            searchResult.markUnsupportedLanguage();
        } else {
            ReadAction.nonBlocking(() -> {
                boolean found;
                LibrarySupportProvider provider = (LibrarySupportProvider)ExtensionProcessingHelper.findFirstSafe(p -> p.getChainBuilder().isChainExists(elementAtDebugger), (Iterable)extensions);
                boolean bl = found = provider != null;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Chains found:" + found);
                }
                searchResult.updateStatus(found);
            }).inSmartMode(elementAtDebugger.getProject()).submit((Executor)executor);
        }
    }

    @NotNull
    List<StreamChainWithLibrary> getChains(@NotNull PsiElement elementAtDebugger) {
        ChainsSearchResult result = this.mySearchResult.get();
        if (!result.isSuitableFor(elementAtDebugger) || !result.chainsStatus.equals((Object)ChainStatus.FOUND)) {
            LOG.error("Cannot build chains: " + result.chainsStatus);
            return Collections.emptyList();
        }
        ArrayList<StreamChainWithLibrary> chains = new ArrayList<StreamChainWithLibrary>();
        String elementLanguageId = elementAtDebugger.getLanguage().getID();
        LibrarySupportProvider.EP_NAME.forEachExtensionSafe(provider -> {
            StreamChainBuilder chainBuilder;
            if (provider.getLanguageId().equals(elementLanguageId) && (chainBuilder = provider.getChainBuilder()).isChainExists(elementAtDebugger)) {
                for (StreamChain x : chainBuilder.build(elementAtDebugger)) {
                    chains.add(new StreamChainWithLibrary(x, (LibrarySupportProvider)provider));
                }
            }
        });
        return chains;
    }

    @NotNull
    private static List<LibrarySupportProvider> forLanguage(@NotNull Language language) {
        return LibrarySupportProvider.EP_NAME.getByGroupingKey((Object)language.getID(), ChainResolver.class, LibrarySupportProvider::getLanguageId);
    }

    private static class ChainsSearchResult {
        final long elementHash;
        final long offset;
        final long fileModificationStamp;
        @NotNull
        volatile ChainStatus chainsStatus = ChainStatus.COMPUTING;

        ChainsSearchResult(long elementHash, long offsetInFile, @Nullable PsiFile containingFile) {
            this.elementHash = elementHash;
            this.fileModificationStamp = ChainsSearchResult.getModificationStamp(containingFile);
            this.offset = offsetInFile;
        }

        private static long getModificationStamp(@Nullable PsiFile file) {
            return file == null ? -1L : file.getModificationStamp();
        }

        @NotNull
        static ChainsSearchResult of(@NotNull PsiElement element) {
            return new ChainsSearchResult(element.hashCode(), element.getTextOffset(), element.getContainingFile());
        }

        void updateStatus(boolean found) {
            LOG.assertTrue(ChainStatus.COMPUTING.equals((Object)this.chainsStatus));
            this.chainsStatus = found ? ChainStatus.FOUND : ChainStatus.NOT_FOUND;
        }

        void markUnsupportedLanguage() {
            LOG.assertTrue(ChainStatus.COMPUTING.equals((Object)this.chainsStatus));
            this.chainsStatus = ChainStatus.LANGUAGE_NOT_SUPPORTED;
        }

        boolean isSuitableFor(@NotNull PsiElement element) {
            return this.elementHash == (long)element.hashCode() && this.offset == (long)element.getTextOffset() && this.fileModificationStamp == ChainsSearchResult.getModificationStamp(element.getContainingFile());
        }
    }

    static enum ChainStatus {
        LANGUAGE_NOT_SUPPORTED,
        COMPUTING,
        FOUND,
        NOT_FOUND;

    }

    static final class StreamChainWithLibrary {
        final StreamChain chain;
        final LibrarySupportProvider provider;

        StreamChainWithLibrary(@NotNull StreamChain chain, @NotNull LibrarySupportProvider provider) {
            this.chain = chain;
            this.provider = provider;
        }
    }
}

