/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.sorting;

import com.intellij.application.options.CodeCompletionConfigurable;
import com.intellij.completion.ml.MLCompletionBundle;
import com.intellij.completion.ml.experiment.ExperimentInfo;
import com.intellij.completion.ml.experiment.ExperimentStatus;
import com.intellij.completion.ml.ranker.ExperimentModelProvider;
import com.intellij.completion.ml.ranker.local.MLCompletionLocalModelsUtil;
import com.intellij.completion.ml.settings.CompletionMLRankingSettings;
import com.intellij.completion.ml.sorting.LanguageRankingModel;
import com.intellij.completion.ml.sorting.RankingModelWrapper;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.ml.DecisionFunction;
import com.intellij.internal.ml.completion.DecoratingItemsPolicy;
import com.intellij.internal.ml.completion.RankingModelProvider;
import com.intellij.lang.Language;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\fH\u0002J \u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u00020\fH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/completion/ml/sorting/RankingSupport;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "ML_ENABLED_NOTIFICATION_SHOWN_KEY", "", "enabledInTests", "", "availableRankers", "", "Lcom/intellij/internal/ml/completion/RankingModelProvider;", "enableInTests", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "findProviderSafe", "language", "Lcom/intellij/lang/Language;", "getRankingModel", "Lcom/intellij/completion/ml/sorting/RankingModelWrapper;", "shouldSortByML", "provider", "showNotificationAboutMLOnce", "shouldSort", "isEnabledByDefault", "providerId", "tryGetModel", "MLEnabledNotification", "intellij.completionMlRanking"})
public final class RankingSupport {
    @NotNull
    public static final RankingSupport INSTANCE = new RankingSupport();
    @NotNull
    private static final String ML_ENABLED_NOTIFICATION_SHOWN_KEY = "completion.ml.enabled.notification.shown";
    @NotNull
    private static final Logger LOG;
    private static boolean enabledInTests;

    private RankingSupport() {
    }

    @Nullable
    public final RankingModelWrapper getRankingModel(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        String string = language.getID();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"language.id");
        DecisionFunction decisionFunction = MLCompletionLocalModelsUtil.INSTANCE.getModel(string);
        if (decisionFunction != null) {
            DecisionFunction it = decisionFunction;
            boolean bl = false;
            return new LanguageRankingModel(it, DecoratingItemsPolicy.Companion.getDISABLED());
        }
        RankingModelProvider provider = this.findProviderSafe(language);
        return provider != null && this.shouldSortByML(language, provider) ? this.tryGetModel(provider) : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RankingModelProvider> availableRankers() {
        void $this$filterTo$iv$iv;
        Collection collection = Language.getRegisteredLanguages();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getRegisteredLanguages()");
        Collection registeredLanguages = collection;
        ExperimentStatus experimentStatus = ExperimentStatus.Companion.getInstance();
        Iterable $this$filter$iv = ExperimentModelProvider.Companion.availableProviders();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block4: {
                RankingModelProvider provider = (RankingModelProvider)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = registeredLanguages;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Language it = (Language)element$iv;
                        boolean bl3 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        if (!ExperimentModelProvider.Companion.match(provider, it, experimentStatus.forLanguage(it).getVersion())) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    @Nullable
    public final RankingModelProvider findProviderSafe(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        ExperimentInfo experimentInfo = ExperimentStatus.Companion.getInstance().forLanguage(language);
        try {
            return ExperimentModelProvider.Companion.findProvider(language, experimentInfo.getVersion());
        }
        catch (IllegalStateException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private final RankingModelWrapper tryGetModel(RankingModelProvider provider) {
        try {
            DecisionFunction decisionFunction = provider.getModel();
            Intrinsics.checkNotNullExpressionValue((Object)decisionFunction, (String)"provider.model");
            DecoratingItemsPolicy decoratingItemsPolicy = provider.getDecoratingPolicy();
            Intrinsics.checkNotNullExpressionValue((Object)decoratingItemsPolicy, (String)"provider.decoratingPolicy");
            return new LanguageRankingModel(decisionFunction, decoratingItemsPolicy);
        }
        catch (Exception e) {
            LOG.error("Could not create ranking model with id '" + provider.getId() + "' and name '" + provider.getDisplayNameInSettings() + "'", (Throwable)e);
            return null;
        }
    }

    private final boolean shouldSortByML(Language language, RankingModelProvider provider) {
        boolean shouldSort;
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            return enabledInTests;
        }
        CompletionMLRankingSettings completionMLRankingSettings = CompletionMLRankingSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)completionMLRankingSettings, (String)"getInstance()");
        CompletionMLRankingSettings settings = completionMLRankingSettings;
        ExperimentStatus experimentStatus = ExperimentStatus.Companion.getInstance();
        ExperimentInfo experimentInfo = experimentStatus.forLanguage(language);
        boolean bl = shouldSort = settings.isRankingEnabled() && settings.isLanguageEnabled(provider.getId());
        if (application.isEAP() && experimentInfo.getInExperiment() && !experimentStatus.isDisabled()) {
            settings.updateShowDiffInExperiment(experimentInfo.getShouldShowArrows());
        } else {
            boolean bl2 = provider.isEnabledByDefault();
            String string = provider.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"provider.id");
            this.showNotificationAboutMLOnce(shouldSort, bl2, string);
        }
        return shouldSort;
    }

    private final void showNotificationAboutMLOnce(boolean shouldSort, boolean isEnabledByDefault, String providerId) {
        PropertiesComponent properties;
        if (shouldSort && isEnabledByDefault && Intrinsics.areEqual((Object)providerId, (Object)"PHP") && !(properties = PropertiesComponent.getInstance()).getBoolean(ML_ENABLED_NOTIFICATION_SHOWN_KEY)) {
            properties.setValue(ML_ENABLED_NOTIFICATION_SHOWN_KEY, true);
            new MLEnabledNotification().notify(null);
        }
    }

    @TestOnly
    public final void enableInTests(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        enabledInTests = true;
        Disposer.register((Disposable)parentDisposable, RankingSupport::enableInTests$lambda$3);
    }

    private static final void enableInTests$lambda$3() {
        enabledInTests = false;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RankingSupport.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/completion/ml/sorting/RankingSupport$MLEnabledNotification;", "Lcom/intellij/notification/Notification;", "()V", "intellij.completionMlRanking"})
    private static final class MLEnabledNotification
    extends Notification {
        public MLEnabledNotification() {
            super(MLCompletionBundle.message("ml.completion.notification.groupId", new Object[0]), MLCompletionBundle.message("ml.completion.notification.title", new Object[0]), MLCompletionBundle.message("ml.completion.notification.ml.enabled.content", new Object[0]), NotificationType.INFORMATION);
            String string = MLCompletionBundle.message("ml.completion.notification.enable.decorations", new Object[0]);
            this.addAction((AnAction)new NotificationAction(string){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                    CompletionMLRankingSettings completionMLRankingSettings = CompletionMLRankingSettings.getInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)completionMLRankingSettings, (String)"getInstance()");
                    CompletionMLRankingSettings settings = completionMLRankingSettings;
                    settings.setShowDiffEnabled(true);
                    settings.setDecorateRelevantEnabled(true);
                    notification.expire();
                }
            });
            string = MLCompletionBundle.message("ml.completion.notification.configure", new Object[0]);
            this.addAction((AnAction)new NotificationAction(string){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                    ShowSettingsUtil.getInstance().showSettingsDialog(null, CodeCompletionConfigurable.class);
                }
            });
        }
    }
}

