/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.sorting;

import com.intellij.codeInsight.completion.CompletionFinalSorter;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.ml.MLRankingIgnorable;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.completion.ml.features.RankingFeaturesOverrides;
import com.intellij.completion.ml.performance.MLCompletionPerformanceTracker;
import com.intellij.completion.ml.personalization.session.SessionFactorsUtils;
import com.intellij.completion.ml.settings.CompletionMLRankingSettings;
import com.intellij.completion.ml.sorting.ElementFeatures;
import com.intellij.completion.ml.sorting.ItemRankInfo;
import com.intellij.completion.ml.sorting.ItemsDecoratorInitializer;
import com.intellij.completion.ml.sorting.LookupFeatureProvider;
import com.intellij.completion.ml.sorting.RankingFeatures;
import com.intellij.completion.ml.sorting.RankingModelWrapper;
import com.intellij.completion.ml.storage.MutableLookupStorage;
import com.intellij.completion.ml.util.LookupExtensionsKt;
import com.intellij.completion.ml.util.RelevanceUtil;
import com.intellij.internal.ml.completion.DecoratingItemsPolicy;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.textMatching.PrefixMatchingUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001d\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 D2\u00020\u0001:\u0003DEFB\u0005\u00a2\u0006\u0002\u0010\u0002JL\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u00042\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J9\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u001dJh\u0010\u001e\u001a\u00020\n2\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00042\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00100#2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\"\u0010*\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J4\u0010+\u001a \u0012\u0004\u0012\u00020\u0005\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0,0!0#2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050-H\u0016J\u0016\u0010.\u001a\u00020\b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050/H\u0002J\u0016\u00100\u001a\u00020\b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050/H\u0002J\u0018\u00101\u001a\u0002022\u0006\u00103\u001a\u0002022\u0006\u00104\u001a\u000205H\u0002J&\u00106\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050/2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050-2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016JV\u00107\u001a\b\u0012\u0004\u0012\u00020\u00050!2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050!2\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00170#2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00100#2\u0006\u0010(\u001a\u00020)2\u0006\u0010&\u001a\u00020'H\u0002J4\u00108\u001a\u00020\n2\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00042\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050!2\u0006\u0010$\u001a\u00020\u0010H\u0002J<\u00109\u001a\b\u0012\u0004\u0012\u00020\u00050!*\b\u0012\u0004\u0012\u00020\u00050!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00100#2\u0006\u0010:\u001a\u00020\u00102\u0006\u0010&\u001a\u00020'H\u0002J&\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00050!*\b\u0012\u0004\u0012\u00020\u00050/2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00050/H\u0002J\f\u0010=\u001a\u00020\b*\u00020\u0005H\u0002J>\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00050!*\b\u0012\u0004\u0012\u00020\u00050!2\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00170#2\u0006\u0010&\u001a\u00020'2\u0006\u0010?\u001a\u00020@H\u0002J\u0018\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00050/*\b\u0012\u0004\u0012\u00020\u00050/H\u0002J6\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00050/*\b\u0012\u0004\u0012\u00020\u00050/2\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00170#2\u0006\u0010C\u001a\u00020\u0010H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/intellij/completion/ml/sorting/MLSorter;", "Lcom/intellij/codeInsight/completion/CompletionFinalSorter;", "()V", "cachedScore", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "Lcom/intellij/completion/ml/sorting/ItemRankInfo;", "reorderOnlyTopItems", "", "calculateAdditionalFeaturesTo", "", "additionalMap", "", "", "lookupElement", "oldQueryLength", "", "prefixLength", "position", "itemsCount", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "calculateElementScore", "", "ranker", "Lcom/intellij/completion/ml/sorting/RankingModelWrapper;", "element", "features", "Lcom/intellij/completion/ml/sorting/RankingFeatures;", "(Lcom/intellij/completion/ml/sorting/RankingModelWrapper;Lcom/intellij/codeInsight/lookup/LookupElement;ILcom/intellij/completion/ml/sorting/RankingFeatures;I)Ljava/lang/Double;", "calculateScores", "element2score", "items", "", "positionsBefore", "", "queryLength", "prefix", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "lookupStorage", "Lcom/intellij/completion/ml/storage/MutableLookupStorage;", "getCachedRankInfo", "getRelevanceObjects", "Lcom/intellij/openapi/util/Pair;", "", "hasUnknownFeatures", "", "isCacheValid", "overrideElementFeaturesIfNeeded", "Lcom/intellij/completion/ml/sorting/ElementFeatures;", "elementFeatures", "language", "Lcom/intellij/lang/Language;", "sort", "sortByMlScores", "tryFillFromCache", "addDiagnosticsIfNeeded", "reordered", "insertIgnoredItems", "allItems", "isIgnored", "markRelevantItemsIfNeeded", "decoratingItemsPolicy", "Lcom/intellij/internal/ml/completion/DecoratingItemsPolicy;", "removeDuplicatesIfNeeded", "reorderByMLScores", "toReorder", "Companion", "MeaningfulFeaturesExtractor", "ModelTimeTracker", "intellij.completionMlRanking"})
public final class MLSorter
extends CompletionFinalSorter {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<LookupElement, ItemRankInfo> cachedScore = new IdentityHashMap();
    private final boolean reorderOnlyTopItems = Registry.is((String)"completion.ml.reorder.only.top.items", (boolean)true);
    @Deprecated
    @NotNull
    private static final Logger LOG;
    @Deprecated
    private static final int REORDER_ONLY_TOP_K = 5;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<LookupElement, List<com.intellij.openapi.util.Pair<String, Object>>> getRelevanceObjects(@NotNull Iterable<? extends LookupElement> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        if (this.cachedScore.isEmpty()) {
            void $this$associateTo$iv$iv;
            Iterable<? extends LookupElement> $this$associate$iv = items;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault($this$associate$iv, (int)10)), (int)16);
            Iterable<? extends LookupElement> iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object t : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                LookupElement it = (LookupElement)t;
                boolean bl = false;
                it = TuplesKt.to((Object)it, (Object)CollectionsKt.listOf((Object)com.intellij.openapi.util.Pair.create((Object)"ml_rank", (Object)"NONE")));
                map.put(it.getFirst(), it.getSecond());
            }
            return destination$iv$iv;
        }
        if (this.hasUnknownFeatures(items)) {
            Iterable<? extends LookupElement> $this$associate$iv = items;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault($this$associate$iv, (int)10)), (int)16);
            Iterable<? extends LookupElement> $this$associateTo$iv$iv = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (LookupElement lookupElement : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                LookupElement it = lookupElement;
                boolean bl = false;
                it = TuplesKt.to((Object)it, (Object)CollectionsKt.listOf((Object)com.intellij.openapi.util.Pair.create((Object)"ml_rank", (Object)"UNDEFINED")));
                map.put(it.getFirst(), it.getSecond());
            }
            return destination$iv$iv;
        }
        if (!this.isCacheValid(items)) {
            Iterable<? extends LookupElement> $this$associate$iv = items;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault($this$associate$iv, (int)10)), (int)16);
            Iterable<? extends LookupElement> $this$associateTo$iv$iv = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (LookupElement lookupElement : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                LookupElement it = lookupElement;
                boolean bl = false;
                it = TuplesKt.to((Object)it, (Object)CollectionsKt.listOf((Object)com.intellij.openapi.util.Pair.create((Object)"ml_rank", (Object)"INVALID_CACHE")));
                map.put(it.getFirst(), it.getSecond());
            }
            return destination$iv$iv;
        }
        Iterable<? extends LookupElement> $this$associate$iv = items;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault($this$associate$iv, (int)10)), (int)16);
        Iterable<? extends LookupElement> $this$associateTo$iv$iv = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (LookupElement lookupElement : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            LookupElement it = lookupElement;
            boolean bl = false;
            List result = new ArrayList();
            ItemRankInfo cached = this.cachedScore.get(it);
            if (cached != null) {
                com.intellij.openapi.util.Pair pair = com.intellij.openapi.util.Pair.create((Object)"ml_rank", (Object)cached.getMlRank());
                Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(FeatureUtils.ML_RANK, cached.mlRank)");
                result.add(pair);
                com.intellij.openapi.util.Pair pair2 = com.intellij.openapi.util.Pair.create((Object)"before_rerank_order", (Object)cached.getPositionBefore());
                Intrinsics.checkNotNullExpressionValue((Object)pair2, (String)"create(FeatureUtils.BEFO\u2026R, cached.positionBefore)");
                result.add(pair2);
            }
            Pair pair = TuplesKt.to((Object)it, (Object)result);
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isCacheValid(Iterable<? extends LookupElement> items) {
        void $this$mapTo$iv$iv;
        Iterable<? extends LookupElement> $this$map$iv = items;
        boolean $i$f$map = false;
        Iterable<? extends LookupElement> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LookupElement lookupElement = (LookupElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ItemRankInfo itemRankInfo = this.cachedScore.get(it);
            collection.add(itemRankInfo != null ? Integer.valueOf(itemRankInfo.getPrefixLength()) : null);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv)).size() == 1;
    }

    private final boolean hasUnknownFeatures(Iterable<? extends LookupElement> items) {
        boolean bl;
        block3: {
            Iterable<? extends LookupElement> $this$any$iv = items;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator<? extends LookupElement> iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    ItemRankInfo score2;
                    LookupElement element$iv;
                    LookupElement it = element$iv = iterator.next();
                    boolean bl2 = false;
                    ItemRankInfo itemRankInfo = score2 = this.cachedScore.get(it);
                    if (!((itemRankInfo != null ? itemRankInfo.getMlRank() : null) == null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Iterable<LookupElement> sort(@NotNull Iterable<? extends LookupElement> items, @NotNull CompletionParameters parameters) {
        void $this$filterTo$iv$iv;
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        LookupEx lookupEx = LookupManager.getActiveLookup((Editor)parameters.getEditor());
        LookupImpl lookupImpl = lookupEx instanceof LookupImpl ? (LookupImpl)lookupEx : null;
        if (lookupImpl == null) {
            return items;
        }
        LookupImpl lookup = lookupImpl;
        MutableLookupStorage mutableLookupStorage = MutableLookupStorage.Companion.get(lookup);
        if (mutableLookupStorage == null) {
            return items;
        }
        MutableLookupStorage lookupStorage = mutableLookupStorage;
        if (!lookupStorage.shouldComputeFeatures()) {
            return items;
        }
        long startedTimestamp = System.currentTimeMillis();
        int queryLength = LookupExtensionsKt.queryLength(lookup);
        String prefix = LookupExtensionsKt.prefix((Lookup)lookup);
        Iterable $this$associate$iv = CollectionsKt.withIndex(items);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo22 = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            IndexedValue it = (IndexedValue)element$iv$iv;
            boolean bl = false;
            it = TuplesKt.to((Object)it.getValue(), (Object)it.getIndex());
            map.put(it.getFirst(), it.getSecond());
        }
        Map positionsBefore = destination$iv$iv;
        List elements = CollectionsKt.toList((Iterable)positionsBefore.keySet());
        HashMap element2score = new HashMap(elements.size());
        this.tryFillFromCache(element2score, elements, queryLength);
        Iterable $this$filter$iv = elements;
        boolean $i$f$filter = false;
        Iterable $i$f$associateTo22 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LookupElement it = (LookupElement)element$iv$iv;
            boolean bl = false;
            if (!(element2score.get(it) == null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List itemsForScoring = (List)destination$iv$iv2;
        this.calculateScores(element2score, itemsForScoring, positionsBefore, queryLength, prefix, lookup, lookupStorage, parameters);
        List<LookupElement> finalRanking = this.sortByMlScores(elements, element2score, positionsBefore, lookupStorage, lookup);
        lookupStorage.getPerformanceTracker().sortingPerformed(itemsForScoring.size(), System.currentTimeMillis() - startedTimestamp);
        LOG.assertTrue(elements.size() == finalRanking.size(), (Object)"MLSorter shouldn't filter items");
        return finalRanking;
    }

    private final void tryFillFromCache(Map<LookupElement, Double> element2score, List<? extends LookupElement> items, int queryLength) {
        Iterator<? extends LookupElement> iterator = items.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int position = n++;
            LookupElement element = iterator.next();
            ItemRankInfo cachedInfo = this.getCachedRankInfo(element, queryLength, position);
            if (cachedInfo == null) {
                return;
            }
            element2score.put(element, cachedInfo.getMlRank());
        }
    }

    private final void calculateScores(Map<LookupElement, Double> element2score, List<? extends LookupElement> items, Map<LookupElement, Integer> positionsBefore, int queryLength, String prefix, LookupImpl lookup, MutableLookupStorage lookupStorage, CompletionParameters parameters) {
        if (items.isEmpty()) {
            return;
        }
        RankingModelWrapper rankingModel = lookupStorage.getModel();
        Project project = lookup.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"lookup.project");
        lookupStorage.initUserFactors(project);
        MeaningfulFeaturesExtractor meaningfulRelevanceExtractor = new MeaningfulFeaturesExtractor();
        Map map = lookup.getRelevanceObjects((Iterable)items, false);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"lookup.getRelevanceObjects(items, false)");
        Map relevanceObjects = map;
        List calculatedElementFeatures = new ArrayList();
        for (LookupElement lookupElement : items) {
            int position = ((Number)MapsKt.getValue(positionsBefore, (Object)lookupElement)).intValue();
            List list = relevanceObjects.getOrDefault(lookupElement, CollectionsKt.emptyList());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"relevanceObjects.getOrDe\u2026ult(element, emptyList())");
            Pair<Map<String, Object>, Map<String, Object>> pair = RelevanceUtil.INSTANCE.asRelevanceMaps(list);
            Map relevance = (Map)pair.component1();
            Map additional = (Map)pair.component2();
            SessionFactorsUtils.INSTANCE.saveElementFactorsTo(additional, lookupStorage, lookupElement);
            this.calculateAdditionalFeaturesTo(additional, lookupElement, queryLength, prefix.length(), position, items.size(), parameters);
            lookupStorage.getPerformanceTracker().trackElementFeaturesCalculation("prefix", (Function0)new Function0<Unit>(lookupElement, prefix, (Map<String, Object>)additional){
                final /* synthetic */ LookupElement $element;
                final /* synthetic */ String $prefix;
                final /* synthetic */ Map<String, Object> $additional;
                {
                    this.$element = $element;
                    this.$prefix = $prefix;
                    this.$additional = $additional;
                    super(0);
                }

                public final void invoke() {
                    String string = this.$element.getLookupString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.lookupString");
                    PrefixMatchingUtil.INSTANCE.calculateFeatures(string, this.$prefix, this.$additional);
                }
            });
            meaningfulRelevanceExtractor.processFeatures(relevance);
            calculatedElementFeatures.add(new ElementFeatures(relevance, additional));
        }
        Map lookupFeatures = new LinkedHashMap();
        for (LookupFeatureProvider elementFeatureProvider : LookupFeatureProvider.forLanguage(lookupStorage.getLanguage())) {
            Map<String, String> features2;
            Intrinsics.checkNotNullExpressionValue(elementFeatureProvider.calculateFeatures(calculatedElementFeatures), (String)"elementFeatureProvider.c\u2026alculatedElementFeatures)");
            lookupFeatures.putAll(features2);
        }
        Map<String, Object> map2 = SessionFactorsUtils.INSTANCE.updateSessionFactors(lookupStorage, items);
        Set<String> meaningfulRelevance = meaningfulRelevanceExtractor.meaningfulFeatures();
        RankingFeatures features2 = new RankingFeatures(lookupStorage.getUserFactors(), lookupStorage.getContextFactors(), map2, lookupFeatures, meaningfulRelevance);
        ModelTimeTracker tracker = new ModelTimeTracker();
        Iterator<? extends LookupElement> iterator = items.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            LookupElement element = iterator.next();
            ElementFeatures elementFeatures = this.overrideElementFeaturesIfNeeded((ElementFeatures)calculatedElementFeatures.get(i), lookupStorage.getLanguage());
            Map<String, Object> relevance = elementFeatures.component1();
            Map<String, Object> additional = elementFeatures.component2();
            Double score2 = tracker.measure((Function0<Double>)((Function0)new Function0<Double>(positionsBefore, element, features2, relevance, additional, this, rankingModel, queryLength){
                final /* synthetic */ Map<LookupElement, Integer> $positionsBefore;
                final /* synthetic */ LookupElement $element;
                final /* synthetic */ RankingFeatures $features;
                final /* synthetic */ Map<String, Object> $relevance;
                final /* synthetic */ Map<String, Object> $additional;
                final /* synthetic */ MLSorter this$0;
                final /* synthetic */ RankingModelWrapper $rankingModel;
                final /* synthetic */ int $queryLength;
                {
                    this.$positionsBefore = $positionsBefore;
                    this.$element = $element;
                    this.$features = $features;
                    this.$relevance = $relevance;
                    this.$additional = $additional;
                    this.this$0 = $receiver;
                    this.$rankingModel = $rankingModel;
                    this.$queryLength = $queryLength;
                    super(0);
                }

                @Nullable
                public final Double invoke() {
                    int position = ((Number)MapsKt.getValue(this.$positionsBefore, (Object)this.$element)).intValue();
                    RankingFeatures elementFeatures = this.$features.withElementFeatures(this.$relevance, this.$additional);
                    return MLSorter.access$calculateElementScore(this.this$0, this.$rankingModel, this.$element, position, elementFeatures, this.$queryLength);
                }
            }));
            element2score.put(element, score2);
            additional.putAll(relevance);
            lookupStorage.fireElementScored(element, additional, score2);
        }
        tracker.finished(lookupStorage.getPerformanceTracker());
    }

    /*
     * WARNING - void declaration
     */
    private final ElementFeatures overrideElementFeaturesIfNeeded(ElementFeatures elementFeatures, Language language) {
        for (RankingFeaturesOverrides it : RankingFeaturesOverrides.Companion.forLanguage(language)) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Collection collection;
            Collection destination$iv$iv;
            Logger logger;
            Map<String, Object> overrides = it.getMlElementFeaturesOverrides(elementFeatures.getAdditional());
            elementFeatures.getAdditional().putAll(overrides);
            if (!overrides.isEmpty()) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                Map<String, Object> map = overrides;
                logger = LOG;
                boolean $i$f$map = false;
                void var8_9 = $this$map$iv2;
                destination$iv$iv = new ArrayList($this$map$iv2.size());
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv2.entrySet().iterator();
                while (iterator.hasNext()) {
                    void it2;
                    Map.Entry item$iv$iv;
                    Map.Entry entry = item$iv$iv = iterator.next();
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((String)it2.getKey());
                }
                logger.debug("The next ML features was overridden: [" + CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), null, null, null, (int)0, null, null, (int)63, null) + "]");
            }
            Map<String, Object> relevanceOverrides = it.getDefaultWeigherFeaturesOverrides(elementFeatures.getRelevance());
            elementFeatures.getRelevance().putAll(relevanceOverrides);
            if (!(!relevanceOverrides.isEmpty())) continue;
            Map<String, Object> $i$f$map = relevanceOverrides;
            logger = LOG;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it3;
                Map.Entry item$iv$iv;
                Map.Entry bl = item$iv$iv = iterator.next();
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add((String)it3.getKey());
            }
            logger.debug("The next default weigher features was overridden: [" + CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), null, null, null, (int)0, null, null, (int)63, null) + "]");
        }
        return elementFeatures;
    }

    /*
     * WARNING - void declaration
     */
    private final List<LookupElement> sortByMlScores(List<? extends LookupElement> items, Map<LookupElement, Double> element2score, Map<LookupElement, Integer> positionsBefore, MutableLookupStorage lookupStorage, LookupImpl lookup) {
        boolean shouldSort;
        Double it;
        boolean bl;
        block7: {
            Iterable $this$none$iv = element2score.values();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    it = (Double)element$iv;
                    boolean bl2 = false;
                    if (!(it == null)) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        boolean bl3 = shouldSort = bl && lookupStorage.shouldReRank();
        if (LOG.isDebugEnabled()) {
            LOG.debug("ML sorting in completion used=" + shouldSort + " for language=" + lookupStorage.getLanguage().getID());
        }
        if (shouldSort) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            lookupStorage.fireReorderedUsingMLScores();
            RankingModelWrapper rankingModelWrapper = lookupStorage.getModel();
            if (rankingModelWrapper == null || (rankingModelWrapper = rankingModelWrapper.decoratingPolicy()) == null) {
                rankingModelWrapper = DecoratingItemsPolicy.Companion.getDISABLED();
            }
            RankingModelWrapper decoratingItemsPolicy = rankingModelWrapper;
            int topItemsCount = this.reorderOnlyTopItems ? 5 : Integer.MAX_VALUE;
            Iterable iterable = items;
            MLSorter mLSorter = this;
            MLSorter mLSorter2 = this;
            MLSorter mLSorter3 = this;
            MLSorter mLSorter4 = this;
            boolean $i$f$filter = false;
            it = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                LookupElement it2 = (LookupElement)element$iv$iv;
                boolean bl4 = false;
                if (!(!this.isIgnored(it2))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            return mLSorter4.addDiagnosticsIfNeeded(mLSorter3.markRelevantItemsIfNeeded(mLSorter2.insertIgnoredItems(mLSorter.reorderByMLScores(list, element2score, topItemsCount), (Iterable<? extends LookupElement>)items), element2score, lookup, (DecoratingItemsPolicy)decoratingItemsPolicy), positionsBefore, topItemsCount, lookup);
        }
        return items;
    }

    private final void calculateAdditionalFeaturesTo(Map<String, Object> additionalMap, LookupElement lookupElement, int oldQueryLength, int prefixLength, int position, int itemsCount, CompletionParameters parameters) {
        Integer n = position;
        additionalMap.put("position", n);
        additionalMap.put("relative_position", (double)position / (double)itemsCount);
        n = oldQueryLength;
        additionalMap.put("query_length", n);
        n = prefixLength;
        additionalMap.put("prefix_length", n);
        additionalMap.put("result_length", lookupElement.getLookupString().length());
        additionalMap.put("auto_popup", parameters.isAutoPopup());
        additionalMap.put("completion_type", parameters.getCompletionType().toString());
        additionalMap.put("invocation_count", parameters.getInvocationCount());
    }

    /*
     * WARNING - void declaration
     */
    private final Iterable<LookupElement> reorderByMLScores(Iterable<? extends LookupElement> $this$reorderByMLScores, Map<LookupElement, Double> element2score, int toReorder) {
        void $this$sortedByDescending$iv;
        Iterable<? extends LookupElement> iterable = $this$reorderByMLScores;
        boolean $i$f$sortedByDescending = false;
        LinkedHashSet result = (LinkedHashSet)CollectionsKt.toCollection((Iterable)CollectionsKt.take(this.removeDuplicatesIfNeeded(CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(element2score){
            final /* synthetic */ Map $element2score$inlined;
            {
                this.$element2score$inlined = map;
            }

            public final int compare(T a, T b) {
                LookupElement it = (LookupElement)b;
                boolean bl = false;
                Comparable comparable = (Double)MapsKt.getValue((Map)this.$element2score$inlined, (Object)it);
                it = (LookupElement)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Double)MapsKt.getValue((Map)this.$element2score$inlined, (Object)it)));
            }
        })), (int)toReorder), (Collection)new LinkedHashSet());
        CollectionsKt.addAll((Collection)result, $this$reorderByMLScores);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final List<LookupElement> insertIgnoredItems(Iterable<? extends LookupElement> $this$insertIgnoredItems, Iterable<? extends LookupElement> allItems) {
        void $this$mapNotNullTo$iv$iv;
        Iterator<? extends LookupElement> sortedItems = $this$insertIgnoredItems.iterator();
        Iterable<? extends LookupElement> $this$mapNotNull$iv = allItems;
        boolean $i$f$mapNotNull = false;
        Iterable<? extends LookupElement> iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            LookupElement it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            LookupElement item = (LookupElement)element$iv$iv;
            boolean bl2 = false;
            if ((this.isIgnored(item) ? item : (sortedItems.hasNext() ? sortedItems.next() : null)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Iterable<LookupElement> removeDuplicatesIfNeeded(Iterable<? extends LookupElement> $this$removeDuplicatesIfNeeded) {
        Iterable iterable;
        if (Registry.is((String)"completion.ml.reorder.without.duplicates", (boolean)false)) {
            Iterable $this$distinctBy$iv = $this$removeDuplicatesIfNeeded;
            boolean $i$f$distinctBy = false;
            HashSet<String> set$iv = new HashSet<String>();
            ArrayList<LookupElement> list$iv = new ArrayList<LookupElement>();
            Iterator<LookupElement> iterator = $this$distinctBy$iv.iterator();
            while (iterator.hasNext()) {
                LookupElement e$iv;
                LookupElement it = e$iv = iterator.next();
                boolean bl = false;
                String key$iv = it.getLookupString();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            iterable = list$iv;
        } else {
            iterable = $this$removeDuplicatesIfNeeded;
        }
        return iterable;
    }

    /*
     * WARNING - void declaration
     */
    private final List<LookupElement> addDiagnosticsIfNeeded(List<? extends LookupElement> $this$addDiagnosticsIfNeeded, Map<LookupElement, Integer> positionsBefore, int reordered, LookupImpl lookup) {
        if (CompletionMLRankingSettings.getInstance().isShowDiffEnabled()) {
            boolean positionChanged = false;
            Iterable $this$forEachIndexed$iv = $this$addDiagnosticsIfNeeded;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void element;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                LookupElement lookupElement = (LookupElement)item$iv;
                int position = n;
                boolean bl = false;
                int before = ((Number)MapsKt.getValue(positionsBefore, (Object)element)).intValue();
                if (before >= reordered && position >= reordered) continue;
                int diff = position - before;
                positionChanged = positionChanged || diff != 0;
                ItemsDecoratorInitializer.Companion.itemPositionChanged((LookupElement)element, diff);
            }
            ItemsDecoratorInitializer.Companion.markAsReordered(lookup, positionChanged);
        }
        return $this$addDiagnosticsIfNeeded;
    }

    /*
     * WARNING - void declaration
     */
    private final List<LookupElement> markRelevantItemsIfNeeded(List<? extends LookupElement> $this$markRelevantItemsIfNeeded, Map<LookupElement, Double> element2score, LookupImpl lookup, DecoratingItemsPolicy decoratingItemsPolicy) {
        if (CompletionMLRankingSettings.getInstance().isDecorateRelevantEnabled()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object object = $this$markRelevantItemsIfNeeded;
            DecoratingItemsPolicy decoratingItemsPolicy2 = decoratingItemsPolicy;
            boolean $i$f$map = false;
            void var8_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                LookupElement lookupElement = (LookupElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Double d = element2score.get(it);
                collection.add(d != null ? d : 0.0);
            }
            Set relevantItems = decoratingItemsPolicy2.itemsToDecorate((Iterable)((List)destination$iv$iv));
            object = relevantItems.iterator();
            while (object.hasNext()) {
                int index = ((Number)object.next()).intValue();
                ItemsDecoratorInitializer.Companion.markAsRelevant(lookup, $this$markRelevantItemsIfNeeded.get(index));
            }
        }
        return $this$markRelevantItemsIfNeeded;
    }

    private final ItemRankInfo getCachedRankInfo(LookupElement element, int prefixLength, int position) {
        ItemRankInfo cached = this.cachedScore.get(element);
        if (cached != null && prefixLength == cached.getPrefixLength() && cached.getPositionBefore() == position) {
            return cached;
        }
        return null;
    }

    private final Double calculateElementScore(RankingModelWrapper ranker, LookupElement element, int position, RankingFeatures features2, int prefixLength) {
        Double mlRank = ranker != null && ranker.canScore(features2) ? ranker.score(features2) : null;
        ItemRankInfo info = new ItemRankInfo(position, mlRank, prefixLength);
        this.cachedScore.put(element, info);
        return info.getMlRank();
    }

    private final boolean isIgnored(LookupElement $this$isIgnored) {
        if ($this$isIgnored instanceof MLRankingIgnorable) {
            return true;
        }
        LookupElement item = $this$isIgnored;
        while (item instanceof LookupElementDecorator) {
            Intrinsics.checkNotNullExpressionValue((Object)((LookupElementDecorator)item).getDelegate(), (String)"item.delegate");
            if (!(item instanceof MLRankingIgnorable)) continue;
            return true;
        }
        return false;
    }

    public static final /* synthetic */ Double access$calculateElementScore(MLSorter $this, RankingModelWrapper ranker, LookupElement element, int position, RankingFeatures features2, int prefixLength) {
        return $this.calculateElementScore(ranker, element, position, features2, prefixLength);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MLSorter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/completion/ml/sorting/MLSorter$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "REORDER_ONLY_TOP_K", "", "intellij.completionMlRanking"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tJ\u001a\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\rR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/completion/ml/sorting/MLSorter$MeaningfulFeaturesExtractor;", "", "()V", "meaningful", "", "", "values", "", "meaningfulFeatures", "", "processFeatures", "", "features", "", "intellij.completionMlRanking"})
    private static final class MeaningfulFeaturesExtractor {
        @NotNull
        private final Set<String> meaningful = new LinkedHashSet();
        @NotNull
        private final Map<String, Object> values = new LinkedHashMap();

        public final void processFeatures(@NotNull Map<String, ? extends Object> features2) {
            Intrinsics.checkNotNullParameter(features2, (String)"features");
            for (Map.Entry<String, ? extends Object> feature : features2.entrySet()) {
                Object object = this.values.get(feature.getKey());
                if (object == null) {
                    this.values.put(feature.getKey(), feature.getValue());
                    continue;
                }
                if (Intrinsics.areEqual((Object)object, (Object)feature.getValue())) continue;
                this.meaningful.add(feature.getKey());
            }
        }

        @NotNull
        public final Set<String> meaningfulFeatures() {
            return this.meaningful;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001d\u0010\u000b\u001a\u0004\u0018\u00010\f2\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000e\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/completion/ml/sorting/MLSorter$ModelTimeTracker;", "", "()V", "itemsScored", "", "timeSpent", "", "finished", "", "performanceTracker", "Lcom/intellij/completion/ml/performance/MLCompletionPerformanceTracker;", "measure", "", "scoringFun", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Double;", "intellij.completionMlRanking"})
    private static final class ModelTimeTracker {
        private int itemsScored;
        private long timeSpent;

        @Nullable
        public final Double measure(@NotNull Function0<Double> scoringFun) {
            Intrinsics.checkNotNullParameter(scoringFun, (String)"scoringFun");
            long start = System.nanoTime();
            Double result = (Double)scoringFun.invoke();
            if (result != null) {
                ++this.itemsScored;
                this.timeSpent += System.nanoTime() - start;
            }
            return result;
        }

        public final void finished(@NotNull MLCompletionPerformanceTracker performanceTracker) {
            Intrinsics.checkNotNullParameter((Object)performanceTracker, (String)"performanceTracker");
            if (this.itemsScored != 0) {
                performanceTracker.itemsScored(this.itemsScored, TimeUnit.NANOSECONDS.toMillis(this.timeSpent));
            }
        }
    }
}

