/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.settings;

import com.intellij.completion.ml.experiment.ExperimentInfo;
import com.intellij.completion.ml.experiment.ExperimentStatus;
import com.intellij.completion.ml.ranker.ExperimentModelProvider;
import com.intellij.completion.ml.settings.MLCompletionSettingsCollector;
import com.intellij.completion.ml.sorting.RankingSupport;
import com.intellij.internal.ml.completion.DecoratingItemsPolicy;
import com.intellij.internal.ml.completion.RankingModelProvider;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@com.intellij.openapi.components.State(name="CompletionMLRankingSettings", storages={@Storage(value="completionMLRanking.xml", roamingType=RoamingType.DISABLED)})
public final class CompletionMLRankingSettings
implements PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance(CompletionMLRankingSettings.class);
    private final State myState = new State();

    @NotNull
    public static CompletionMLRankingSettings getInstance() {
        return (CompletionMLRankingSettings)ApplicationManager.getApplication().getService(CompletionMLRankingSettings.class);
    }

    public boolean isRankingEnabled() {
        return this.myState.rankingEnabled;
    }

    public boolean isShowDiffEnabled() {
        return this.myState.showDiff;
    }

    public boolean isDecorateRelevantEnabled() {
        return this.myState.decorateRelevant;
    }

    public void setRankingEnabled(boolean value) {
        if (value == this.isRankingEnabled()) {
            return;
        }
        this.myState.rankingEnabled = value;
        CompletionMLRankingSettings.disableExperiment();
        this.triggerSettingsChanged(value);
    }

    public boolean isLanguageEnabled(@NotNull String rankerId) {
        return this.myState.language2state.getOrDefault(rankerId, false);
    }

    public void setLanguageEnabled(@NotNull String rankerId, boolean isEnabled) {
        if (isEnabled == this.isLanguageEnabled(rankerId)) {
            return;
        }
        this.myState.language2state.put(rankerId, isEnabled);
        this.logCompletionState(rankerId, isEnabled);
        CompletionMLRankingSettings.disableExperiment();
        if (this.isRankingEnabled()) {
            MLCompletionSettingsCollector.rankingSettingsChanged(rankerId, isEnabled, CompletionMLRankingSettings.isEnabledByDefault(rankerId), true);
        }
    }

    public void setShowDiffEnabled(boolean isEnabled) {
        if (isEnabled == this.isShowDiffEnabled()) {
            return;
        }
        this.myState.showDiff = isEnabled;
        CompletionMLRankingSettings.disableExperiment();
        MLCompletionSettingsCollector.decorationSettingChanged(isEnabled);
    }

    public void setDecorateRelevantEnabled(boolean isEnabled) {
        this.myState.decorateRelevant = isEnabled;
    }

    @ApiStatus.Internal
    public void updateShowDiffInExperiment(boolean isEnabled) {
        this.myState.showDiff = isEnabled;
    }

    @NotNull
    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        this.myState.rankingEnabled = state.rankingEnabled;
        this.myState.showDiff = state.showDiff;
        this.myState.language2state.putAll(state.language2state);
    }

    private void logCompletionState(@NotNull String languageName, boolean isEnabled) {
        boolean enabled = this.myState.rankingEnabled && isEnabled;
        boolean showDiff = enabled && this.myState.showDiff;
        LOG.info("ML Completion " + (enabled ? "enabled" : "disabled") + " ,show diff " + (showDiff ? "on" : "off") + " for: " + languageName);
    }

    private static void disableExperiment() {
        ExperimentStatus status = ExperimentStatus.Companion.getInstance();
        if (!status.isDisabled()) {
            LOG.info("Leave A/B ML completion experiment group");
        }
        status.disable();
    }

    private static boolean isEnabledByDefault(@NotNull String rankerId) {
        return ExperimentModelProvider.enabledByDefault().contains(rankerId);
    }

    private void triggerSettingsChanged(boolean enabled) {
        for (String ranker : this.getEnabledRankers()) {
            MLCompletionSettingsCollector.rankingSettingsChanged(ranker, enabled, CompletionMLRankingSettings.isEnabledByDefault(ranker), false);
        }
    }

    private List<String> getEnabledRankers() {
        return this.myState.language2state.entrySet().stream().filter(x -> (Boolean)x.getValue()).map(x -> (String)x.getKey()).collect(Collectors.toList());
    }

    public static final class State {
        public boolean rankingEnabled;
        public boolean showDiff;
        public boolean decorateRelevant;
        public final Map<String, Boolean> language2state = new HashMap<String, Boolean>();

        public State() {
            ExperimentStatus experimentStatus = ExperimentStatus.Companion.getInstance();
            boolean isEAP = ApplicationInfoEx.getInstanceEx().isEAP();
            for (Language language : Language.getRegisteredLanguages()) {
                RankingModelProvider ranker = RankingSupport.INSTANCE.findProviderSafe(language);
                if (ranker == null) continue;
                ExperimentInfo experimentInfo = experimentStatus.forLanguage(language);
                if (!experimentStatus.isDisabled() && experimentInfo.getInExperiment()) {
                    boolean useMLRanking = experimentInfo.getShouldRank();
                    this.language2state.put(ranker.getId(), useMLRanking);
                    if (!useMLRanking) continue;
                    LOG.info("ML Completion enabled, experiment group=" + experimentInfo.getVersion() + " for: " + language.getDisplayName());
                    continue;
                }
                this.language2state.put(ranker.getId(), ranker.isEnabledByDefault());
                if (!isEAP) continue;
                this.decorateRelevant |= ranker.getDecoratingPolicy() != DecoratingItemsPolicy.Companion.getDISABLED();
            }
            this.rankingEnabled = this.language2state.containsValue(true);
        }
    }
}

