/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.personalization.impl;

import com.intellij.completion.ml.personalization.Day;
import com.intellij.completion.ml.personalization.impl.DailyAggregatedDoubleFactor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ&\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\bJ6\u0010\u0013\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bJ,\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u00192\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\bH\u0002J\"\u0010\u001c\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u00192\u0006\u0010\u001d\u001a\u00020\bJ\"\u0010\u001e\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u00192\u0006\u0010\u001d\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/completion/ml/personalization/impl/FactorsUtil;", "", "()V", "AVERAGE", "", "COUNT", "VARIANCE", "calculateAverageByAllDays", "", "factor", "Lcom/intellij/completion/ml/personalization/impl/DailyAggregatedDoubleFactor;", "(Lcom/intellij/completion/ml/personalization/impl/DailyAggregatedDoubleFactor;)Ljava/lang/Double;", "calculateVarianceByAllDays", "mergeAverage", "n1", "", "avg1", "n2", "avg2", "mergeVariance", "variance1", "variance2", "updateAverage", "", "map", "", "count", "avg", "updateAverageAndVariance", "valueToAdd", "updateAverageValue", "intellij.completionMlRanking"})
public final class FactorsUtil {
    @NotNull
    public static final FactorsUtil INSTANCE = new FactorsUtil();
    @NotNull
    private static final String COUNT = "count";
    @NotNull
    private static final String AVERAGE = "average";
    @NotNull
    private static final String VARIANCE = "variance";

    private FactorsUtil() {
    }

    public final double mergeAverage(int n1, double avg1, int n2, double avg2) {
        if (n1 == 0 && n2 == 0) {
            return 0.0;
        }
        double total = n1 + n2;
        return (double)n1 / total * avg1 + (double)n2 / total * avg2;
    }

    public final double mergeVariance(int n1, double variance1, double avg1, int n2, double variance2, double avg2) {
        if (n1 == 0 && n2 == 0) {
            return 0.0;
        }
        if (n1 == 0) {
            return variance2;
        }
        if (n2 == 0) {
            return variance1;
        }
        double total = n1 + n2;
        double rawSecondMoment1 = variance1 + avg1 * avg1;
        double rawSecondMoment2 = variance2 + avg2 * avg2;
        double rawSecondMoment = (double)n1 / total * rawSecondMoment1 + (double)n2 / total * rawSecondMoment2;
        double $this$mergeVariance_u24lambda_u240 = this.mergeAverage(n1, avg1, n2, avg2);
        boolean bl = false;
        double avgSquare = $this$mergeVariance_u24lambda_u240 * $this$mergeVariance_u24lambda_u240;
        return rawSecondMoment - avgSquare;
    }

    public final void updateAverageValue(@NotNull Map<String, Double> map, double valueToAdd) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Double d = map.get(COUNT);
        Integer count = d != null ? Integer.valueOf((int)d.doubleValue()) : null;
        Double avg = map.get(AVERAGE);
        if (count != null && avg != null) {
            double newAverage = this.mergeAverage(1, valueToAdd, count, avg);
            this.updateAverage(map, 1 + count, newAverage);
        } else {
            this.updateAverage(map, 1, valueToAdd);
        }
    }

    public final void updateAverageAndVariance(@NotNull Map<String, Double> map, double valueToAdd) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        this.updateAverageValue(map, valueToAdd);
        Double count = map.get(COUNT);
        Double average = map.get(AVERAGE);
        Double variance = map.get(VARIANCE);
        if (count != null && average != null && variance != null) {
            FactorsUtil.updateAverageAndVariance$update(map, (int)count.doubleValue() + 1, this.mergeAverage(1, valueToAdd, (int)count.doubleValue(), average), this.mergeVariance(1, 0.0, valueToAdd, (int)count.doubleValue(), variance, average));
        } else {
            FactorsUtil.updateAverageAndVariance$update(map, 1, valueToAdd, 0.0);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Double calculateAverageByAllDays(@NotNull DailyAggregatedDoubleFactor factor) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)factor, (String)"factor");
        int totalCount = 0;
        double average = 0.0;
        boolean present = false;
        Iterable $this$mapNotNull$iv = factor.availableDays();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Map<String, Double> it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Day it = (Day)element$iv$iv;
            boolean bl2 = false;
            if (factor.onDate(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        for (Map onDate : (List)destination$iv$iv) {
            Integer count;
            Double avg = (Double)onDate.get(AVERAGE);
            Double d = (Double)onDate.get(COUNT);
            Integer n = count = d != null ? Integer.valueOf((int)d.doubleValue()) : null;
            if (avg == null || count == null || count <= 0) continue;
            present = true;
            average = this.mergeAverage(totalCount, average, count, avg);
            totalCount += count.intValue();
        }
        return present ? Double.valueOf(average) : null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Double calculateVarianceByAllDays(@NotNull DailyAggregatedDoubleFactor factor) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)factor, (String)"factor");
        int totalCount = 0;
        double variance = 0.0;
        boolean present = false;
        double average = 0.0;
        Iterable $this$mapNotNull$iv = factor.availableDays();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Map<String, Double> it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Day it = (Day)element$iv$iv;
            boolean bl2 = false;
            if (factor.onDate(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        for (Map onDate : (List)destination$iv$iv) {
            Double avg = (Double)onDate.get(VARIANCE);
            Double d = (Double)onDate.get(COUNT);
            Integer count = d != null ? Integer.valueOf((int)d.doubleValue()) : null;
            Double varianceOnDate = (Double)onDate.get(VARIANCE);
            if (avg == null || count == null || count <= 0 || varianceOnDate == null) continue;
            present = true;
            variance = this.mergeVariance(totalCount, variance, average, count, varianceOnDate, avg);
            average = this.mergeAverage(totalCount, average, count, avg);
            totalCount += count.intValue();
        }
        return present ? Double.valueOf(variance) : null;
    }

    private final void updateAverage(Map<String, Double> map, int count, double avg) {
        map.put(COUNT, Double.valueOf(count));
        Double d = avg;
        map.put(AVERAGE, d);
    }

    private static final Map<String, Double> updateAverageAndVariance$update(Map<String, Double> $map, int count, double average, double variance) {
        Map<String, Double> map;
        Map<String, Double> $this$updateAverageAndVariance_u24update_u24lambda_u241 = map = $map;
        boolean bl = false;
        $this$updateAverageAndVariance_u24update_u24lambda_u241.put(COUNT, Double.valueOf(count));
        Double d = average;
        $this$updateAverageAndVariance_u24update_u24lambda_u241.put(AVERAGE, d);
        d = variance;
        $this$updateAverageAndVariance_u24update_u24lambda_u241.put(VARIANCE, d);
        return map;
    }
}

